/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.map.IContainer;
import com.indy.map.Map;
import com.indy.map.Template;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RefPackage;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.osgi.service.log.LogService;

public class TemplateInfo {
    private String targetConnection;
    private String description;
    private String name;
    private String nodeCode;
    private List<IContainer> ref = new ArrayList<IContainer>();
    private List<IContainer> targetRef = new ArrayList<IContainer>();
    private IMetaDataInformationsProvider.EvaluationLocation trgConnectionEvaluationMode;
    private Map map;
    private String templateCriteria;
    IContainer[] targetRefArray = null;

    TemplateInfo(Map mapModel) {
        this.map = mapModel;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNodeCode() {
        return this.nodeCode;
    }

    public void setNodeCode(String nodeCode) {
        this.nodeCode = nodeCode;
    }

    public String getTemplateCriteria() {
        return this.templateCriteria;
    }

    public void setTemplateCriteria(String templateCriteria) {
        this.templateCriteria = templateCriteria;
    }

    public String getTargetConnection() {
        return this.targetConnection;
    }

    public void setTargetConnection(String targetConnection, IMetaDataInformationsProvider.EvaluationLocation trgEvaluationMode) {
        this.targetConnection = targetConnection;
        this.trgConnectionEvaluationMode = trgEvaluationMode;
    }

    public List<IContainer> getRef() {
        return this.ref;
    }

    public List<IContainer> getTargetRef() {
        return this.targetRef;
    }

    public void initTemplate(Template t) {
        if (t.getName() == null) {
            t.setName(this.getName());
        }
        RLoadSet load = null;
        for (RLoadSet l : ((RMap)this.map.getMapReference()).getLoadSet()) {
            if (this.getName().charAt(0) != 'L' || !l.getContainer().containsAll(this.getRef()) || !this.getRef().containsAll((Collection<?>)l.getContainer())) continue;
            load = l;
            break;
        }
        RTemplate ref = (RTemplate)t.getMapReference();
        ref.eSetDeliver(false);
        if (ref.getLoad() != load) {
            ref.setLoad(load);
        }
        ref.setDescription(this.getDescription());
        ref.setNodeCode(this.getNodeCode());
        ref.setTemplateCriteria(this.getTemplateCriteria());
        ref.getRef().retainAll(this.getRef());
        ref.getRef().addAll(this.getRef());
        ref.eSetDeliver(false);
        ref.getTargetRef().retainAll(this.getTargetRef());
        ref.getTargetRef().addAll(this.getTargetRef());
        ref.eSetDeliver(true);
        ref.eNotify((Notification)new ENotificationImpl((InternalEObject)ref, 5, (EStructuralFeature)RefPackage.eINSTANCE.getRTemplate_TargetRef(), null, ref.getTargetRef()));
    }

    public void order() {
        Collections.sort(this.ref, new ContainerComparator());
        Collections.sort(this.targetRef, new ContainerComparator());
    }

    public IContainer[] getTargetRefArray() {
        if (this.targetRefArray == null) {
            this.targetRefArray = this.targetRef.toArray(new IContainer[this.targetRef.size()]);
        }
        return this.targetRefArray;
    }

    public Notification refreshSrcTrgAlias(Template current) {
        if (current != null) {
            ArrayList removed;
            ArrayList<String> added;
            block13: {
                boolean oldDevliver = ((EObjectImpl)current).eDeliver();
                added = new ArrayList<String>();
                removed = new ArrayList();
                ArrayList<String> old = new ArrayList<String>();
                try {
                    try {
                        current.eSetDeliver(false);
                        RTemplate r = (RTemplate)current.getMapReference();
                        if (r != null) {
                            RLoadSet load = r.getLoad();
                            old.addAll((Collection<String>)current.getTargetId());
                            if (load != null) {
                                if (load.eContainer() == null) {
                                    for (RLoadSet l : ((RMap)this.map.getMapReference()).getLoadSet()) {
                                        if (!l.getContainer().containsAll(this.getRef()) || !this.getRef().containsAll((Collection<?>)l.getContainer())) continue;
                                        load = l;
                                        r.setLoad(load);
                                        break;
                                    }
                                }
                                old.addAll((Collection<String>)current.getSourceId());
                                current.getSourceId().clear();
                                for (IContainer c : load.getContainer()) {
                                    current.getSourceId().add((Object)c.getId());
                                    if (old.contains(c.getId())) continue;
                                    added.add(c.getId());
                                }
                            }
                            current.getTargetId().clear();
                            for (IContainer c : r.getTargetRef()) {
                                current.getTargetId().add((Object)c.getId());
                                if (old.contains(c.getId())) continue;
                                added.add(c.getId());
                            }
                            removed.addAll(old);
                            removed.removeAll((Collection<?>)current.getSourceId());
                            removed.removeAll((Collection<?>)current.getTargetId());
                        }
                    }
                    catch (Exception ex) {
                        ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.map").error(Messages.UpdateInstanceCommand_2 + current.getName() + Messages.UpdateInstanceCommand_3, (Object)ex);
                        current.eSetDeliver(oldDevliver);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    current.eSetDeliver(oldDevliver);
                    throw throwable;
                }
                current.eSetDeliver(oldDevliver);
            }
            if (!added.isEmpty() || !removed.isEmpty()) {
                return new ENotificationImpl((InternalEObject)current, 9002, null, removed, added);
            }
        }
        return null;
    }

    public IMetaDataInformationsProvider.EvaluationLocation getTrgEvaluationMode() {
        return this.trgConnectionEvaluationMode;
    }

    private class ContainerComparator
    implements Comparator<IContainer> {
        private ContainerComparator() {
        }

        @Override
        public int compare(IContainer o1, IContainer o2) {
            return o1.getAlias().toString().compareTo(o2.getAlias().toString());
        }
    }

    public static class TemplateInfoComparator
    implements Comparator<TemplateInfo> {
        @Override
        public int compare(TemplateInfo o1, TemplateInfo o2) {
            StringBuffer s1 = new StringBuffer();
            for (IContainer c : o1.getRef()) {
                s1.append("_" + String.valueOf(c.getAlias()));
            }
            StringBuffer s2 = new StringBuffer();
            for (IContainer c : o2.getRef()) {
                s2.append("_" + String.valueOf(c.getAlias()));
            }
            return s1.toString().compareTo(s2.toString());
        }
    }
}

