/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.gmf.proc.ActionProcess;
import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.Datastore;
import com.indy.map.IContainer;
import com.indy.map.IMetaData;
import com.indy.map.ISerde;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.MapFactory;
import com.indy.map.Parameter;
import com.indy.map.Query;
import com.indy.map.Template;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.compute.Computer;
import com.indy.map.compute.graph.builder.FlowGraphBuilder;
import com.indy.map.custom.commands.CriteriaGenerator;
import com.indy.map.custom.commands.TemplateInfo;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RefPackage;
import com.indy.map.util.TemplateCapabilityHelper;
import com.semarchy.xdi.designer.core.services.ITemplateProvider;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class UpdateInstanceCommand
extends RecordingCommand {
    private Map map;
    private FlowGraphBuilder.GraphNavigator flowNavigator;
    private int currentLoadNumber = 0;
    protected List<TemplateInfo> templates = new ArrayList<TemplateInfo>();
    private HashMap<Object, List<IContainer>> done = new HashMap();
    private List<IContainer> isCollected = new ArrayList<IContainer>();
    private CriteriaGenerator trgCriteriaInfos = new CriteriaGenerator(this);

    protected Map getMap() {
        return this.map;
    }

    protected FlowGraphBuilder.GraphNavigator getFlowNavigator() {
        return this.flowNavigator;
    }

    public UpdateInstanceCommand(TransactionalEditingDomain domain, Map map) {
        super(domain, Messages.UpdateInstanceCommand_4);
        this.map = map;
    }

    public void dispose() {
        this.templates.clear();
        this.done.clear();
        this.map = null;
        this.flowNavigator = null;
        this.trgCriteriaInfos = null;
        super.dispose();
    }

    protected void doExecute() {
        try {
            Computer.INSTANCE.compute(this.map);
            this.flowNavigator = FlowGraphBuilder.createGraphNavigator(this.map);
            this.done.clear();
            this.currentLoadNumber = 0;
            for (Template t : this.map.getTemplate()) {
                if (!(t.getProcess() instanceof ActionProcess) || t.getProcess().eIsProxy()) continue;
                for (com.indy.gmf.proc.Parameter p : ((ActionProcess)t.getProcess()).getParameter()) {
                    Parameter mapP;
                    if (!p.isDefaultValueForced() || (mapP = t.getParameter(p.getName())) != null) continue;
                    mapP = MapFactory.eINSTANCE.createParameter();
                    mapP.setName(p.getName());
                    mapP.setValue(p.getValue());
                    t.getParameter().add((Object)mapP);
                }
            }
            for (FlowGraphBuilder.TargetSet targetSetNode : this.flowNavigator.getTargetSetNodes()) {
                this.isCollected.clear();
                this.createLoadTemplate(targetSetNode);
                this.createIntegrationTemplate(targetSetNode);
                this.createCheckTemplate(targetSetNode);
            }
            HashMap loadTemplate = new HashMap();
            for (TemplateInfo i : this.templates) {
                if (!i.getName().startsWith("L")) continue;
                i.order();
                Object[] key = null;
                for (Object[] k : loadTemplate.keySet()) {
                    if (!Arrays.equals(k, i.getTargetRefArray())) continue;
                    key = k;
                    break;
                }
                if (key == null) {
                    key = i.getTargetRefArray();
                    loadTemplate.put((IContainer[])key, new ArrayList());
                    ((List)loadTemplate.get(key)).add(i);
                }
                if (((List)loadTemplate.get(key)).contains(i)) continue;
                ((List)loadTemplate.get(key)).add(i);
            }
            for (Map.Entry e : loadTemplate.entrySet()) {
                int num = 0;
                StringBuilder postfix = new StringBuilder();
                Collections.sort((List)e.getValue(), new TemplateInfo.TemplateInfoComparator());
                IContainer[] iContainerArray = (IContainer[])e.getKey();
                int n = iContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer c = iContainerArray[n2];
                    postfix.append("_");
                    postfix.append(c.getAlias());
                    ++n2;
                }
                for (TemplateInfo i : (List)e.getValue()) {
                    i.setName("L" + ++num + postfix.toString());
                }
            }
            Iterator<TemplateInfo> it = this.templates.iterator();
            while (it.hasNext()) {
                TemplateInfo inf = it.next();
                if (!inf.getTargetRef().isEmpty()) continue;
                it.remove();
            }
            this.updateInstances();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void createCheckTemplate(FlowGraphBuilder.TargetSet targetSet) {
        for (IContainer target : targetSet.getContainers()) {
            Datastore datastore;
            if (!(target instanceof Datastore) || !(datastore = (Datastore)target).isControl() || !Boolean.TRUE.equals(this.trgCriteriaInfos.hasWorkspaceCapability(target))) continue;
            for (Template i : this.map.getTemplate()) {
                if (!i.getName().startsWith("I") || !(i.getProcess() instanceof ActionProcess) || !((RTemplate)i.getMapReference()).getTargetRef().isEmpty() && !((RTemplate)i.getMapReference()).getTargetRef().contains((Object)target) || UpdateInstanceCommand.checkTemplateSupportCheck(i, target)) continue;
                return;
            }
            TemplateInfo checkInstance = new TemplateInfo(this.map);
            String targetCon = this.extractConnectionId(target.getAPI().getMdEvaluator().evaluateConnection(target, IMetaDataInformationsProvider.EvaluationLocation.ON_REF));
            checkInstance.setTargetConnection(targetCon, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
            checkInstance.setDescription("Check : " + String.valueOf(target.getAlias()));
            checkInstance.setTemplateCriteria(this.trgCriteriaInfos.getCheckTemplateCriteria(target));
            checkInstance.setNodeCode("com.stambia.flow.step");
            checkInstance.setName(String.format("%s_%s", RTemplate.Type.REJECT.getMappingTemplateNamePrefix(), target.getAlias()));
            checkInstance.getTargetRef().add(target);
            this.templates.add(checkInstance);
        }
    }

    public static boolean checkTemplateSupportCheck(Template template, IContainer target2) {
        return TemplateCapabilityHelper.supportCapability(template, "template-feature-support", "reject", true);
    }

    public static boolean checkTemplateSupportLoad(Template template) {
        return TemplateCapabilityHelper.supportCapability(template, "template-feature-support", "load", true);
    }

    private String extractConnectionId(EObject obj) {
        if (obj != null) {
            String eltId = CacheHelper.extractEltID((EObject)obj);
            String fileId = CacheHelper.extractFileID((EObject)obj);
            if (eltId != null && fileId != null) {
                return eltId + "?fileId=" + fileId + "?";
            }
        }
        return null;
    }

    private void createLoadTemplate(FlowGraphBuilder.TargetSet ts) {
        ArrayList<TemplateInfo> curTemplates = new ArrayList<TemplateInfo>();
        Iterator<IContainer> iterator = ts.getContainers().iterator();
        while (iterator.hasNext()) {
            IContainer cTarget;
            IContainer target = cTarget = iterator.next();
            boolean computeTrgCriteria = false;
            if (cTarget instanceof Query || cTarget instanceof ISerde) {
                EObject targetRef = target.getAPI().getMdEvaluator().evaluateConnection(target, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                computeTrgCriteria = targetRef != null;
            } else if (cTarget instanceof IMetaData) {
                EObject obj = ((IMetaData)((Object)target)).basicGetRef();
                computeTrgCriteria = obj != null;
                this.trgCriteriaInfos.computeCriteria(cTarget);
            }
            if (!computeTrgCriteria) continue;
            this.trgCriteriaInfos.computeCriteria(cTarget);
            String targetCon = this.extractConnectionId(target.getAPI().getMdEvaluator().evaluateConnection(target, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING));
            if (targetCon != null) {
                this.done.computeIfAbsent(targetCon, k -> new ArrayList());
            }
            ArrayList<DataSet> inputs = new ArrayList<DataSet>();
            for (DataSet ds : this.flowNavigator.getDataSetInputs(ts)) {
                if (ds == null || inputs.contains(ds)) continue;
                inputs.add(ds);
            }
            boolean hasLoad = this.trgCriteriaInfos.hasLoad(ts, cTarget);
            for (DataSet dataSet : inputs) {
                for (IContainer c : dataSet.getContainer()) {
                    String sourceCon = this.extractConnectionId(c.getAPI().getMdEvaluator().evaluateConnection(c, IMetaDataInformationsProvider.EvaluationLocation.ON_REF));
                    if (sourceCon != null && targetCon != null && targetCon.equals(sourceCon) || targetCon == null) continue;
                    if (!this.done.get(targetCon).contains(c)) {
                        TemplateInfo template = new TemplateInfo(this.map);
                        template.setTargetConnection(targetCon, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
                        template.setName(String.format("%s%s_%s", RTemplate.Type.LOAD.getMappingTemplateNamePrefix(), ++this.currentLoadNumber, target.getAlias()));
                        curTemplates.add(template);
                        this.addSource(targetCon, target, c, template.getRef(), inputs);
                        if (hasLoad) {
                            this.isCollected.addAll(template.getRef());
                        }
                        template.setNodeCode("com.stambia.flow.step");
                        continue;
                    }
                    if (!hasLoad) continue;
                    for (TemplateInfo t : curTemplates) {
                        if (!t.getRef().contains(c) || !t.getName().startsWith(RTemplate.Type.LOAD.getMappingTemplateNamePrefix()) || t.getTargetRef().contains(target)) continue;
                        t.getTargetRef().add(target);
                    }
                    for (TemplateInfo t : this.templates) {
                        if (t.getTargetConnection() == null || !t.getTargetConnection().equals(targetCon) || !t.getRef().contains(c) || !t.getName().startsWith(RTemplate.Type.LOAD.getMappingTemplateNamePrefix()) || t.getTargetRef().contains(target)) continue;
                        t.getTargetRef().add(target);
                    }
                }
            }
            for (TemplateInfo instance : curTemplates) {
                String description = String.format("Load : %s", instance.getRef().stream().map(md -> md.getAlias().toString()).collect(Collectors.joining(", ")));
                if (hasLoad && !instance.getTargetRef().contains(target)) {
                    instance.getTargetRef().add(target);
                }
                instance.setDescription(description);
                instance.setTemplateCriteria(this.trgCriteriaInfos.getLoadTemplateCriteria(cTarget, instance));
            }
        }
        this.templates.addAll(curTemplates);
    }

    protected void createIntegrationTemplate(FlowGraphBuilder.TargetSet ts) {
        for (IContainer c : ts.getContainers()) {
            TemplateInfo integrationInstance = new TemplateInfo(this.map);
            integrationInstance.setNodeCode("com.stambia.flow.step");
            integrationInstance.setName(String.format("%s_%s", RTemplate.Type.INTEGRATION.getMappingTemplateNamePrefix(), c.getAlias()));
            integrationInstance.getTargetRef().add(c);
            HashSet<String> srcProducts = new HashSet<String>();
            HashSet<String> srcTechs = new HashSet<String>();
            if (c.hasStagingArea()) {
                srcProducts.add(c.getAPI().getMdEvaluator().evaluateProductCode(c, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING));
                srcTechs.add(c.getAPI().getMdEvaluator().evaluateTechCode(c, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING));
                targetCon = this.extractConnectionId(c.getAPI().getMdEvaluator().evaluateConnection(c, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING));
                integrationInstance.setTargetConnection(targetCon, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
            } else {
                targetCon = this.extractConnectionId(c.getAPI().getMdEvaluator().evaluateConnection(c, IMetaDataInformationsProvider.EvaluationLocation.ON_REF));
                integrationInstance.setTargetConnection(targetCon, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                List<DataSet> dss = this.flowNavigator.getDataSetInputs(ts);
                for (DataSet ds : dss) {
                    if (ds == null) continue;
                    for (IContainer con : ds.getContainer()) {
                        EObject node;
                        if (!this.isCollected.contains(con)) {
                            integrationInstance.getRef().add(con);
                        }
                        if (!(con instanceof IMetaData) || (node = ((IMetaData)((Object)con)).basicGetRef()) == null) continue;
                        try {
                            String productCode = con.getAPI().getMdEvaluator().evaluateProductCode(con, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                            if (productCode != null) {
                                this.trgCriteriaInfos.addSourceProduct(c, productCode);
                                srcProducts.add(productCode);
                            }
                        }
                        catch (Exception productCode) {
                            // empty catch block
                        }
                        try {
                            String techCode = con.getAPI().getMdEvaluator().evaluateTechCode(con, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                            if (techCode == null) continue;
                            this.trgCriteriaInfos.addSourceTech(c, techCode);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            integrationInstance.setTemplateCriteria(this.trgCriteriaInfos.getIntegrationTemplateCriteria(ts, c));
            this.templates.add(integrationInstance);
        }
    }

    private void addSource(String targetCon, IContainer target, IContainer source, List<IContainer> sources, List<DataSet> involvedDataset) {
        if (!((RMap)this.map.getMapReference()).getTargetSetRef(target).getSourceSet().contains(source)) {
            return;
        }
        sources.add(source);
        this.done.get(targetCon).add(source);
        ArrayList clauses = new ArrayList(this.map.getJoin(source));
        clauses.addAll(this.map.getFilter(source));
        for (Clause cl : clauses) {
            if (!cl.isEnable() || cl.getLocation() != JoinLocation.SRC) continue;
            for (IContainer c : cl.getInvolvedContainers()) {
                if (this.done.get(targetCon).contains(c)) continue;
                this.addSource(targetCon, target, c, sources, involvedDataset);
            }
        }
    }

    protected Template findMappingMatching(TemplateInfo info) {
        ArrayList<Template> candidateByRef = new ArrayList<Template>();
        for (Template t : this.map.getTemplate()) {
            String targetCon;
            RTemplate refT;
            if (info.getName().charAt(0) != t.getName().charAt(0) || (refT = (RTemplate)t.getMapReference()) == null || Collections.disjoint(refT.getTargetRef(), info.getTargetRef()) || (targetCon = this.extractConnectionId(((IContainer)refT.getTargetRef().get(0)).getAPI().getMdEvaluator().evaluateConnection((IContainer)refT.getTargetRef().get(0), info.getTrgEvaluationMode()))) == null || !targetCon.equals(info.getTargetConnection())) continue;
            if (refT.getLoad() != null) {
                if (Collections.disjoint(refT.getLoad().getContainer(), info.getRef())) continue;
                candidateByRef.add(t);
                continue;
            }
            candidateByRef.add(t);
        }
        if (!candidateByRef.isEmpty()) {
            return (Template)candidateByRef.get(0);
        }
        return null;
    }

    protected void updateInstances() throws Exception {
        Template t;
        ArrayList<Template> instanceToDelete = new ArrayList<Template>();
        ArrayList<Template> createdTemplate = new ArrayList<Template>();
        ArrayList<Object> tplSrcChangeNotification = new ArrayList<Object>();
        instanceToDelete.addAll((Collection<Template>)this.map.getTemplate());
        for (TemplateInfo instance : this.templates) {
            Notification n;
            List list;
            Template current = this.findMappingMatching(instance);
            if (current != null) {
                instanceToDelete.remove(current);
                RTemplate ref = (RTemplate)current.getMapReference();
                ref.setDescription(instance.getDescription());
                ref.setNodeCode(instance.getNodeCode());
                ref.setTemplateCriteria(instance.getTemplateCriteria());
                current.setName(instance.getName());
                ref.eSetDeliver(false);
                if (current.getName().startsWith("L")) {
                    for (FlowGraphBuilder.TargetSet ts : this.flowNavigator.getTargetSetNodes()) {
                        if (this.trgCriteriaInfos.hasLoad(ts, ts.getContainers().get(0))) continue;
                        instance.getTargetRef().removeAll(ts.getRefModel().getContainerModel());
                    }
                }
                ref.getTargetRef().retainAll(instance.getTargetRef());
                ref.getTargetRef().addAll(instance.getTargetRef());
                ref.eSetDeliver(true);
                ref.eNotify((Notification)new ENotificationImpl((InternalEObject)ref, 5, (EStructuralFeature)RefPackage.eINSTANCE.getRTemplate_TargetRef(), null, ref.getTargetRef()));
            } else if (!instance.getTargetRef().isEmpty()) {
                Template t2 = MapFactory.eINSTANCE.createTemplate();
                t2.setName(instance.getName());
                this.map.getTemplate().add((Object)t2);
                instance.initTemplate(t2);
                current = t2;
                createdTemplate.add(t2);
            }
            if (current == null) continue;
            if (current.getProcess() == null && !(list = ((ITemplateProvider)E4InjectorHelper.getService(ITemplateProvider.class)).getTemplate(((RTemplate)current.getMapReference()).getTemplateCriteria(), (EObject)this.map)).isEmpty()) {
                boolean b = current.eDeliver();
                try {
                    current.eSetDeliver(false);
                    current.setProcess((EObject)list.get(0));
                }
                finally {
                    current.eSetDeliver(b);
                }
            }
            if ((n = instance.refreshSrcTrgAlias(current)) == null) continue;
            tplSrcChangeNotification.add(n);
        }
        for (Template t3 : instanceToDelete) {
            ((RTemplate)t3.getMapReference()).getTargetRef().clear();
        }
        this.map.getTemplate().removeAll(instanceToDelete);
        Iterator it = createdTemplate.iterator();
        while (it.hasNext()) {
            t = (Template)it.next();
            boolean removed = false;
            Iterator it2 = instanceToDelete.iterator();
            while (it2.hasNext()) {
                Template tt = (Template)it2.next();
                if (!tt.getName().equals(t.getName()) && tt != t) continue;
                ArrayList<String> added = new ArrayList<String>();
                added.addAll((Collection<String>)t.getSourceId());
                added.addAll((Collection<String>)t.getTargetId());
                added.removeAll((Collection<?>)tt.getSourceId());
                added.removeAll((Collection<?>)tt.getTargetId());
                ArrayList<String> removedTplId = new ArrayList<String>();
                removedTplId.addAll((Collection<String>)tt.getSourceId());
                removedTplId.addAll((Collection<String>)tt.getTargetId());
                removedTplId.removeAll((Collection<?>)t.getSourceId());
                removedTplId.removeAll((Collection<?>)t.getTargetId());
                tplSrcChangeNotification.add(new ENotificationImpl((InternalEObject)t, 9002, null, removedTplId, added));
                removed = true;
                it2.remove();
                break;
            }
            if (!removed) continue;
            it.remove();
        }
        it = tplSrcChangeNotification.iterator();
        block8: while (it.hasNext()) {
            Notification n = (Notification)it.next();
            boolean removed = false;
            for (Template t2 : instanceToDelete) {
                if (!((Template)n.getNotifier()).getName().equals(t2.getName()) && n.getNotifier() != t2) continue;
                it.remove();
                removed = true;
                break;
            }
            if (removed) continue;
            for (Template t2 : createdTemplate) {
                if (!((Template)n.getNotifier()).getName().equals(t2.getName()) && n.getNotifier() != t2) continue;
                it.remove();
                continue block8;
            }
        }
        it = instanceToDelete.iterator();
        block11: while (it.hasNext()) {
            t = (Template)it.next();
            for (Template tt : this.map.getTemplate()) {
                if (!tt.getName().equals(t.getName()) && tt != t) continue;
                it.remove();
                ArrayList<String> added = new ArrayList<String>();
                added.addAll((Collection<String>)t.getSourceId());
                added.addAll((Collection<String>)t.getTargetId());
                added.removeAll((Collection<?>)tt.getSourceId());
                added.removeAll((Collection<?>)tt.getTargetId());
                ArrayList<String> removedTplIds = new ArrayList<String>();
                removedTplIds.addAll((Collection<String>)tt.getSourceId());
                removedTplIds.addAll((Collection<String>)tt.getTargetId());
                removedTplIds.removeAll((Collection<?>)t.getSourceId());
                removedTplIds.removeAll((Collection<?>)t.getTargetId());
                tplSrcChangeNotification.add(new ENotificationImpl((InternalEObject)tt, 9002, null, removedTplIds, added));
                continue block11;
            }
        }
        if (!createdTemplate.isEmpty() || !instanceToDelete.isEmpty()) {
            this.map.eNotify((Notification)new ENotificationImpl((InternalEObject)this.map, 9003, null, instanceToDelete, createdTemplate));
        }
        for (Notification n : tplSrcChangeNotification) {
            this.map.eNotify(n);
        }
    }
}

