/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.ensemblist.lexer;

import com.indy.map.SetDescriptor;
import java.lang.ref.WeakReference;

public class Token {
    public static Token OPEN_PARENTHESIS = new Token("(", false);
    public static Token CLOSE_PARENTHESIS = new Token(")", false);
    public static Token UNION = new Token("Union", true);
    public static Token UNION_ALL = new Token("Union All", true);
    public static Token ALL = new Token("All", false);
    public static Token INTERSECTION = new Token("Intersect", true);
    public static Token MINUS = new Token("Minus", true);
    private String value;
    private boolean operator;

    protected Token(String value, boolean operator) {
        this.value = value;
        this.operator = operator;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isOperator() {
        return this.operator;
    }

    public static class Set
    extends Token {
        private WeakReference<SetDescriptor> desc;

        public Set(SetDescriptor descriptor) {
            super(descriptor.getLabel().toString(), false);
            this.desc = new WeakReference<SetDescriptor>(descriptor);
        }

        public SetDescriptor getSetDescriptor() {
            return (SetDescriptor)this.desc.get();
        }

        @Override
        public String getValue() {
            return "[" + this.getSetDescriptor().getLabel().toString() + "]";
        }
    }
}

