/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.extension;

import com.indy.map.Datastore;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.MapModelItem;
import com.indy.map.Query;
import com.indy.map.Template;
import com.indy.map.extension.AbstractTemplateInjector;
import com.indy.map.extension.IExtensionInjector;
import com.indy.map.extension.properties.BasicPropertyDescriptor;
import com.indy.map.extension.properties.IPropertyDescriptor;
import com.indy.map.ref.RTemplate;
import com.semarchy.xdi.designer.core.capabilities.CreatePropertiesCapability;
import com.semarchy.xdi.designer.core.capabilities.ICapability;
import com.semarchy.xdi.designer.core.capabilities.IMapModelExtension;
import com.semarchy.xdi.designer.core.capabilities.IMapModelExtensionDefinitionProvider;
import com.semarchy.xdi.designer.core.capabilities.IPropertyExtensionConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class CreateItemPropertyInjector
extends AbstractTemplateInjector
implements IPropertyExtensionConstants {
    List<Entry> entries = new ArrayList<Entry>();
    private String capabilityProviderTriggerInfo;

    public CreateItemPropertyInjector(String capabilityProviderTriggerInfo, CreatePropertiesCapability capability) {
        super((ICapability)capability, (IMapModelExtensionDefinitionProvider)capability);
        this.capabilityProviderTriggerInfo = capabilityProviderTriggerInfo;
        for (IMapModelExtension ext : capability.getExtensionDefinition()) {
            Entry toInject = new Entry();
            String propertyCode = (String)ext.getAdditionalProperties().get("capability.propertyInjection.propertyCode");
            String displayLabel = (String)ext.getAdditionalProperties().get("capability.propertyInjection.displayLabel");
            boolean isNullable = this.getBooleanProperty(ext, "capability.propertyInjection.nullable");
            toInject.defaultPropertyValue = (String)ext.getAdditionalProperties().get("capability.propertyInjection.defaultValue");
            String uiCategory = (String)ext.getAdditionalProperties().get("capability.propertyInjection.uiCategory");
            String decorationURI = (String)ext.getAdditionalProperties().get("capability.propertyInjection.decorationURI");
            String iconURI = (String)ext.getAdditionalProperties().get("capability.propertyInjection.iconURI");
            boolean isMultiline = this.getBooleanProperty(ext, "capability.propertyInjection.uiMultiline");
            String tooltip = (String)ext.getAdditionalProperties().get("capability.propertyInjection.tooltip");
            boolean unbounded = this.getBooleanProperty(ext, "capability.propertyInjection.unbounded");
            toInject.delegated = ext;
            BasicPropertyDescriptor.MapProvider p = null;
            if (displayLabel == null) {
                displayLabel = propertyCode;
            }
            String typeName = (String)ext.getAdditionalProperties().get("capability.propertyInjection.type");
            boolean isKeyValue = false;
            if (typeName == null) {
                toInject.propertyType = IPropertyDescriptor.Type.String;
            } else if (typeName.equals("Map")) {
                toInject.propertyType = IPropertyDescriptor.Type.String;
                ext.getAdditionalProperties().put("capability.propertyInjection.type", IPropertyDescriptor.Type.String.toString());
                unbounded = true;
                isKeyValue = true;
            } else {
                toInject.propertyType = IPropertyDescriptor.Type.valueOf(typeName);
            }
            if (toInject.propertyType == IPropertyDescriptor.Type.List) {
                HashMap<String, String> listValues = new HashMap<String, String>();
                String _listValues = (String)ext.getAdditionalProperties().get(IPropertyExtensionConstants.LIST_VALUES);
                if (_listValues != null) {
                    String[] stringArray = _listValues.split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (s.matches("[^:]*:[^:]*")) {
                            String[] e = s.split(":");
                            listValues.put(e[1], e[0]);
                        } else {
                            listValues.put(s, s);
                        }
                        ++n2;
                    }
                }
                if (!listValues.isEmpty()) {
                    p = new BasicPropertyDescriptor.MapProvider(listValues);
                }
            }
            toInject.propertyDescriptor = new BasicPropertyDescriptor(propertyCode, isNullable, unbounded, isKeyValue, displayLabel, uiCategory, isMultiline, decorationURI, iconURI, tooltip, p, toInject.propertyType);
            this.entries.add(toInject);
        }
    }

    private Boolean getBooleanProperty(IMapModelExtension deleagte, String pName) {
        String s = (String)deleagte.getAdditionalProperties().get(pName);
        if (s == null) {
            return false;
        }
        return Boolean.valueOf(s);
    }

    @Override
    public Collection<IExtensionInjector.IInjectionDescription> createInjectionDescription(Template trigger, EObject ownerObject) {
        ArrayList<IExtensionInjector.IInjectionDescription> res = new ArrayList<IExtensionInjector.IInjectionDescription>();
        for (Entry e : this.entries) {
            for (MapModelItem it : this.getConcernedObjects(trigger, (IContainer)ownerObject, e, false)) {
                res.add(new InjectionDescription(false, it, e, trigger, this.capabilityProviderTriggerInfo));
            }
        }
        return res;
    }

    @Override
    public Collection<IExtensionInjector.IInjectionDescription> createWithdrawDescription(Template trigger, EObject ownerObject) {
        ArrayList<IExtensionInjector.IInjectionDescription> res = new ArrayList<IExtensionInjector.IInjectionDescription>();
        for (Entry e : this.entries) {
            for (MapModelItem it : this.getConcernedObjects(trigger, (IContainer)ownerObject, e, true)) {
                res.add(new InjectionDescription(true, it, e, trigger, this.capabilityProviderTriggerInfo));
            }
        }
        return res;
    }

    private Collection<MapModelItem> getConcernedObjects(Template trigger, IContainer ownerObject, Entry e, boolean withdrawing) {
        boolean handled = false;
        RTemplate ref = (RTemplate)trigger.getMapReference();
        if (withdrawing) {
            handled = true;
        } else {
            if (e.delegated.supportSrcObjects()) {
                boolean bl = handled = handled || trigger.getSourceId().contains((Object)ownerObject.getId()) || ref != null && ref.getRef().contains(ownerObject);
            }
            if (e.delegated.supportTrgObjects()) {
                handled = handled || trigger.getTargetId().contains((Object)ownerObject.getId()) || ref != null && ref.getTargetRef().contains((Object)ownerObject);
            }
        }
        ArrayList<MapModelItem> res = new ArrayList<MapModelItem>();
        if (handled) {
            if (e.delegated.getTargetObjectType().concernsContainer()) {
                switch (e.delegated.getTargetObjectType()) {
                    case CONTAINER: {
                        boolean bl = handled = Datastore.class.isInstance(ownerObject) || Query.class.isInstance(ownerObject);
                    }
                }
                if (handled && this.validateTarget(ownerObject, e.delegated)) {
                    return Collections.singletonList(ownerObject);
                }
            } else if (e.delegated.getTargetObjectType().concernsField()) {
                switch (e.delegated.getTargetObjectType()) {
                    case FIELD: {
                        boolean bl = handled = Datastore.class.isInstance(ownerObject) || Query.class.isInstance(ownerObject);
                    }
                }
                if (handled) {
                    for (ILogicalField f : ownerObject.getLogicalField()) {
                        if (!this.validateTarget(f, e.delegated)) continue;
                        res.add((MapModelItem)((Object)f));
                    }
                }
            }
        }
        return res;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (Entry e : this.entries) {
            b.append(e.delegated.supportSrcObjects() ? "SRC" : "TRG");
            b.append(" " + e.delegated.getId() + " " + e.delegated.getId());
            b.append(";");
        }
        return b.toString();
    }

    class Entry {
        private String defaultPropertyValue;
        private IPropertyDescriptor.Type propertyType;
        private IPropertyDescriptor propertyDescriptor;
        private IMapModelExtension delegated;

        Entry() {
        }
    }

    class InjectionDescription
    implements IExtensionInjector.IInjectionDescription {
        boolean isDeletion;
        MapModelItem owner;
        Entry entry;
        Template trigger;
        String triggerInfo;

        InjectionDescription(boolean isDeletion, MapModelItem owner, Entry entry, Template trigger, String triggerInfo) {
            this.isDeletion = isDeletion;
            this.owner = owner;
            this.entry = entry;
            this.trigger = trigger;
            this.triggerInfo = triggerInfo;
        }

        @Override
        public boolean conflict(IExtensionInjector.IInjectionDescription desc) {
            if (desc instanceof InjectionDescription) {
                InjectionDescription d = (InjectionDescription)desc;
                if (this.owner == d.owner && this.trigger == d.trigger && (this.entry == d.entry || this.getCreatedObjectIdentifier().equals(d.getCreatedObjectIdentifier()))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public IExtensionInjector.IInjectionDescription mergeConflict(IExtensionInjector.IInjectionDescription desc) {
            if (this.isDeletion() == desc.isDeletion()) {
                return this;
            }
            if (this.isDeletion()) {
                return desc;
            }
            return this;
        }

        @Override
        public boolean isDeletion() {
            return this.isDeletion;
        }

        @Override
        public MapModelItem getOwner() {
            return this.owner;
        }

        @Override
        public MapModelItem getTrigger() {
            return this.trigger;
        }

        @Override
        public String getDefaultValue() {
            return this.entry.defaultPropertyValue;
        }

        @Override
        public String getCreatedObjectIdentifier() {
            return this.entry.delegated.getId();
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IPropertyDescriptor.class) {
                return this.entry.propertyDescriptor;
            }
            return null;
        }

        @Override
        public String getTriggerInfo() {
            return this.triggerInfo;
        }
    }
}

