/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.extension;

import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.Template;
import com.indy.map.custom.commands.PropertyInjectionCommand;
import com.indy.map.extension.IExtensionInjector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class TemplateInjectionTracker
implements ResourceSetListener {
    private NotificationFilter structureEventFilter;
    private IExtensionInjector<Template, Map> injector;
    private TransactionalEditingDomain editingDomain;

    public TemplateInjectionTracker(IExtensionInjector<Template, Map> injector, NotificationFilter structureEventFilter) {
        this.structureEventFilter = structureEventFilter;
        this.injector = injector;
    }

    public NotificationFilter getFilter() {
        return this.structureEventFilter;
    }

    private Command getCommand(ResourceSetChangeEvent event) {
        ArrayList<IExtensionInjector.IInjectionDescription> propertyInjectionDescriptions = new ArrayList<IExtensionInjector.IInjectionDescription>();
        Map map = null;
        HashSet<IContainer> changedContainers = new HashSet<IContainer>();
        for (Notification n : event.getNotifications()) {
            Object o = n.getNotifier();
            if (o instanceof MapModelItem) {
                if (map == null) {
                    Object _o = (EObject)o;
                    while (map == null && (_o = _o.eContainer()) != null) {
                        if (!(_o instanceof Map)) continue;
                        map = (Map)_o;
                        break;
                    }
                }
                switch (n.getEventType()) {
                    case 3: {
                        if (n.getNewValue() instanceof ILogicalField) {
                            changedContainers.add((IContainer)((MapModelItem)n.getNewValue()).eContainer());
                            break;
                        }
                        if (!(n.getNewValue() instanceof IContainer)) break;
                        changedContainers.add((IContainer)((MapModelItem)n.getNewValue()));
                        break;
                    }
                    case 5: {
                        for (Object _o : (Collection)n.getNewValue()) {
                            if (_o instanceof ILogicalField) {
                                changedContainers.add((IContainer)((MapModelItem)_o).eContainer());
                                continue;
                            }
                            if (!(_o instanceof IContainer)) continue;
                            changedContainers.add((IContainer)((MapModelItem)_o));
                        }
                        break;
                    }
                }
            }
            if (map == null) continue;
            for (IContainer c : changedContainers) {
                for (Template tpl : this.findRelatedTpl(c, map)) {
                    propertyInjectionDescriptions.addAll(this.injector.createInjectionDescription(tpl, c));
                }
            }
        }
        if (!propertyInjectionDescriptions.isEmpty()) {
            return new PropertyInjectionCommand(TransactionUtil.getEditingDomain(map), propertyInjectionDescriptions, Collections.EMPTY_MAP);
        }
        return null;
    }

    private List<IExtensionInjector.IInjectionDescription> createStructureChanged(Notification n, Map map) {
        ArrayList<IExtensionInjector.IInjectionDescription> propertyInjectionDescriptions = new ArrayList<IExtensionInjector.IInjectionDescription>();
        ArrayList<EObject> added = new ArrayList<EObject>();
        CompoundCommand cc = new CompoundCommand();
        switch (n.getEventType()) {
            case 3: {
                added.add((EObject)n.getNewValue());
                break;
            }
            case 5: {
                added.addAll((Collection)n.getNewValue());
            }
        }
        for (EObject t : added) {
            for (Template tpl : this.findRelatedTpl(t, map)) {
                propertyInjectionDescriptions.addAll(this.injector.createInjectionDescription(tpl, t));
            }
        }
        return propertyInjectionDescriptions;
    }

    private List<Template> findRelatedTpl(EObject t, Map map) {
        IContainer container = null;
        if (t instanceof ILogicalField) {
            container = (IContainer)t.eContainer();
        } else if (t instanceof IContainer) {
            container = (IContainer)t;
        }
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Template> l = new ArrayList<Template>();
        for (Template tpl : map.getTemplate()) {
            if (!this.injector.getModelObjectToModify(tpl, map).contains(container)) continue;
            l.add(tpl);
        }
        return l;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (Boolean.TRUE.equals(event.getTransaction().getOptions().get("is_undo_redo_transaction"))) {
            return;
        }
        Command cmd = this.getCommand(event);
        if (cmd != null) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("no_undo", Boolean.TRUE);
            options.put("no_validation", Boolean.TRUE);
            options.put("no_triggers", Boolean.TRUE);
            options.put("unprotected", Boolean.TRUE);
            try {
                ((TransactionalCommandStack)event.getEditingDomain().getCommandStack()).execute(cmd, options);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (RollbackException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void register(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        if (editingDomain != null) {
            editingDomain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    public void unregister() {
        if (this.editingDomain != null) {
            this.editingDomain.removeResourceSetListener((ResourceSetListener)this);
            this.editingDomain = null;
        }
    }
}

