/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.geometry.path;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RSourceItem;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.IMapReferencesSynchronizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataSetDivider {
    public static final DataSetDivider INSTANCE = new DataSetDivider();

    protected DataSetDivider() {
    }

    private List<IContainer> getInvolvedContainers(Join j, IMapReferencesSynchronizer synchronizer) {
        ArrayList<IContainer> l = new ArrayList<IContainer>();
        for (RSourceItem i : this.getRef(j, synchronizer).getRealSourceRef()) {
            IContainer c;
            if (!(i instanceof RLogicalField) || (c = (IContainer)i.getDataModel().eContainer()) == null || l.contains(c)) continue;
            l.add(c);
        }
        if (j.getLeft() != null && !l.contains(j.getLeft())) {
            l.add(j.getLeft());
        }
        if (j.getRight() != null && !l.contains(j.getRight())) {
            l.add(j.getRight());
        }
        return l;
    }

    private RClause getRef(Join j, IMapReferencesSynchronizer synchronizer) {
        return synchronizer.getReference(j);
    }

    public Division[] divide(DataSet dataSet, Join join) {
        ArrayList<ArrayList<Join>> joinsLists = new ArrayList<ArrayList<Join>>();
        ArrayList<List<Object>> divisions = new ArrayList<List<Object>>();
        for (IContainer iContainer : this.getInvolvedContainers(join, ((IMapResource)dataSet.eResource()).getReferenceSynchronizer())) {
            ArrayList<Join> l = new ArrayList<Join>();
            this.extractJoins(dataSet, iContainer, l, join);
            if (l.isEmpty()) {
                ArrayList<IContainer> lc = new ArrayList<IContainer>();
                lc.add(iContainer);
                divisions.add(lc);
                continue;
            }
            boolean listExists = false;
            for (List list : joinsLists) {
                if (l.size() != list.size() || !list.containsAll(l) || !l.containsAll(list)) continue;
                listExists = true;
                break;
            }
            if (listExists) continue;
            joinsLists.add(l);
        }
        for (List list : joinsLists) {
            List<IContainer> d = this.getContainers(list, ((IMapResource)dataSet.eResource()).getReferenceSynchronizer());
            boolean exists = false;
            for (List list2 : divisions) {
                if (Collections.disjoint(d, list2)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            divisions.add(d);
        }
        if (divisions.isEmpty()) {
            return null;
        }
        Division[] divisionArray = new Division[divisions.size()];
        int i = 0;
        while (i < divisions.size()) {
            divisionArray[i] = new Division((List)divisions.get(i));
            ++i;
        }
        return divisionArray;
    }

    protected List<IContainer> getContainers(List<Join> joins, IMapReferencesSynchronizer synchronizer) {
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        for (Join j : joins) {
            for (RSourceItem src : this.getRef(j, synchronizer).getSourceRef()) {
                if (!(src instanceof RLogicalField) || containers.contains(src.getDataModel().eContainer())) continue;
                containers.add((IContainer)src.getDataModel().eContainer());
            }
            if (j.getLeft() != null && !containers.contains(j.getLeft())) {
                containers.add(j.getLeft());
            }
            if (j.getRight() == null || containers.contains(j.getRight())) continue;
            containers.add(j.getRight());
        }
        return containers;
    }

    private void extractJoins(DataSet dataSet, IContainer container, List<Join> joins, Join forbiddenJoin) {
        for (Join j : ((Map)container.eContainer()).getJoin()) {
            if (forbiddenJoin == j || joins.contains(j)) continue;
            if (j.getLeft() == container) {
                if (j.getRight() == null || j.getRight().getDataset() != dataSet) continue;
                joins.add(j);
                this.extractJoins(dataSet, j.getRight(), joins, forbiddenJoin);
                continue;
            }
            if (j.getRight() != container || j.getLeft() == null || j.getLeft().getDataset() != dataSet) continue;
            joins.add(j);
            this.extractJoins(dataSet, j.getLeft(), joins, forbiddenJoin);
        }
    }

    public static class Division {
        private List<IContainer> containers;

        protected Division(List<IContainer> containers) {
            this.containers = containers;
        }

        public List<IContainer> getContainers() {
            return this.containers;
        }

        public int getWeight() {
            return this.containers.size();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Division) {
                return this.containers.containsAll(((Division)obj).containers) && ((Division)obj).containers.containsAll(this.containers);
            }
            return false;
        }
    }
}

