/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.geometry.path;

import com.indy.map.IContainer;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.geometry.path.DataSetDivider;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RSourceItem;
import com.indy.map.util.synchro.IRefUpdaterProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DisjointDetector
extends DataSetDivider {
    public static final DisjointDetector INSTANCE = new DisjointDetector();

    private List<IContainer> getJoinContainers(Join j) throws Exception {
        if (((RClause)j.getMapReference()).getSourceRef().isEmpty() && (j.getLeft() != null || j.getRight() != null)) {
            IRefUpdaterProvider.INSTANCE.getUpdater((RClause)j.getMapReference()).update((RClause)j.getMapReference(), (EStructuralFeature)MapPackage.eINSTANCE.getClause_Expression());
        }
        ArrayList<IContainer> toGoFrom = new ArrayList<IContainer>();
        for (RSourceItem it : ((RClause)j.getMapReference()).getSourceRef()) {
            IContainer c;
            if (!(it instanceof RLogicalField) || toGoFrom.contains(c = (IContainer)it.getDataModel().eContainer())) continue;
            toGoFrom.add(c);
        }
        return toGoFrom;
    }

    private void extractJoins(IContainer container, List<IContainer> current, List<Join> joins, List<DataSetDivider.Division> disjointure) throws Exception {
        for (Join j : ((Map)container.eContainer()).getJoin()) {
            List<IContainer> joinContainers;
            if (joins.contains(j) || !(joinContainers = this.getJoinContainers(j)).contains(container)) continue;
            joins.add(j);
            for (IContainer c : joinContainers) {
                boolean forbid = false;
                for (DataSetDivider.Division d : disjointure) {
                    if (!d.getContainers().contains(c)) continue;
                    forbid = true;
                    break;
                }
                if (forbid || current.contains(c)) continue;
                current.add(c);
                if (c == container) continue;
                this.extractJoins(c, current, joins, disjointure);
            }
        }
    }

    public List<DataSetDivider.Division> getAllDisjointSets(IContainer container) throws Exception {
        ArrayList<IContainer> containers = null;
        ArrayList<DataSetDivider.Division> disjointure = new ArrayList<DataSetDivider.Division>();
        do {
            IContainer c = null;
            if (containers == null) {
                c = container;
                containers = new ArrayList<IContainer>();
                if (container.getDataset() != null) {
                    containers.addAll((Collection<IContainer>)container.getDataset().getContainer());
                }
            } else {
                c = (IContainer)containers.get(0);
            }
            ArrayList<IContainer> joins = new ArrayList<IContainer>();
            this.extractJoins(c, joins, new ArrayList<Join>(), disjointure);
            if (joins.isEmpty()) {
                joins.add(c);
            }
            containers.removeAll(joins);
            disjointure.add(new DataSetDivider.Division(joins));
        } while (!containers.isEmpty());
        return disjointure;
    }
}

