/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.helpers;

import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.IDataStore;
import com.indy.map.ILogicalField;
import com.indy.map.ref.RField;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import com.stambia.tech.Tech;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class ExtraStaticFieldSorter {
    private Datastore datastore;

    public ExtraStaticFieldSorter(Datastore datastore) {
        this.datastore = datastore;
    }

    public void doSort() {
        this.sortExtraFields();
    }

    private void sortExtraFields() {
        HashMap<Field, BigInteger> fieldPositions = new HashMap<Field, BigInteger>();
        ArrayList<Field> regularFields = new ArrayList<Field>();
        ArrayList<Field> staticFields = new ArrayList<Field>();
        for (Field f : this.datastore.getField()) {
            if (f.isExtraStatic()) {
                fieldPositions.remove(f);
                staticFields.add(f);
                continue;
            }
            regularFields.add(f);
            fieldPositions.put(f, ((RField)f.getMapReference()).getPosition());
        }
        if (staticFields.isEmpty()) {
            return;
        }
        Collections.sort(regularFields, new IDataStore.FieldComparator(0, 0, 1, IDataStore.FieldComparator.SortMode.POSITION));
        class Locator
        implements Comparator<Field> {
            private final /* synthetic */ List val$staticFields;
            private final /* synthetic */ List val$regularFields;

            Locator(List list, List list2) {
                this.val$staticFields = list;
                this.val$regularFields = list2;
            }

            @Override
            public int compare(Field f1, Field f2) {
                Field p1 = this.getRegularAncestor(f1);
                Field p2 = this.getRegularAncestor(f2);
                if (p1 == null) {
                    if (p2 == null) {
                        return Integer.valueOf(this.val$staticFields.indexOf(f1)).compareTo(this.val$staticFields.indexOf(f2));
                    }
                    return -1;
                }
                if (p2 == null) {
                    return 1;
                }
                return Integer.valueOf(this.val$regularFields.indexOf(p1)).compareTo(this.val$regularFields.indexOf(p2));
            }

            private Field getRegularAncestor(Field f) {
                Field p = f;
                while (p != null && p.isExtraStatic()) {
                    p = p.getParent();
                }
                return p;
            }

            public boolean isAfter(Field extra, Field c) {
                Level l1 = null;
                Level l2 = null;
                if (extra.getRef() instanceof MdNode) {
                    l1 = ((MdNode)extra.getRef()).getLevel();
                }
                if (c.getRef() instanceof MdNode) {
                    l2 = ((MdNode)c.getRef()).getLevel();
                }
                if (l1 == null) {
                    if (l2 == null) {
                        return ExtraStaticFieldSorter.this.datastore.getField().indexOf((Object)extra) > ExtraStaticFieldSorter.this.datastore.getField().indexOf((Object)c);
                    }
                    return true;
                }
                if (l2 == null) {
                    return false;
                }
                BigInteger i1 = l1.getPosition();
                BigInteger i2 = l2.getPosition();
                if (i1 == null) {
                    if (i2 == null) {
                        return ExtraStaticFieldSorter.this.datastore.getField().indexOf((Object)extra) > ExtraStaticFieldSorter.this.datastore.getField().indexOf((Object)c);
                    }
                    return true;
                }
                if (i2 == null) {
                    return true;
                }
                if (i1.longValue() == i2.longValue()) {
                    return ((Tech)l1.eContainer()).getLevel().indexOf((Object)l1) > ((Tech)l2.eContainer()).getLevel().indexOf((Object)l2);
                }
                return i1.longValue() > i2.longValue();
            }
        }
        Locator locator = new Locator(staticFields, regularFields);
        Collections.sort(staticFields, locator);
        for (Field f : staticFields) {
            Field parent = f.getParent();
            long precPosition = 0L;
            if (parent == null) {
                Field lastRoot = null;
                for (Field c : regularFields) {
                    if (c == f || c.getParent() != null || c.isExtraStatic() || !locator.isAfter(f, c)) continue;
                    if (precPosition <= ((BigInteger)fieldPositions.get(c)).longValue()) {
                        lastRoot = c;
                    }
                    precPosition = Math.max(precPosition, ((BigInteger)fieldPositions.get(c)).longValue());
                }
                for (ILogicalField d : lastRoot.getDescendants()) {
                    if (fieldPositions.get(d) == null || precPosition > ((BigInteger)fieldPositions.get(d)).longValue()) continue;
                    lastRoot = (Field)d;
                    precPosition = Math.max(precPosition, ((BigInteger)fieldPositions.get(d)).longValue());
                }
                parent = lastRoot;
            }
            if (parent != null) {
                precPosition = ((BigInteger)fieldPositions.get(parent)).longValue();
                for (Field c : parent.getChildren()) {
                    if (c == f || !locator.isAfter(f, c)) continue;
                    precPosition = Math.max(precPosition, ((BigInteger)fieldPositions.get(c)).longValue());
                }
            }
            for (Field c : fieldPositions.keySet()) {
                long p;
                if (c == f || (p = ((BigInteger)fieldPositions.get(c)).longValue()) < precPosition + 1L) continue;
                fieldPositions.put(c, BigInteger.valueOf(p + 1L));
            }
            fieldPositions.put(f, BigInteger.valueOf(precPosition + 1L));
        }
        for (Field c : fieldPositions.keySet()) {
            ((RField)c.getMapReference()).setPosition((BigInteger)fieldPositions.get(c));
        }
    }
}

