/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.ref.impl;

import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RExpressionStatus;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RefPackage;
import com.indy.map.ref.impl.RUsageImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class RClauseImpl
extends RUsageImpl
implements RClause {
    protected static final RExpressionStatus STATUS_EDEFAULT = RExpressionStatus.VALID;
    protected RExpressionStatus status = STATUS_EDEFAULT;
    protected boolean statusESet;

    protected RClauseImpl() {
        this.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == RefPackage.eINSTANCE.getRItem_Problem()) {
                    RClauseImpl.this.updateStatus();
                }
            }
        });
    }

    @Override
    protected EClass eStaticClass() {
        return RefPackage.Literals.RCLAUSE;
    }

    @Override
    public RExpressionStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(RExpressionStatus newStatus) {
        RExpressionStatus oldStatus = this.status;
        this.status = newStatus == null ? STATUS_EDEFAULT : newStatus;
        boolean oldStatusESet = this.statusESet;
        this.statusESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldStatus, (Object)this.status, !oldStatusESet));
        }
    }

    @Override
    public void unsetStatus() {
        RExpressionStatus oldStatus = this.status;
        boolean oldStatusESet = this.statusESet;
        this.status = STATUS_EDEFAULT;
        this.statusESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, (Object)oldStatus, (Object)STATUS_EDEFAULT, oldStatusESet));
        }
    }

    @Override
    public boolean isSetStatus() {
        return this.statusESet;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getStatus();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setStatus((RExpressionStatus)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.unsetStatus();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.isSetStatus();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (status: ");
        if (this.statusESet) {
            result.append((Object)this.status);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean addProblem(QName problemCode) {
        boolean res = false;
        res = super.addProblem(problemCode);
        if (res) {
            this.updateStatus();
        }
        return res && ((Clause)this.getDataModel()).isEnable();
    }

    @Override
    public boolean removeProblem(QName problemCode) {
        boolean res = false;
        res = super.removeProblem(problemCode);
        if (res) {
            this.updateStatus();
        }
        return res && ((Clause)this.getDataModel()).isEnable();
    }

    private void updateStatus() {
        if (this.getProblem().isEmpty() && this.getStatus() != RExpressionStatus.VALID) {
            this.setStatus(RExpressionStatus.VALID);
        } else {
            RProblem.Type type = RProblem.Type.NONE;
            for (RProblem p : this.getProblem()) {
                if (type != null && type.ordinal() >= p.getProblemType().ordinal()) continue;
                type = p.getProblemType();
            }
            switch (type) {
                case ERROR: {
                    this.setStatus(RExpressionStatus.ERROR);
                    break;
                }
                case WARNING: {
                    this.setStatus(RExpressionStatus.WARNING);
                    break;
                }
                case NONE: 
                case INFO: {
                    this.setStatus(RExpressionStatus.VALID);
                }
            }
        }
    }

    @Override
    public Collection<String> getContextualProductCode() {
        Clause clause = (Clause)this.getDataModel();
        Map map = null;
        Clause o = clause;
        while (map == null && o != null) {
            if (!((o = o.eContainer()) instanceof Map)) continue;
            map = (Map)((Object)o);
        }
        HashSet<String> res = new HashSet<String>();
        if (clause.getLocation() == JoinLocation.SRC) {
            for (IContainer c : clause.getInvolvedContainers()) {
                res.add(c.getAPI().getMdEvaluator().evaluateProductCode(c, IMetaDataInformationsProvider.EvaluationLocation.ON_REF));
            }
        } else {
            HashSet<DataSet> dataSets = new HashSet<DataSet>();
            for (IContainer c : clause.getInvolvedContainers()) {
                dataSets.add(c.getDataset());
            }
            ArrayList<IContainer> targetContainers = new ArrayList<IContainer>();
            for (RTargetSet ts : ((RMap)map.getMapReference()).getTargetSetRef()) {
                if (Collections.disjoint(ts.getSourceSet().getDataSet(), dataSets)) continue;
                targetContainers.addAll(ts.getContainerModel());
            }
            for (IContainer c : targetContainers) {
                res.add(c.getAPI().getMdEvaluator().evaluateProductCode(c, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING));
            }
        }
        return res;
    }

    @Override
    public boolean addProblem(RProblem problem) {
        boolean b = super.addProblem(problem);
        return b && ((Clause)this.getDataModel()).isEnable();
    }
}

