/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.ref.impl;

import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.Map;
import com.indy.map.Template;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RefPackage;
import com.indy.map.ref.impl.RLogicalFieldImpl;
import com.indy.map.ref.impl.RUsageImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;

public class RExpressionImpl
extends RUsageImpl
implements RExpression {
    protected RExpressionImpl() {
        this.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == RefPackage.eINSTANCE.getRItem_Problem()) {
                    RExpressionImpl.this.updateStatus();
                }
            }
        });
    }

    @Override
    protected EClass eStaticClass() {
        return RefPackage.Literals.REXPRESSION;
    }

    @Override
    public boolean addProblem(QName problemCode) {
        boolean res = false;
        res = super.addProblem(problemCode);
        if (res) {
            this.updateStatus();
        }
        return res;
    }

    @Override
    public boolean removeProblem(QName problemCode) {
        boolean res = false;
        res = super.removeProblem(problemCode);
        if (res) {
            this.updateStatus();
        }
        return res;
    }

    private void updateStatus() {
        if (this.eContainer() instanceof RLogicalField) {
            ((RLogicalFieldImpl)this.eContainer()).updateStatus();
        }
    }

    @Override
    public Collection<String> getContextualProductCode() {
        HashSet<String> res = new HashSet<String>();
        Expression exp = (Expression)this.getDataModel();
        Assert.isTrue((boolean)(exp.eContainer().eContainer() instanceof IContainer));
        IContainer container = (IContainer)exp.eContainer().eContainer();
        Assert.isTrue((boolean)(container.eContainer() instanceof Map));
        List templates = ((Map)container.eContainer()).getTemplateForTarget(container);
        HashSet<IContainer> srcContainer = new HashSet<IContainer>();
        for (RSourceItem i : this.getSourceRef()) {
            if (!(i.getDataModel() instanceof ILogicalField)) continue;
            srcContainer.add((IContainer)i.getDataModel().eContainer());
        }
        switch (exp.getLocation()) {
            case SRC: {
                for (IContainer s : container.getSrcContainers()) {
                    if (!(s instanceof IMetaData) || !srcContainer.contains(s)) continue;
                    res.add(s.getAPI().getMdEvaluator().evaluateProductCode(s, IMetaDataInformationsProvider.EvaluationLocation.ON_REF));
                }
                break;
            }
            case TRG: {
                for (Template t : templates) {
                    RTemplate ref = (RTemplate)t.getMapReference();
                    if (!ref.getTemplateType().isIntegration()) continue;
                    res.add(ref.extractCriteriaValue("trgProduct"));
                }
                break;
            }
            case WRK: {
                res.add(container.getAPI().getMdEvaluator().evaluateProductCode(container, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING));
            }
        }
        return res;
    }
}

