/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.udf.parser;

import com.indy.libraries.build.parser.sql.ExpressionParser;
import java.util.HashMap;
import java.util.Map;

public class UDFParser {
    Map<String, Integer> tokens = new HashMap<String, Integer>();

    public Map<String, Integer> getFunctionParameterCount() {
        return this.tokens;
    }

    public boolean parse(String expression) {
        this.tokens.clear();
        ExpressionParser parser = new ExpressionParser();
        ExpressionParser.ExpressionTree ast = parser.createExpressionTree(expression);
        if (parser.containsUDF()) {
            Visitor v = new Visitor();
            v.accept(ast);
        }
        return true;
    }

    class Visitor {
        Visitor() {
        }

        void accept(ExpressionParser.ExpressionTree t) {
            this.visit(t);
        }

        void visit(ExpressionParser.ExpressionTree t) {
            String fName;
            if (t.getType() == ExpressionParser.Type.UDF && !(fName = t.getToken().getValue()).startsWith("md::") && !fName.startsWith("user::")) {
                int i = 0;
                for (ExpressionParser.ExpressionTree c : t.getChildren()) {
                    if (c.getType() != ExpressionParser.Type.PARAMETER) continue;
                    ++i;
                }
                UDFParser.this.tokens.put(fName, i);
            }
            for (ExpressionParser.ExpressionTree c : t.getChildren()) {
                this.visit(c);
            }
        }
    }
}

