/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util;

import com.indy.libraries.build.parser.sql.ExpressionParser;
import com.indy.map.UDFRef;
import com.indy.map.api.IMapAPI;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RUDFRef;
import com.semarchy.xdi.designer.core.services.IRegistryContributionHelper;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.services.registry.UDFImplementation;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;

public class UDFRequirementFinder {
    private HashMap<UDF, Collection<String>> variableNames = new HashMap();
    protected HashMap<UDF, Collection<UDF>> udfRequiredUdf = new HashMap();
    IRegistryService.IRegistry<UDF> udfRegistry;
    Pattern pattern = Pattern.compile("(%\\{[a-zA-Z0-9_]*\\}%)");

    public UDFRequirementFinder(IMapAPI api, IRegistryService.IRegistry<UDF> udfRegistry, List<UDFRef> udfs) {
        this.udfRegistry = udfRegistry;
        for (UDFRef udf : udfs) {
            List l = udfRegistry.find(api.getUDFIndentifier(udf));
            if (l == null || l.isEmpty()) continue;
            UDF u = (UDF)l.get(0);
            this.findUDFDependancies(u);
        }
    }

    private void findUDFDependancies(UDF udf) {
        if (this.variableNames.get(udf) != null) {
            return;
        }
        HashSet<UDF> dependancies = new HashSet<UDF>();
        for (UDFImplementation i : udf.getImplementations()) {
            String expression = i.getExpression();
            Visitor v = new Visitor();
            try {
                ExpressionParser parser = new ExpressionParser();
                ExpressionParser.ExpressionTree t = parser.createExpressionTree(expression);
                v.accept(t);
            }
            catch (Exception parser) {
                // empty catch block
            }
            this.variableNames.put(udf, v.variableName);
            for (String s : v.udfNames) {
                String[] p = s.split("\\|");
                try {
                    UDF u = (UDF)this.udfRegistry.find((IRegistryService.IRegistryMatcher)new RUDFRef.UDFKeyMatcher(p[0], p[1], Integer.valueOf(p[2]))).get(0);
                    dependancies.add(u);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.udfRequiredUdf.put(udf, dependancies);
        for (UDF u : dependancies) {
            this.findUDFDependancies(u);
        }
    }

    public HashMap<String, URI> gatherMdNodes() throws Exception {
        HashMap<String, URI> varMgrURI = new HashMap<String, URI>();
        for (UDF u : this.variableNames.keySet()) {
            Collection<String> c = this.variableNames.get(u);
            if (c == null || c.isEmpty()) continue;
            HashMap vars = ((IRegistryContributionHelper)E4InjectorHelper.getService(IRegistryContributionHelper.class)).getUsedVariableURI(u);
            for (String s : vars.keySet()) {
                if (vars.get(s) == null) continue;
                for (URI _u : (Set)vars.get(s)) {
                    if (varMgrURI.get(s) == null) {
                        varMgrURI.put(s, _u);
                        continue;
                    }
                    if (varMgrURI.get(s).equals(_u)) continue;
                    throw new Exception(Messages.bind((String)Messages.UDFRequirementFinder_5, (Object)s, (Object)u.getFormatedSignature()));
                }
            }
            for (String s : c) {
                if (varMgrURI.get(s) != null) continue;
                throw new Exception(Messages.bind((String)Messages.UDFRequirementFinder_7, (Object)s, (Object)u.getFunctionSignature()));
            }
        }
        return varMgrURI;
    }

    class Visitor {
        Set<String> variableName = new HashSet<String>();
        Set<String> udfNames = new HashSet<String>();

        Visitor() {
        }

        void accept(ExpressionParser.ExpressionTree tree) {
            this.visit(tree);
        }

        void visit(ExpressionParser.ExpressionTree tree) {
            switch (tree.getType()) {
                case DATA: {
                    if (tree.getToken().getValue().trim().isEmpty()) break;
                    Matcher macther = UDFRequirementFinder.this.pattern.matcher(tree.getToken().getValue());
                    while (macther.find()) {
                        String varName = tree.getToken().getValue().substring(macther.start(1), macther.end(1));
                        this.variableName.add(varName.substring(2, varName.length() - 2));
                    }
                    break;
                }
                case UDF: {
                    int paramCount = 0;
                    for (ExpressionParser.ExpressionTree t : tree.getChildren()) {
                        if (t.getType() != ExpressionParser.Type.PARAMETER) continue;
                        ++paramCount;
                    }
                    this.udfNames.add(tree.getToken().getValue().replace("::", "|") + "|" + paramCount);
                }
            }
            for (ExpressionParser.ExpressionTree t : tree.getChildren()) {
                this.visit(t);
            }
        }
    }
}

