/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.impl;

import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.compute.Computer;
import com.indy.map.custom.commands.RefreshAllRefCommand;
import com.indy.map.messages.Messages;
import com.indy.map.ref.DocumentRoot;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RField;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RUsage;
import com.indy.map.ref.RefFactory;
import com.indy.map.ref.util.RefResourceImpl;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.IMapReferencesSynchronizer;
import com.indy.map.util.synchro.IRefItemUpdater;
import com.indy.map.util.synchro.IRefUpdaterProvider;
import com.indy.map.util.synchro.IReferenceBuilder;
import com.indy.map.util.synchro.impl.CommitTriggerListener;
import com.indy.map.util.synchro.impl.MetaDataListener;
import com.indy.map.util.synchro.impl.ProblemUpdateListener;
import com.indy.map.util.synchro.impl.RefModelUpdateListener;
import com.indy.map.util.synchro.impl.ReferenceBuilderSwitch;
import com.indy.map.util.synchro.impl.SourceSetUpdateListener;
import com.indy.map.util.synchro.impl.TemplateModelExtensionCapabilityListener;
import com.indy.map.util.synchro.impl.TemplateUpdateListener;
import com.indy.map.util.synchro.impl.listeners.DataSetListener;
import com.indy.map.util.synchro.impl.listeners.UsageRefListener;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.osgi.service.log.LogService;

public class MapReferencesSynchronizerImpl
implements IMapReferencesSynchronizer,
ResourceSetListener {
    private Logger logger = LogManager.getLogger(MapReferencesSynchronizerImpl.class);
    private WeakHashMap<EObject, RItem> synchMap = new WeakHashMap(50);
    private ReferenceBuilderSwitch switcher = new ReferenceBuilderSwitch();
    private DataSetListener dataSetlistener = new DataSetListener();
    private UsageRefListener usageReflistener = new UsageRefListener();
    private CommitTriggerListener commitTrigger = new CommitTriggerListener();
    private SourceSetUpdateListener sourceSetListener = new SourceSetUpdateListener();
    private TemplateUpdateListener templateListener = new TemplateUpdateListener();
    private RefModelUpdateListener refModelListener = new RefModelUpdateListener();
    private TemplateModelExtensionCapabilityListener modelExtensionCapability = new TemplateModelExtensionCapabilityListener();
    private ProblemUpdateListener problemListener = ProblemUpdateListener.INSTANCE;
    private MetaDataListener metaDataListener = new MetaDataListener();
    private boolean listening = false;
    private boolean initializing = false;
    private CompoundCommand postponedAggregatedCommand;
    private NotificationFilter filter = NotificationFilter.createEventTypeFilter((int)3).or(NotificationFilter.createEventTypeFilter((int)4)).or(NotificationFilter.createEventTypeFilter((int)6)).or(NotificationFilter.createEventTypeFilter((int)1).and(NotificationFilter.createNotifierTypeFilter((EClassifier)MapPackage.eINSTANCE.getJoin()).or(NotificationFilter.createNotifierTypeFilter((EClassifier)MapPackage.eINSTANCE.getOperator())))).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getClause_Expression()));

    @Override
    public <T extends RItem> T getReference(IReferencable<T> designObject) {
        RItem res = this.synchMap.get(designObject);
        if (res != null) {
            return (T)res;
        }
        if (!(designObject.eResource() instanceof IMapResource)) {
            return null;
        }
        IReferenceBuilder builder = (IReferenceBuilder)this.switcher.doSwitch(designObject);
        if (builder != null) {
            IRefItemUpdater updater;
            Object obj = builder.createReference(designObject);
            if (obj != null) {
                if (this.synchMap.get(designObject) != null) {
                    ((Collection)obj.eContainer().eGet(obj.eContainingFeature())).remove(obj);
                    obj = this.synchMap.get(designObject);
                } else {
                    this.synchMap.put(designObject, (RItem)obj);
                }
            }
            if ((updater = IRefUpdaterProvider.INSTANCE.getUpdater(obj)) != null) {
                try {
                    updater.updateAll(obj);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return obj;
        }
        return null;
    }

    public void disableListeners(TransactionalEditingDomain mapResourceEditingDomain) {
        if (mapResourceEditingDomain != null) {
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.commitTrigger);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.sourceSetListener);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.templateListener);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.refModelListener);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.metaDataListener);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.modelExtensionCapability);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.problemListener);
        }
    }

    public void enableListeners(TransactionalEditingDomain mapResourceEditingDomain) {
        if (mapResourceEditingDomain != null) {
            mapResourceEditingDomain.addResourceSetListener((ResourceSetListener)this);
            mapResourceEditingDomain.addResourceSetListener((ResourceSetListener)this.commitTrigger);
            mapResourceEditingDomain.addResourceSetListener((ResourceSetListener)this.sourceSetListener);
            mapResourceEditingDomain.addResourceSetListener((ResourceSetListener)this.refModelListener);
            mapResourceEditingDomain.addResourceSetListener((ResourceSetListener)this.templateListener);
            mapResourceEditingDomain.addResourceSetListener((ResourceSetListener)this.metaDataListener);
            mapResourceEditingDomain.addResourceSetListener((ResourceSetListener)this.modelExtensionCapability);
            mapResourceEditingDomain.addResourceSetListener((ResourceSetListener)this.problemListener);
        }
    }

    @Override
    public void clear(TransactionalEditingDomain mapResourceEditingDomain) {
        Optional<TransactionalEditingDomain> opt;
        if (mapResourceEditingDomain != null) {
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.commitTrigger);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.sourceSetListener);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.refModelListener);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.templateListener);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.metaDataListener);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.modelExtensionCapability);
            mapResourceEditingDomain.removeResourceSetListener((ResourceSetListener)this.problemListener);
        }
        if ((opt = this.synchMap.keySet().stream().filter(o -> o != null).map(TransactionUtil::getEditingDomain).filter(Objects::nonNull).findFirst()).isPresent()) {
            TransactionalEditingDomain domain = opt.get();
            domain.removeResourceSetListener((ResourceSetListener)this);
            domain.removeResourceSetListener((ResourceSetListener)this.commitTrigger);
            domain.removeResourceSetListener((ResourceSetListener)this.sourceSetListener);
            domain.removeResourceSetListener((ResourceSetListener)this.refModelListener);
            domain.removeResourceSetListener((ResourceSetListener)this.templateListener);
            domain.removeResourceSetListener((ResourceSetListener)this.metaDataListener);
            domain.removeResourceSetListener((ResourceSetListener)this.modelExtensionCapability);
            domain.removeResourceSetListener((ResourceSetListener)this.problemListener);
        }
        this.listening = false;
        this.synchMap.clear();
    }

    @Override
    public boolean reInit(Map map) {
        boolean res = false;
        try {
            this.initializing = true;
            this.synchMap.clear();
            this.postponedAggregatedCommand = new CompoundCommand();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)map);
            if (domain != null) {
                domain.removeResourceSetListener((ResourceSetListener)this);
                domain.removeResourceSetListener((ResourceSetListener)this.metaDataListener);
                domain.removeResourceSetListener((ResourceSetListener)this.commitTrigger);
                domain.removeResourceSetListener((ResourceSetListener)this.sourceSetListener);
                domain.removeResourceSetListener((ResourceSetListener)this.refModelListener);
                domain.removeResourceSetListener((ResourceSetListener)this.templateListener);
                domain.removeResourceSetListener((ResourceSetListener)this.modelExtensionCapability);
                domain.removeResourceSetListener((ResourceSetListener)this.problemListener);
            }
            Computer.INSTANCE.compute(map);
            RMap refMap = this.getReference(map);
            if (refMap.eResource() == null) {
                String lastSegment = map.eResource().getURI().trimFileExtension().lastSegment();
                StringBuilder b = new StringBuilder();
                int i = 1;
                while (i < map.eResource().getURI().segmentCount() - 1) {
                    b.append("/");
                    b.append(URI.decode((String)map.eResource().getURI().segment(i)));
                    if (i == 1) {
                        b.append("/indy.build");
                    }
                    ++i;
                }
                URI refResourceUri = URIUtils.convertIPathToEMFURI2((IPath)new Path(b.toString())).appendSegment(lastSegment).appendFileExtension("map_ref");
                RefResourceImpl resource = new RefResourceImpl(refResourceUri);
                DocumentRoot root = RefFactory.eINSTANCE.createDocumentRoot();
                root.setMapRef(refMap);
                resource.getContents().add((Object)root);
            }
            if (domain != null) {
                domain.addResourceSetListener((ResourceSetListener)this);
                domain.addResourceSetListener((ResourceSetListener)this.metaDataListener);
                domain.addResourceSetListener((ResourceSetListener)this.commitTrigger);
                domain.addResourceSetListener((ResourceSetListener)this.sourceSetListener);
                domain.addResourceSetListener((ResourceSetListener)this.refModelListener);
                domain.addResourceSetListener((ResourceSetListener)this.templateListener);
                domain.addResourceSetListener((ResourceSetListener)this.modelExtensionCapability);
                domain.addResourceSetListener((ResourceSetListener)this.problemListener);
                this.listening = true;
            }
            this.initializing = false;
            if (this.postponedAggregatedCommand != null && !this.postponedAggregatedCommand.isEmpty()) {
                res = true;
            }
        }
        catch (Exception t) {
            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.gmf.map").error(Messages.MapReferencesSynchronizerImpl_4 + String.valueOf(map.eResource().getURI()), (Object)t);
        }
        return res;
    }

    @Override
    public void appendPostponedCommand(Command cmd) {
        if (this.postponedAggregatedCommand != null) {
            this.postponedAggregatedCommand.append(cmd);
        }
    }

    @Override
    public void executePostponed(Map map) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)map);
        if (domain != null) {
            domain.removeResourceSetListener((ResourceSetListener)this);
            domain.removeResourceSetListener((ResourceSetListener)this.metaDataListener);
            domain.removeResourceSetListener((ResourceSetListener)this.commitTrigger);
            domain.removeResourceSetListener((ResourceSetListener)this.sourceSetListener);
            domain.removeResourceSetListener((ResourceSetListener)this.refModelListener);
            domain.removeResourceSetListener((ResourceSetListener)this.templateListener);
            domain.removeResourceSetListener((ResourceSetListener)this.modelExtensionCapability);
            domain.removeResourceSetListener((ResourceSetListener)this.problemListener);
            this.postponedAggregatedCommand.append((Command)new RefreshAllRefCommand(domain, map));
            domain.getCommandStack().execute((Command)this.postponedAggregatedCommand);
            this.postponedAggregatedCommand = null;
            domain.addResourceSetListener((ResourceSetListener)this);
            domain.addResourceSetListener((ResourceSetListener)this.metaDataListener);
            domain.addResourceSetListener((ResourceSetListener)this.commitTrigger);
            domain.addResourceSetListener((ResourceSetListener)this.sourceSetListener);
            domain.addResourceSetListener((ResourceSetListener)this.refModelListener);
            domain.addResourceSetListener((ResourceSetListener)this.templateListener);
            domain.addResourceSetListener((ResourceSetListener)this.modelExtensionCapability);
            domain.addResourceSetListener((ResourceSetListener)this.problemListener);
        }
        for (IContainer c : map.getContainer()) {
            for (ILogicalField f : c.getLogicalField()) {
                for (Expression e : f.getExpression()) {
                    RExpression r = (RExpression)e.getMapReference();
                    for (RSourceItem s : r.getSourceRef()) {
                        s.getUsage();
                    }
                }
            }
        }
    }

    public NotificationFilter getFilter() {
        return this.filter;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        Command c;
        CompoundCommand cc = new CompoundCommand();
        for (Notification n : event.getNotifications()) {
            c = this.dataSetlistener.getCommand(n);
            if (c != null) {
                cc.append(c);
            }
            if ((c = this.usageReflistener.getCommand(n)) == null) continue;
            cc.append(c);
        }
        for (Notification n : event.getNotifications()) {
            if (!this.getFilter().matches(n) || n.getFeature() == MapPackage.eINSTANCE.getMapModelItem_Annotation()) continue;
            if (n.getEventType() == 3 && n.getNewValue() instanceof IReferencable) {
                this.getReference((IReferencable)n.getNewValue());
                cc.append((Command)new CreateRItemCommand((IReferencable)n.getNewValue()));
                continue;
            }
            if (n.getEventType() != 4 && n.getEventType() != 6 || !(n.getFeature() instanceof EReference)) continue;
            ((EReference)n.getFeature()).isContainment();
        }
        for (Notification n : event.getNotifications()) {
            c = this.usageReflistener.getCommand(n);
            if (c == null) continue;
            cc.append(c);
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private Command createDestructionCommand(IReferencable toDestroy, java.util.Map<?, ?> transactionOptions) {
        boolean optimizedDesctruction;
        boolean bl = optimizedDesctruction = transactionOptions != null && Boolean.TRUE == transactionOptions.get("com.indy.map.util.synchro.IMapReferencesSynchronizer.optimizedDesctruction");
        if (optimizedDesctruction) {
            if (toDestroy instanceof Field) {
                return new DestroyRFieldCommand((Field)toDestroy);
            }
            return new DestroyRItemCommand(toDestroy);
        }
        return new DestroyRItemCommand(toDestroy);
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        CompoundCommand cc = new CompoundCommand();
        for (Notification n : event.getNotifications()) {
            if (!this.getFilter().matches(n) || n.getFeature() == MapPackage.eINSTANCE.getMapModelItem_Annotation()) continue;
            if (n.getEventType() == 3 && n.getNewValue() instanceof IReferencable) {
                this.getReference((IReferencable)n.getNewValue());
                if (n.getNewValue() instanceof ILogicalField) {
                    for (Expression e : ((ILogicalField)n.getNewValue()).getExpression()) {
                        this.getReference(e);
                    }
                }
            }
            if (event.getTransaction() != null && (event.getTransaction().isReadOnly() || Boolean.TRUE.equals(event.getTransaction().getOptions().get("is_undo_redo_transaction")))) {
                if (n.getEventType() != 4 && n.getEventType() != 6 || !(n.getFeature() instanceof EReference) || !((EReference)n.getFeature()).isContainment()) continue;
                if (n.getOldValue() instanceof IReferencable) {
                    cc.append(this.createDestructionCommand((IReferencable)n.getOldValue(), event.getTransaction().getOptions()));
                    continue;
                }
                if (!(n.getOldValue() instanceof Collection)) continue;
                for (Object o : (Collection)n.getOldValue()) {
                    if (!(o instanceof IReferencable)) continue;
                    cc.append(this.createDestructionCommand((IReferencable)o, event.getTransaction().getOptions()));
                }
                continue;
            }
            if (n.getEventType() != 4 && n.getEventType() != 6 || !(n.getFeature() instanceof EReference) || !((EReference)n.getFeature()).isContainment()) continue;
            if (n.getOldValue() instanceof Collection) {
                for (Object o : (Collection)n.getOldValue()) {
                    boolean cfr_ignored_0 = o instanceof IReferencable;
                }
                continue;
            }
            if (!(n.getOldValue() instanceof IReferencable)) continue;
            cc.append(this.createDestructionCommand((IReferencable)n.getOldValue(), event.getTransaction().getOptions()));
        }
        if (!cc.isEmpty()) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("no_undo", Boolean.TRUE);
            options.put("no_validation", Boolean.TRUE);
            options.put("no_triggers", Boolean.TRUE);
            options.put("unprotected", Boolean.TRUE);
            try {
                ((TransactionalCommandStack)event.getEditingDomain().getCommandStack()).execute((Command)cc, options);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error("Unexpected Interrupion", (Throwable)e);
            }
            catch (RollbackException e) {
                this.logger.error("Unexpected", (Throwable)e);
            }
        }
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    @Override
    public boolean isIniting() {
        return this.initializing;
    }

    @Override
    public void unSynchronize(List<IReferencable> toUnsync) {
        for (IReferencable o : toUnsync) {
            this.synchMap.remove(o);
        }
    }

    private class CreateRItemCommand
    extends AbstractCommand {
        private IReferencable semanticObject;

        CreateRItemCommand(IReferencable semanticObject) {
            this.semanticObject = semanticObject;
        }

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            MapReferencesSynchronizerImpl.this.getReference(this.semanticObject);
        }

        public void redo() {
            this.execute();
        }

        public void undo() {
        }

        public void dispose() {
            this.semanticObject = null;
            super.dispose();
        }
    }

    private class DestroyRFieldCommand
    extends DestroyRItemCommand {
        DestroyRFieldCommand(Field semanticObject) {
            super(semanticObject);
        }

        @Override
        protected void destroyReference(RItem i) {
            if (i != null) {
                i.eSetDeliver(false);
                for (RExpression ex : ((RField)i).getExpressionRef()) {
                    ex.getSourceRef().clear();
                }
                ((RField)i).getUsage().clear();
                ((RContainer)i.eContainer()).getFieldRef().remove((Object)i);
            }
        }
    }

    private class DestroyRItemCommand
    extends AbstractCommand {
        private IReferencable semItem;

        DestroyRItemCommand(IReferencable semanticObject) {
            this.semItem = semanticObject;
        }

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            EObject rMap = MapReferencesSynchronizerImpl.this.synchMap.get(this.semItem);
            while (rMap != null && !(rMap instanceof RMap)) {
                rMap = rMap.eContainer();
            }
            TreeIterator it = this.semItem.eAllContents();
            while (it.hasNext()) {
                RItem i;
                EObject eo = (EObject)it.next();
                if (!(eo instanceof IReferencable) || (i = MapReferencesSynchronizerImpl.this.synchMap.remove(eo)) == null) continue;
                if (rMap != null) {
                    for (RProblem p : i.getProblem()) {
                        if (p.getProblemType() != RProblem.Type.ERROR) continue;
                        try {
                            ((Map)((RMap)rMap).getDataModel()).decrementErrorCounter();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                i.eAdapters().clear();
            }
            RItem i = MapReferencesSynchronizerImpl.this.synchMap.remove(this.semItem);
            if (i != null) {
                if (rMap != null) {
                    for (RProblem p : i.getProblem()) {
                        if (p.getProblemType() != RProblem.Type.ERROR) continue;
                        try {
                            ((Map)((RMap)rMap).getDataModel()).decrementErrorCounter();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (i instanceof RUsage) {
                    for (RSourceItem s : ((RUsage)i).getSourceRef()) {
                        if (!(s instanceof RField) || s.getUsage().size() != 1) continue;
                        ((Field)s.getDataModel()).eSetDeliver(false);
                        ((Field)s.getDataModel()).setFullAlias(null);
                        ((Field)s.getDataModel()).eSetDeliver(true);
                    }
                }
                EStructuralFeature feature = i.eContainingFeature();
                this.destroyReference(i);
                if (rMap instanceof RMap) {
                    rMap.eNotify((Notification)new ENotificationImpl((InternalEObject)i.eContainer(), 4, feature, (Object)i, null));
                }
            }
        }

        protected void destroyReference(RItem i) {
            try {
                i.eSetDeliver(false);
                EcoreUtil.delete((EObject)i, (boolean)true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                EcoreUtil.delete((EObject)i, (boolean)true);
            }
        }

        public void redo() {
            this.execute();
        }

        public void undo() {
        }

        public void dispose() {
            this.semItem = null;
            super.dispose();
        }
    }
}

