/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.updaters.impl;

import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.custom.commands.UpdateDatastoreCommand;
import com.indy.map.impl.DatastoreImpl;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RDatastore;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.updaters.impl.ContainerUpdater;
import java.util.HashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class DatastoreUpdater
extends ContainerUpdater {
    @Override
    public void updateAll(RContainer refItem) throws Exception {
        super.updateAll(refItem);
        if (refItem.getDataModel() instanceof Datastore) {
            this.updateRef((Datastore)refItem.getDataModel());
            this.updateIsHierarchical(refItem);
        }
    }

    private void updateRef(Datastore dataModel) {
        if (!((IMapResource)dataModel.eResource()).autoUpgradeModel()) {
            return;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dataModel);
        if (domain != null && ((IMapResource)dataModel.eResource()).autoUpgradeModel()) {
            UpdateDatastoreCommand cmd = new UpdateDatastoreCommand(domain, dataModel);
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("unprotected", Boolean.TRUE);
            options.put("no_triggers", Boolean.TRUE);
            options.put("no_undo", Boolean.TRUE);
            try {
                ((TransactionalCommandStack)domain.getCommandStack()).execute((Command)cmd, options);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (RollbackException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateIsHierarchical(RContainer refItem) {
        Datastore dataStore = (Datastore)refItem.getDataModel();
        for (Field f : dataStore.getField()) {
            if (f.getParent() == null) continue;
            ((RDatastore)refItem).setHierarchical(true);
            ((DatastoreImpl)dataStore).setHierarchical(true);
            break;
        }
    }
}

