/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.IContainer;
import com.indy.map.Operator;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RProblem;
import com.indy.map.util.InheritanceHelper;
import com.indy.map.validation.ClauseConstraint;
import com.indy.map.validation.ProblemValidationStatus;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;

public class OperatorConstraint
extends ClauseConstraint {
    @Override
    public IStatus validate(IValidationContext ctx) {
        try {
            EObject eObj = ctx.getTarget();
            IStatus s = super.validate(ctx);
            HashSet<ProblemValidationStatus.ProblemEntry> l = new HashSet<ProblemValidationStatus.ProblemEntry>();
            if (eObj instanceof Operator || eObj instanceof RClause && ((RClause)eObj).getDataModel() instanceof Operator) {
                Operator operator;
                Operator operator2 = operator = eObj instanceof Operator ? (Operator)eObj : (Operator)((RClause)eObj).getDataModel();
                if (operator.getFilteredDataSet() == null) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_OPERATOR_NO_FILTERED_DATASET, null));
                }
                if (operator.getFilteringDataSet() == null) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_OPERATOR_NO_FILTERING_DATASET, null));
                }
                for (IContainer c : operator.getInvolvedContainers()) {
                    if (c.getDataset() == operator.getFilteredDataSet() || c.getDataset() == operator.getFilteringDataSet() || InheritanceHelper.getDataSetHierarchy(operator.getFilteredDataSet()).contains(c.getDataset()) || InheritanceHelper.getDataSetHierarchy(operator.getFilteringDataSet()).contains(c.getDataset())) continue;
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_OPERATOR_USED_FIELD_DATASET, c.getAlias().toString()));
                }
                if (s instanceof ProblemValidationStatus) {
                    ((ProblemValidationStatus)s).getResultLocus().addAll(l);
                    return s;
                }
                return new ProblemValidationStatus((EObject)operator.getMapReference(), null, l);
            }
            return s;
        }
        catch (Throwable t) {
            return new Status(4, "com.indy.gmf.map", ((Object)((Object)this)).getClass().getName() + " Validation failed ", t);
        }
    }
}

