/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.Datastore;
import com.indy.map.IContainer;
import com.indy.map.MapPackage;
import com.indy.map.Template;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RTemplate;
import com.indy.map.validation.ProblemValidationStatus;
import com.semarchy.xdi.designer.core.capabilities.ICapability;
import com.semarchy.xdi.designer.core.capabilities.ICapabilityProvider;
import com.semarchy.xdi.designer.core.services.ITemplateProvider;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;

public class TemplateConstraint
extends AbstractModelConstraint {
    private Logger logger = LogManager.getLogger(TemplateConstraint.class);

    public IStatus validate(IValidationContext ctx) {
        try {
            EObject eObj = ctx.getTarget();
            if (eObj instanceof Template) {
                HashSet<ProblemValidationStatus.ProblemEntry> l = new HashSet<ProblemValidationStatus.ProblemEntry>();
                Template template = (Template)eObj;
                RTemplate ref = (RTemplate)template.getMapReference();
                if (template.getProcess() == null) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TEMPLATE_NO_PROCESS, null));
                } else if (template.getProcess().eIsProxy()) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TEMPLATE_PROXY_PROCESS, null));
                } else if (ref.getTemplateType() == RTemplate.Type.INTEGRATION && template.getProcess() instanceof ICapabilityProvider) {
                    for (IContainer c : ref.getTargetRef()) {
                        boolean stagingAreaSupportedByTemplate;
                        if (!(c instanceof Datastore) || !c.eIsSet((EStructuralFeature)MapPackage.eINSTANCE.getDatastore_StagingArea())) continue;
                        ICapability capability = ((ICapabilityProvider)template.getProcess()).getCapability("template-feature-support", "stagingArea");
                        boolean bl = stagingAreaSupportedByTemplate = capability != null;
                        if (stagingAreaSupportedByTemplate) {
                            try {
                                stagingAreaSupportedByTemplate = template.isSupported(capability);
                            }
                            catch (Exception e) {
                                this.logger.warn("Failed to evalute Integration StageAread capability for template {} on {}", (Object)template.getName(), (Object)template.eResource().getURI(), (Object)e);
                                stagingAreaSupportedByTemplate = false;
                            }
                        }
                        if (stagingAreaSupportedByTemplate) break;
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TEMPLATE_DONT_HANDLE_STAGING_AREA, c.getAlias().toString()));
                        break;
                    }
                }
                try {
                    List list = ((ITemplateProvider)E4InjectorHelper.getService(ITemplateProvider.class)).getTemplate(((RTemplate)template.getMapReference()).getTemplateCriteria(), (EObject)template);
                    String procFileID = CacheHelper.extractFileID((EObject)template.getProcess());
                    String procEltID = CacheHelper.extractEltID((EObject)template.getProcess());
                    boolean processProvider = false;
                    for (EObject o : list) {
                        String fID = CacheHelper.extractFileID((EObject)o);
                        String eltID = CacheHelper.extractEltID((EObject)o);
                        if (!procFileID.equals(fID) || !procEltID.equals(eltID)) continue;
                        processProvider = true;
                        break;
                    }
                    if (!processProvider) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_TEMPLATE_USING_UNPROVIDED_PROCESS, null));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return new ProblemValidationStatus(ref, null, l);
            }
            return ctx.createSuccessStatus();
        }
        catch (Exception t) {
            return new Status(4, "com.indy.gmf.map", ((Object)((Object)this)).getClass().getName() + " Validation failed ", (Throwable)t);
        }
    }
}

