/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation.parsers;

import com.indy.map.Clause;
import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.MapLocation;
import com.indy.map.TargetFilter;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.semarchy.xdi.designer.core.IExpressionParser;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class ExpressionParserHelper {
    public static final String PARSER_MODE = "com.indy.map.validation.parsers.sqlparser.option.mode";
    private static final java.util.Map<String, Object> expressionOptions;
    private static final java.util.Map<String, Object> clauseOptions;

    static {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(PARSER_MODE, 0);
        expressionOptions = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(PARSER_MODE, 1);
        clauseOptions = Collections.unmodifiableMap(map);
    }

    public static java.util.Map<String, Object> getExpressionOptions() {
        return expressionOptions;
    }

    public static java.util.Map<String, Object> getClauseOptions() {
        return clauseOptions;
    }

    public static EObject getContextConnection(Clause clause) {
        EObject connection = null;
        if (clause.getLocation() == JoinLocation.SRC) {
            if (!clause.getInvolvedContainers().isEmpty()) {
                connection = clause.getAPI().getMdEvaluator().evaluateConnection((IContainer)clause.getInvolvedContainers().get(0), IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
            }
        } else if (clause.getLocation() == JoinLocation.WRK) {
            if (clause instanceof TargetFilter) {
                connection = clause.getAPI().getMdEvaluator().evaluateConnection((IContainer)clause.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
            } else if (!clause.getInvolvedContainers().isEmpty()) {
                for (RSourceSet ss : ((RMap)((Map)clause.eContainer()).getMapReference()).getSourceSetRef(((IContainer)clause.getInvolvedContainers().get(0)).getDataset())) {
                    IContainer c = (IContainer)((RContainer)ss.getTargetSet().getContainer().get(0)).getDataModel();
                    connection = clause.getAPI().getMdEvaluator().evaluateConnection(c, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
                    if (connection != null) break;
                }
            }
        }
        return connection;
    }

    public static EObject getContextConnection(Expression expression) {
        EObject connection = null;
        if (expression.getLocation() == MapLocation.SRC) {
            for (RSourceItem it : ((RExpression)expression.getMapReference()).getSourceRef()) {
                if (!(it.getDataModel() instanceof ILogicalField)) continue;
                IContainer c = (IContainer)it.getDataModel().eContainer();
                connection = expression.getAPI().getMdEvaluator().evaluateConnection(c, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                if (connection == null) {
                    continue;
                }
                break;
            }
        } else {
            IContainer c = (IContainer)expression.eContainer().eContainer();
            connection = expression.getAPI().getMdEvaluator().evaluateConnection(c, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
        }
        return connection;
    }

    public static IExpressionParser createParser(String parseruri) throws Exception {
        if (parseruri == null) {
            return null;
        }
        URI parserURI = URI.createURI((String)parseruri);
        if (parserURI.isPlatformPlugin() && parserURI.segmentCount() == 3) {
            String bundleName = parserURI.segment(1);
            Bundle b = Platform.getBundle((String)bundleName);
            if (b != null) {
                Class<?> parserClass;
                BundleWiring bundleWiring = (BundleWiring)b.adapt(BundleWiring.class);
                try {
                    parserClass = bundleWiring.getClassLoader().loadClass(parserURI.segment(2));
                }
                catch (ClassNotFoundException e) {
                    throw new Exception("Class " + parserURI.segment(2) + " not found from bundle " + parserURI.segment(2));
                }
                if (parserClass != null) {
                    try {
                        IExpressionParser parser = (IExpressionParser)parserClass.newInstance();
                        return parser;
                    }
                    catch (Exception ex) {
                        throw new Exception("Unable to instanciate " + parserClass.getName(), ex);
                    }
                }
            } else {
                throw new Exception("Invalid bundle for the parser URI " + parseruri);
            }
        }
        return null;
    }
}

