/*
 * Decompiled with CFR 0.152.
 */
package com.indy.a.encryptors;

import com.indy.a.encryptors.FileEncryptor;
import com.indy.a.encryptors.Messages;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.crypto.Cipher;

public class AsymetricEncryptor
extends FileEncryptor {
    private PublicKey key;
    private PrivateKey pKey;
    private String algorithm;

    public AsymetricEncryptor(Certificate certificate, PrivateKey privateKey) throws OtherExceptionI {
        this.pKey = privateKey;
        this.key = certificate.getPublicKey();
        this.algorithm = this.key.getAlgorithm();
    }

    @Override
    public void encryptStream(InputStream in, OutputStream out) throws OtherExceptionI {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(1, this.key);
            byte[] inb = new byte[in.available()];
            in.read(inb);
            byte[] outb = cipher.doFinal(inb);
            out.write(outb);
        }
        catch (Exception e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    @Override
    public void decryptStream(InputStream in, OutputStream out) throws OtherExceptionI {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(2, this.pKey);
            byte[] inb = new byte[in.available()];
            in.read(inb);
            byte[] outb = cipher.doFinal(inb);
            out.write(outb);
        }
        catch (Exception e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    @Override
    public void decryptStreamNC(InputStream in, OutputStream out) throws OtherExceptionI {
        throw new OtherExceptionI(Messages.getString("AsymetricEncryptor.0"));
    }

    @Override
    public void encryptStreamNC(InputStream in, OutputStream out) throws OtherExceptionI {
        throw new OtherExceptionI(Messages.getString("AsymetricEncryptor.1"));
    }
}

