/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation;

import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.utils.ParameterBuilder;
import java.io.PrintStream;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Assert;
import org.osgi.service.component.annotations.Component;

@Component(service={IGenerationService.LoggingConfigurationFactory.class})
public class DefaultLoggingConfigurationFactory
implements IGenerationService.LoggingConfigurationFactory {
    public IGenerationService.LoggingConfiguration create(ParameterBuilder<IGenerationService.LoggingConfigurationOption, Object> parameters) {
        Object stdPrintStream = parameters.get((Object)IGenerationService.LoggingConfigurationOption.STD_PRINT_STREAM);
        Object errPrintStream = parameters.get((Object)IGenerationService.LoggingConfigurationOption.ERR_PRINT_STREAM);
        Assert.isTrue((boolean)(stdPrintStream instanceof PrintStream), (String)String.format("%s is not a Printstream", String.valueOf(stdPrintStream)));
        Assert.isTrue((boolean)(errPrintStream instanceof PrintStream), (String)String.format("%s is not a Printstream", String.valueOf(errPrintStream)));
        return new DefaultLoggingConfiguration((PrintStream)stdPrintStream, (PrintStream)errPrintStream);
    }

    private class DefaultLoggingConfiguration
    implements IGenerationService.LoggingConfiguration {
        private PrintStream outputStream;
        private PrintStream errorStream;

        public DefaultLoggingConfiguration(PrintStream outputStream, PrintStream errorStream) {
            this.errorStream = errorStream;
            this.outputStream = outputStream;
        }

        public PrintStream getErrorPrintStream() {
            return this.errorStream;
        }

        public PrintStream getOutputPrintStream() {
            return this.outputStream;
        }

        public int getLogLevel() {
            return 2;
        }

        public Consumer<Exception> getExceptionHandler() {
            return null;
        }
    }
}

