/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.ant;

import com.semarchy.xdi.designer.generation.ant.Messages;
import com.semarchy.xdi.designer.generation.ant.UDFXslGenerator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSLGeneratorUDFCallback
extends Task {
    private static final String IMPLEMENTATION_TAG = "implementation";
    private static final String ATT_DEF_TYPE = "defType";
    private static final String ATT_ID = "id";
    private static final String ATT_EXPRESSION = "expression";
    private static final String IMPLEMENTATION_DEF_TYPE = "com.stambia.function.implementation";
    private String outputFile;
    private String inputPropertiesFile;
    public static final String DEFAUL_IMPLEMENTATION = "__default__";
    private boolean append = false;

    public void setInputPropertiesFile(String inputPropertiesFile) {
        this.inputPropertiesFile = inputPropertiesFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setAppend(String append) {
        this.append = Boolean.valueOf(append);
    }

    public void execute() throws BuildException {
        File propFile = new File(this.inputPropertiesFile);
        if (!propFile.exists() || !propFile.isFile()) {
            this.log(Messages.XSLGeneratorUDFCallback_0);
            return;
        }
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileReader fr = new FileReader(propFile);){
                props.load(fr);
                Enumeration<Object> keys = props.keys();
                ArrayList<LightUDF> functions = new ArrayList<LightUDF>();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (!key.startsWith("udfModelId.")) continue;
                    String modelID = key.substring(key.indexOf(".") + 1);
                    functions.addAll(this.readUDFMd(modelID, props.getProperty(key)));
                }
                UDFXslGenerator xslGenerator = new UDFXslGenerator();
                xslGenerator.generateXsl(functions, new File(this.outputFile), this.append);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            this.log(Messages.XSLGeneratorUDFCallback_1, ex, 0);
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
    }

    private List<LightUDF> readUDFMd(String udfModelId, String modelFilePath) throws Exception {
        UDFMdContentHandler h = new UDFMdContentHandler(udfModelId);
        try (InputStream is = null;){
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parserFactory.setFeature("http://xml.org/sax/features/validation", false);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(h);
            is = new BufferedInputStream(new FileInputStream(modelFilePath));
            reader.parse(new InputSource(is));
            List<LightUDF> list = h.res;
            return list;
        }
    }

    public class LightUDF {
        public final String libId;
        public final String prefix;
        public final String name;
        public final Map<String, String> implPerCode = new HashMap<String, String>();
        public final List<String> parameters = new ArrayList<String>();

        private LightUDF(String libId, String prefix, String name) {
            this.libId = libId;
            this.prefix = prefix;
            this.name = name;
        }
    }

    private class UDFMdContentHandler
    implements ContentHandler {
        String prefix = null;
        String libId;
        StringBuilder poductCode = null;
        String implementationCode = null;
        boolean defaultImpl = false;
        List<LightUDF> res = new ArrayList<LightUDF>();
        LightUDF current = null;

        UDFMdContentHandler(String libId) {
            this.libId = libId;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("udf")) {
                this.prefix = atts.getValue("prefix");
            } else if (localName.equals("function")) {
                this.current = new LightUDF(this.libId, this.prefix, atts.getValue("name"));
            } else if (localName.equals("parameter")) {
                this.current.parameters.add(atts.getValue("name"));
            } else if (localName.equals(XSLGeneratorUDFCallback.IMPLEMENTATION_TAG)) {
                this.implementationCode = atts.getValue(XSLGeneratorUDFCallback.ATT_EXPRESSION);
                this.defaultImpl = true;
            } else if (localName.equals("productCode")) {
                this.poductCode = new StringBuilder();
                this.defaultImpl = false;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("function")) {
                this.res.add(this.current);
                this.current = null;
                this.defaultImpl = false;
            } else if (localName.equals(XSLGeneratorUDFCallback.IMPLEMENTATION_TAG)) {
                if (this.defaultImpl) {
                    this.current.implPerCode.put(XSLGeneratorUDFCallback.DEFAUL_IMPLEMENTATION, this.implementationCode);
                    this.defaultImpl = false;
                }
                this.implementationCode = null;
                this.poductCode = null;
            } else if (localName.equals("productCode")) {
                this.current.implPerCode.put(this.poductCode.toString(), this.implementationCode);
                this.poductCode = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.poductCode != null) {
                this.poductCode.append(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }
}

