/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.map.Clause;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.Filter;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.MapLocation;
import com.indy.map.TargetFilter;
import com.indy.map.Template;
import com.indy.map.api.IMapAPI;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RUsage;
import com.semarchy.xdi.designer.generation.mapping.internal.FieldOrderComparator;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import com.semarchy.xdi.designer.generation.mapping.internal.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class LoadVisitor {
    private MdModelBuilder modelBuilder;
    private Map<Template, LoadData> results = new HashMap<Template, LoadData>();

    LoadVisitor() {
    }

    static LoadVisitor of(MdModelBuilder modelBuilder) {
        LoadVisitor res = new LoadVisitor();
        res.modelBuilder = modelBuilder;
        modelBuilder.getSortedTemplate().stream().filter(t -> mdModelBuilder.buildHelper.getMapAPI().getTemplateType(t) == RTemplate.Type.LOAD).forEach(res::visit);
        return res;
    }

    private LoadData visit(Template loadTemplate) {
        LoadData res = new LoadData();
        IMapAPI api = this.modelBuilder.buildHelper.getMapAPI();
        for (IContainer source : api.getRef(loadTemplate)) {
            for (ILogicalField srcField : source.getLogicalField()) {
                for (RUsage u : this.modelBuilder.buildHelper.getRefRelationHelperfHelper().getUsage((RSourceItem)((IReferencable)srcField).getMapReference())) {
                    if (u.getDataModel() instanceof Expression && !((Expression)u.getDataModel()).getExpression().trim().isEmpty()) {
                        boolean isSrc;
                        if (!((ILogicalField)u.getDataModel().eContainer()).isEnable() || !api.getTargetRef(loadTemplate).contains(u.getDataModel().eContainer().eContainer())) continue;
                        Expression expression = (Expression)u.getDataModel();
                        ILogicalField trgField = (ILogicalField)expression.eContainer();
                        boolean isTrgQueryField = Utils.isGeneratedAsQueryField(trgField);
                        boolean isWork = isTrgQueryField || Utils.isGeneratedAsDatastoreField(srcField) && expression.getLocation() == MapLocation.WRK;
                        boolean bl = isSrc = Utils.isGeneratedAsQueryField(srcField) || expression.getLocation() == MapLocation.SRC;
                        if (isWork) {
                            res.fieldsFromWrk.add(srcField);
                            continue;
                        }
                        if (!isSrc) continue;
                        res.expressionOnSrc.add(expression);
                        this.modelBuilder.buildHelper.getSourceRef(expression).stream().map(RItem::getDataModel).filter(o -> o instanceof Field && ((Field)o).isExtraStatic() && ((Field)o).getParent() != null && Utils.isGeneratedAsDatastoreField(o)).map(o -> (Field)o).forEach(f -> {
                            boolean bl = loadData.extraStaticFields.computeIfAbsent(expression, key -> new ArrayList()).add(f);
                        });
                        continue;
                    }
                    if (!(u.getDataModel() instanceof Clause) || ((Clause)u.getDataModel()).getExpression().trim().isEmpty() || !((Clause)u.getDataModel()).isEnable()) continue;
                    Clause clause = (Clause)u.getDataModel();
                    if (clause.getLocation() == JoinLocation.WRK) {
                        if (clause instanceof TargetFilter && !api.getTargetRef(loadTemplate).contains(clause.eContainer())) continue;
                        res.fieldsFromWrk.add(srcField);
                        continue;
                    }
                    if (clause instanceof Join) {
                        res.joins.add((Join)clause);
                        continue;
                    }
                    if (!(clause instanceof Filter)) continue;
                    res.filters.add((Filter)clause);
                }
            }
        }
        res.fieldsFromWrk = new LinkedHashSet<ILogicalField>(res.fieldsFromWrk.stream().sorted(new FieldOrderComparator.FieldComparator(this.modelBuilder.buildHelper.getMapAPI())).collect(Collectors.toList()));
        this.results.put(loadTemplate, res);
        return res;
    }

    public LoadData getLoadData(Template tpl) {
        return this.results.get(tpl);
    }

    class LoadData {
        Set<Join> joins = new LinkedHashSet<Join>();
        Set<Filter> filters = new LinkedHashSet<Filter>();
        Set<ILogicalField> fieldsFromWrk = new HashSet<ILogicalField>();
        Set<Expression> expressionOnSrc = new LinkedHashSet<Expression>();
        Map<Expression, List<Field>> extraStaticFields = new HashMap<Expression, List<Field>>();

        LoadData() {
        }
    }
}

