/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.map.Clause;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.Filter;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.IReferencable;
import com.indy.map.ISerde;
import com.indy.map.Inliner;
import com.indy.map.Join;
import com.indy.map.MapPackage;
import com.indy.map.Operator;
import com.indy.map.Outliner;
import com.indy.map.Query;
import com.indy.map.SetDescriptor;
import com.indy.map.TargetFilter;
import com.indy.map.Template;
import com.indy.map.UDFRef;
import com.indy.map.Variable;
import com.indy.map.api.BuildHelper;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.api.RefRelationHelper;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RUsage;
import com.indy.map.util.UDFRequirementFinder;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.generation.mapping.internal.ClauseIdGenerator;
import com.semarchy.xdi.designer.generation.mapping.internal.ExpressionsResolver;
import com.semarchy.xdi.designer.generation.mapping.internal.FieldOrderComparator;
import com.semarchy.xdi.designer.generation.mapping.internal.IntegrationVisitor;
import com.semarchy.xdi.designer.generation.mapping.internal.LoadVisitor;
import com.semarchy.xdi.designer.generation.mapping.internal.MappingBuildException;
import com.semarchy.xdi.designer.generation.mapping.internal.MdClauseFactory;
import com.semarchy.xdi.designer.generation.mapping.internal.MdFieldFactory;
import com.semarchy.xdi.designer.generation.mapping.internal.MdLinkFactory;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModel;
import com.semarchy.xdi.designer.generation.mapping.internal.MdNodeFactory;
import com.semarchy.xdi.designer.generation.mapping.internal.RejectVisitor;
import com.semarchy.xdi.designer.generation.mapping.internal.Sequence;
import com.semarchy.xdi.designer.generation.mapping.internal.TemplateSorter;
import com.semarchy.xdi.designer.generation.mapping.internal.Utils;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

public class MdModelBuilder {
    MdSourceTracker mdSourceTracker = new MdSourceTracker();
    TemplateSorter tplSorter;
    Sequence loadSequence = new Sequence();
    Sequence integrationSequence = new Sequence();
    Sequence serdeSequence = new Sequence();
    Sequence rejectSequence = new Sequence();
    Sequence stageSequence = new Sequence();
    Sequence fieldSequence = new Sequence();
    ClauseIdGenerator clauseIdGenerator = new ClauseIdGenerator();
    MdFieldFactory mdFieldFactory = new MdFieldFactory(this);
    BuildHelper buildHelper;
    MdLinkFactory mdLinkFactory;
    com.indy.map.Map mapModel;
    Map<Template, MdModel.MdStep> steps = new LinkedHashMap<Template, MdModel.MdStep>();
    Map<MdModel.MdStep, Template> stepsByTpl = new HashMap<MdModel.MdStep, Template>();
    Map<String, MdModel.MdStep> stepsByName = new HashMap<String, MdModel.MdStep>();
    Map<String, URI> udfVariableRequired = new HashMap<String, URI>();
    Map<IMetaData, MdNode> stageObjectTypeMdNode;
    List<Template> templates;
    TemplateSorter templateSorter;

    static MdModelBuilder of(com.indy.map.Map mapModel, Map<IMetaData, MdNode> stageMd) {
        MdModelBuilder builder = new MdModelBuilder();
        builder.mapModel = mapModel;
        builder.stageObjectTypeMdNode = stageMd;
        builder.mdLinkFactory = new MdLinkFactory();
        builder.buildHelper = new BuildHelper(mapModel.getAPI(), new RefRelationHelper());
        builder.tplSorter = TemplateSorter.of(builder);
        builder.templateSorter = TemplateSorter.of(builder);
        return builder;
    }

    EObject delegate(MdModel.MdNodeGetter delegate) {
        this.mdLinkFactory.storeMdRef(delegate.get(), null);
        return delegate.get();
    }

    List<Template> getSortedTemplate() {
        if (this.templates == null) {
            this.templates = this.mapModel.getTemplate().stream().filter(tpl -> !this.buildHelper.getMapAPI().getTargetRef(tpl).isEmpty()).sorted((o1, o2) -> o1.getName().compareTo(o2.getName())).collect(Collectors.toList());
        }
        return this.templates;
    }

    private void refineSteps(Template stepTpl) {
        RTemplate.Type tplType = this.buildHelper.getMapAPI().getTemplateType(stepTpl);
        switch (tplType) {
            case LOAD: 
            case REJECT: {
                this.addIntegrationAsset(stepTpl);
                break;
            }
            case SERDE: {
                this.addSerdeAsset(stepTpl);
                break;
            }
            case INTEGRATION: {
                this.addIntegrationAssets(stepTpl);
                break;
            }
            case STAGING: {
                this.addStagingAssets(stepTpl);
            }
        }
    }

    private Map<MdModel.MdStep, Collection<MdModel.MdField>> createMdFields(LoadVisitor loadVisitor, IntegrationVisitor integrationVisitor, RejectVisitor rejectVisitor) {
        HashMap<MdModel.MdStep, Collection<MdModel.MdField>> mdFieldsPair = new HashMap<MdModel.MdStep, Collection<MdModel.MdField>>();
        this.steps.entrySet().stream().sorted(new LegacyStepComparator()).forEach(e -> {
            RTemplate.Type t = this.buildHelper.getMapAPI().getTemplateType((Template)e.getKey());
            if (t == RTemplate.Type.LOAD) {
                mdFieldsPair.put((MdModel.MdStep)e.getValue(), this.createLoadFields((Template)e.getKey(), (MdModel.MdStep)e.getValue(), loadVisitor.getLoadData((Template)e.getKey())));
            } else if (t.isIntegration()) {
                mdFieldsPair.put((MdModel.MdStep)e.getValue(), this.createIntegrationFields((Template)e.getKey(), (MdModel.MdStep)e.getValue(), integrationVisitor.getIntegrationData((Template)e.getKey())));
            } else if (t == RTemplate.Type.REJECT) {
                ((MdModel.MdStep)e.getValue()).constraints.addAll(rejectVisitor.getConstraint((Template)e.getKey()));
            }
        });
        return mdFieldsPair;
    }

    private void createMdSources(LoadVisitor loadVisitor, IntegrationVisitor integrationVisitor) {
        for (Map.Entry<Template, MdModel.MdStep> e : this.steps.entrySet()) {
            switch (((RTemplate)e.getKey().getMapReference()).getTemplateType()) {
                case LOAD: {
                    this.computeMdSources(e.getValue(), loadVisitor.getLoadData(e.getKey())).forEach(c -> {
                        boolean bl = ((MdModel.MdStep)entry.getValue()).sources.add((MdModel.MdSource)c);
                    });
                    break;
                }
                case INTEGRATION: 
                case STAGING: 
                case SERDE: {
                    this.computeMdSources(e.getValue(), integrationVisitor.getIntegrationData(e.getKey())).forEach(c -> {
                        boolean bl = ((MdModel.MdStep)entry.getValue()).sources.add((MdModel.MdSource)c);
                    });
                }
            }
        }
    }

    private void handleVariables() {
        for (Variable v : this.mapModel.getVariable()) {
            this.mdLinkFactory.storeMdRef(v.basicGetRef(), v.getAlias().toString());
        }
        IRegistryService.IRegistry udfRegistry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(UDF.class);
        for (UDFRef r : this.mapModel.getUdfRef()) {
            List l = udfRegistry.find(this.mapModel.getAPI().getUDFIndentifier(r));
            if (l == null || l.isEmpty()) continue;
            URI mdNodeURI = ((UDF)l.get(0)).getMdNodeSourceURI();
            AnyType udfMdNode = XMLTypeFactory.eINSTANCE.createAnyType();
            ((InternalEObject)udfMdNode).eSetProxyURI(mdNodeURI);
            this.mdLinkFactory.storeMdRef((EObject)udfMdNode, null);
        }
        try {
            UDFRequirementFinder finder = new UDFRequirementFinder(this.mapModel.getAPI(), udfRegistry, (List)this.mapModel.getUdfRef());
            for (Map.Entry e : finder.gatherMdNodes().entrySet()) {
                MdNode ref = MdFactory.eINSTANCE.createMdNode();
                ((InternalEObject)ref).eSetProxyURI((URI)e.getValue());
                this.mdLinkFactory.storeMdRef((EObject)ref, (String)e.getKey());
                this.udfVariableRequired.put((String)e.getKey(), (URI)e.getValue());
            }
        }
        catch (Exception ex) {
            throw new MappingBuildException("Failed to find Variables used by UDF", ex);
        }
    }

    public void buildModel() {
        this.getSortedTemplate().forEach(this::createStep);
        this.getSortedTemplate().stream().forEach(this::refineSteps);
        LoadVisitor loadVisitor = LoadVisitor.of(this);
        IntegrationVisitor integrationVisitor = IntegrationVisitor.of(this);
        RejectVisitor rejectVisitor = RejectVisitor.of(this);
        this.createMdFields(loadVisitor, integrationVisitor, rejectVisitor);
        this.createMdSources(loadVisitor, integrationVisitor);
        for (Map.Entry<MdModel.MdStep, Template> e : this.stepsByTpl.entrySet()) {
            for (MdModel.MdJoin j : e.getKey().joins) {
                j.leftSource = this.findSource4Join(e.getKey(), (IMetaData)j.leftContainer, j.expression.sourceSetName);
                j.rightSource = this.findSource4Join(e.getKey(), (IMetaData)j.rightContainer, j.expression.sourceSetName);
            }
        }
        ExpressionsResolver.of(this).resolve();
        this.handleVariables();
    }

    private MdModel.MdSource findSource4Join(MdModel.MdStep owner, IMetaData container, String sourceSetName) {
        return this.mdSourceTracker.find(owner, (IContainer)container, sourceSetName);
    }

    MdModel.MdSource createMdSourceDirect(IContainer sourceContainer, Optional<MdModel.MdStep> step, String sourceSetName) {
        MdModel.MdSource md = new MdModel.MdSource();
        md.sourceMode = MdModel.MdSourceMode.DIRECT;
        if (sourceContainer instanceof Datastore) {
            Datastore d = (Datastore)sourceContainer;
            md.setTargetMd(this.delegate(() -> ((Datastore)d).basicGetRef()));
        } else if (sourceContainer instanceof IMetaData) {
            IMetaData sc = (IMetaData)sourceContainer;
            EObject ref = (EObject)this.stageObjectTypeMdNode.getOrDefault(sc, (MdNode)sc.getRef());
            md.setTargetMd(this.delegate(() -> ref));
        }
        md.name = sourceContainer.getAlias().toString();
        if (step.isPresent()) {
            md.stepName = step.get().name;
        }
        md.tags = sourceContainer.getTag().stream().map(Object::toString).collect(Collectors.toList());
        md.sourceSetName = sourceSetName;
        return md;
    }

    private MdModel.MdSource createMdSource(MdModel.MdStep step, String sourceSetName, IContainer sourceContainer) {
        MdModel.MdSource md = new MdModel.MdSource();
        md.sourceMode = MdModel.MdSourceMode.STEP;
        md.name = step.name;
        md.stepName = step.name;
        md.sourceSetName = sourceSetName;
        md.number = step.number;
        if (sourceContainer != null) {
            md.tags = sourceContainer.getTag().stream().map(Object::toString).collect(Collectors.toList());
        }
        return md;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<MdModel.MdSource> computeMdSources(MdModel.MdStep owner, IntegrationVisitor.IntegrationData integrationData) {
        LinkedHashMap<CallSite, MdModel.MdSource> res = new LinkedHashMap<CallSite, MdModel.MdSource>();
        for (Map.Entry<SetDescriptor, IntegrationVisitor.SetData> entry : integrationData.dataPerSet.entrySet()) {
            HashMap sourceContainers = new HashMap();
            entry.getValue().clauses.stream().flatMap(c -> this.buildHelper.getSourceRef(c).stream()).map(RItem::getDataModel).filter(ILogicalField.class::isInstance).forEach(f -> {
                boolean bl = sourceContainers.computeIfAbsent((IContainer)f.eContainer(), k -> new HashSet()).add((ILogicalField)f);
            });
            entry.getValue().expressionsPerSet.stream().flatMap(c -> this.buildHelper.getSourceRef(c).stream()).map(RItem::getDataModel).filter(ILogicalField.class::isInstance).forEach(f -> {
                boolean bl = sourceContainers.computeIfAbsent((IContainer)f.eContainer(), k -> new HashSet()).add((ILogicalField)f);
            });
            Set filteringSources = entry.getValue().clauses.stream().filter(Operator.class::isInstance).map(c -> (Operator)c).flatMap(c -> c.getFilteringDataSet().getContainer().stream()).collect(Collectors.toSet());
            String sourceSetName = entry.getValue().sourceSetName;
            HashSet<Object> handled = new HashSet<Object>();
            String integrationConnectionId = this.buildHelper.getMapAPI().getMdEvaluator().evaluateConnectionId((IContainer)((RTemplate)integrationData.template.getMapReference()).getTargetRef().get(0), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
            for (IContainer c2 : sourceContainers.keySet()) {
                if (c2 == ((RTemplate)integrationData.template.getMapReference()).getTargetRef().get(0)) continue;
                MdModel.MdSource md = null;
                String sourceConnectionId = "";
                sourceConnectionId = c2.hasStagingArea() ? this.buildHelper.getMapAPI().getMdEvaluator().evaluateConnectionId(c2, IMetaDataInformationsProvider.EvaluationLocation.ON_REF) : this.buildHelper.getMapAPI().getMdEvaluator().evaluateConnectionId(c2, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
                boolean isDirectDatastore = false;
                if (integrationConnectionId.equals(sourceConnectionId)) {
                    if (c2 instanceof ISerde) {
                        o = this.steps.entrySet().stream().filter(e -> e.getValue() != owner).filter(e -> ((RTemplate)((Template)e.getKey()).getMapReference()).getTemplateType() == RTemplate.Type.SERDE).filter(e -> ((RTemplate)((Template)e.getKey()).getMapReference()).getTargetRef().contains((Object)c2)).filter(e -> this.isBefore((MdModel.MdStep)e.getValue(), owner)).map(Map.Entry::getValue).findFirst();
                        if (!o.isPresent()) throw new MappingBuildException("unexpected");
                        if (!handled.add(c2)) {
                            md = (MdModel.MdSource)res.get(o.get().name + "/" + sourceSetName);
                            continue;
                        }
                        md = this.createMdSource(o.get(), sourceSetName, c2);
                    } else {
                        o = this.steps.entrySet().stream().filter(e -> e.getValue() != owner).filter(e -> ((RTemplate)((Template)e.getKey()).getMapReference()).getTemplateType() == RTemplate.Type.STAGING || ((RTemplate)((Template)e.getKey()).getMapReference()).getTemplateType() == RTemplate.Type.SERDE).filter(e -> this.buildHelper.getMapAPI().getTargetRef((Template)e.getKey()).contains(c2)).filter(e -> this.isBefore((MdModel.MdStep)e.getValue(), owner)).map(Map.Entry::getValue).findFirst();
                        if (o.isPresent()) {
                            if (c2 instanceof Datastore || c2 instanceof Query && !Utils.isGeneratedAsQuery(c2)) {
                                md = this.createMdSourceDirect(c2, o, sourceSetName);
                                isDirectDatastore = true;
                            } else {
                                md = this.createMdSource(o.get(), sourceSetName, c2);
                            }
                        } else {
                            o = this.steps.entrySet().stream().filter(e -> ((RTemplate)((Template)e.getKey()).getMapReference()).getTemplateType().isIntegration()).filter(e -> this.buildHelper.getMapAPI().getTargetRef((Template)e.getKey()).contains(c2)).filter(e -> this.isBefore((MdModel.MdStep)e.getValue(), owner)).map(Map.Entry::getValue).findFirst();
                            md = this.createMdSourceDirect(c2, o, sourceSetName);
                            isDirectDatastore = true;
                        }
                    }
                    if (c2.getOrder() != null) {
                        md.order = c2.getOrder().intValue();
                    }
                } else {
                    o = this.steps.entrySet().stream().filter(e -> ((RTemplate)((Template)e.getKey()).getMapReference()).getTemplateType() == RTemplate.Type.LOAD).filter(e -> this.buildHelper.getMapAPI().getRef((Template)e.getKey()).contains(c2) && this.buildHelper.getMapAPI().getTargetRef((Template)e.getKey()).contains(((RTemplate)this.stepsByTpl.get(owner).getMapReference()).getTargetRef().get(0))).filter(e -> this.isBefore((MdModel.MdStep)e.getValue(), owner)).map(Map.Entry::getValue).findFirst();
                    if (!o.isPresent()) {
                        o = this.steps.entrySet().stream().filter(e -> ((RTemplate)((Template)e.getKey()).getMapReference()).getTemplateType() == RTemplate.Type.STAGING || ((RTemplate)((Template)e.getKey()).getMapReference()).getTemplateType() == RTemplate.Type.SERDE).filter(e -> this.buildHelper.getMapAPI().getTargetRef((Template)e.getKey()).contains(c2)).filter(e -> this.isBefore((MdModel.MdStep)e.getValue(), owner)).map(Map.Entry::getValue).findFirst();
                    }
                    if (!(!o.isPresent() || integrationData.noLoad && Utils.isGeneratedAsDatastore(c2))) {
                        if (!handled.add(o.get())) {
                            md = (MdModel.MdSource)res.get(o.get().name + "/" + sourceSetName);
                            this.mdSourceTracker.track(owner, md, c2);
                            continue;
                        }
                        md = this.createMdSource(o.get(), sourceSetName, c2);
                        if (c2.getOrder() != null) {
                            md.order = c2.getOrder().intValue();
                        }
                    } else {
                        if (!handled.add(c2)) {
                            md = (MdModel.MdSource)res.get(c2.getAlias().toString() + "/" + sourceSetName);
                            continue;
                        }
                        if (o.isEmpty()) {
                            o = this.steps.entrySet().stream().filter(e -> ((RTemplate)((Template)e.getKey()).getMapReference()).getTemplateType().isIntegration()).filter(e -> this.buildHelper.getMapAPI().getTargetRef((Template)e.getKey()).get(0) == c2).filter(e -> this.isBefore((MdModel.MdStep)e.getValue(), owner)).map(Map.Entry::getValue).findFirst();
                        }
                        md = this.createMdSourceDirect(c2, o, sourceSetName);
                        isDirectDatastore = true;
                    }
                }
                if (isDirectDatastore && Utils.isGeneratedAsDatastore(c2)) {
                    boolean bl = md.cdc = c2 instanceof Datastore && ((Datastore)c2).isUseCDC();
                }
                if (filteringSources.contains(c2)) {
                    md.filteringSource = true;
                }
                res.put((CallSite)((Object)(md.name + "/" + sourceSetName)), md);
                this.mdSourceTracker.track(owner, md, c2);
            }
        }
        return res.values();
    }

    boolean isBefore(MdModel.MdStep currentStep, MdModel.MdStep step) {
        TemplateSorter.ProcessGraphStep current = this.templateSorter.tplToProcessGraphStep.get(this.stepsByTpl.get(currentStep));
        TemplateSorter.ProcessGraphStep tested = this.templateSorter.tplToProcessGraphStep.get(this.stepsByTpl.get(step));
        return tested.belongsToPrevious(current);
    }

    private Set<MdModel.MdSource> computeMdSources(MdModel.MdStep owner, LoadVisitor.LoadData data) {
        HashMap sourceContainers = new HashMap();
        data.fieldsFromWrk.stream().forEach(f -> {
            boolean bl = sourceContainers.computeIfAbsent((IContainer)f.eContainer(), k -> new HashSet()).add(f);
        });
        data.expressionOnSrc.stream().flatMap(e -> this.buildHelper.getSourceRef(e).stream()).map(RItem::getDataModel).filter(ILogicalField.class::isInstance).forEach(f -> {
            boolean bl = sourceContainers.computeIfAbsent((IContainer)f.eContainer(), k -> new HashSet()).add((ILogicalField)f);
        });
        ArrayList<Object> clauses = new ArrayList<Object>();
        clauses.addAll(data.joins);
        clauses.addAll(data.filters);
        for (Clause clause : clauses) {
            this.buildHelper.getSourceRef(clause).stream().map(RItem::getDataModel).filter(ILogicalField.class::isInstance).forEach(f -> {
                boolean bl = sourceContainers.computeIfAbsent((IContainer)f.eContainer(), k -> new HashSet()).add((ILogicalField)f);
            });
        }
        LinkedHashSet<MdModel.MdSource> linkedHashSet = new LinkedHashSet<MdModel.MdSource>();
        for (Map.Entry entry : sourceContainers.entrySet()) {
            Optional<MdModel.MdStep> o = this.steps.entrySet().stream().filter(e -> this.isBefore((MdModel.MdStep)e.getValue(), owner)).filter(e -> ((RTemplate)((Template)e.getKey()).getMapReference()).getTemplateType().isIntegration() && this.buildHelper.getMapAPI().getTargetRef((Template)e.getKey()).get(0) == entry.getKey()).map(Map.Entry::getValue).findFirst();
            MdModel.MdSource md = null;
            if (entry.getKey() instanceof Datastore || this.stageObjectTypeMdNode.get((IMetaData)entry.getKey()) != null) {
                md = this.createMdSourceDirect((IContainer)entry.getKey(), o, null);
                linkedHashSet.add(md);
                IContainer iContainer = (IContainer)entry.getKey();
                if (iContainer instanceof Datastore) {
                    Datastore ds = (Datastore)iContainer;
                    md.cdc = ds.isUseCDC();
                }
            } else {
                if (o.isEmpty()) {
                    throw new MappingBuildException(String.format("Could not find integration step for IContainer %s", ((IContainer)entry.getKey()).getAlias()));
                }
                md = this.createMdSource(o.get(), null, (IContainer)entry.getKey());
                linkedHashSet.add(md);
            }
            this.mdSourceTracker.track(owner, md, (IContainer)entry.getKey());
        }
        return linkedHashSet;
    }

    private List<MdModel.MdField> createIntegrationFields(Template tpl, MdModel.MdStep step, IntegrationVisitor.IntegrationData data) {
        String connectionId = tpl.getAPI().getMdEvaluator().evaluateConnectionId((IContainer)((RTemplate)tpl.getMapReference()).getTargetRef().get(0), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
        ArrayList<MdModel.MdField> createdFields = new ArrayList<MdModel.MdField>();
        IContainer trg = (IContainer)((RTemplate)tpl.getMapReference()).getTargetRef().get(0);
        for (SetDescriptor setDesc : trg.getSetDescriptor()) {
            IntegrationVisitor.SetData setData = data.dataPerSet.get(setDesc);
            String sourceSetName = setData.sourceSetName;
            Function<IReferencable, String> sourceSetNameFunction = expr -> {
                if (integrationData.noLoad && setData.sourceSetNameFromNoLoad) {
                    return ((RUsage)expr.getMapReference()).getRealSourceRef().stream().anyMatch(r -> r.getDataModel() instanceof ILogicalField) ? sourceSetName : null;
                }
                return sourceSetName;
            };
            trg.getLogicalField().stream().sorted(new FieldOrderComparator.FieldComparator(this.buildHelper.getMapAPI())).forEach(f -> {
                Expression expr = f.getExpression(setDesc);
                if (!setData.expressionsPerSet.contains(expr)) {
                    return;
                }
                MdModel.MdField integrationField = this.mdFieldFactory.createIntegrationField(connectionId, integrationData.noLoad, this.fieldSequence, expr, sourceSetNameFunction, (Collection<Field>)setData.extraStaticFields.get(expr));
                if (f instanceof IMetaData) {
                    IMetaData metaData = (IMetaData)f;
                    MdNode mdNode = this.stageObjectTypeMdNode.get(metaData);
                    if (setDesc == trg.getSetDescriptor().get(0) && mdNode != null) {
                        integrationField.workNameListeners.add(() -> MdNodeFactory.addStringAttribute(mdNode, "name", integrationField.getWorkName()));
                    }
                }
                createdFields.add(integrationField);
            });
            setData.clauses.stream().filter(Filter.class::isInstance).map(c -> (Filter)c).map(c -> MdClauseFactory.createFilter(this.clauseIdGenerator, c, sourceSetNameFunction)).forEach(f -> {
                boolean bl = mdStep.filters.add((MdModel.MdFilter)f);
            });
            setData.clauses.stream().filter(Join.class::isInstance).map(c -> (Join)c).map(c -> MdClauseFactory.createJoin(this.clauseIdGenerator, c, sourceSetName)).forEach(f -> {
                boolean bl = mdStep.joins.add((MdModel.MdJoin)f);
            });
            setData.clauses.stream().filter(TargetFilter.class::isInstance).map(c -> (TargetFilter)c).map(c -> MdClauseFactory.createTargetFilter(this.clauseIdGenerator, c, sourceSetNameFunction)).forEach(f -> {
                boolean bl = mdStep.filters.add((MdModel.MdFilter)f);
            });
            setData.clauses.stream().filter(Operator.class::isInstance).map(c -> (Operator)c).map(c -> MdClauseFactory.createFilter(this.clauseIdGenerator, c, sourceSetName)).forEach(f -> {
                boolean bl = mdStep.filters.add((MdModel.MdFilter)f);
            });
        }
        data.serdeUsedOutputFields.stream().map(f -> this.mdFieldFactory.createIntegrationSerdeField(connectionId, this.fieldSequence, (ILogicalField)f)).forEach(createdFields::add);
        createdFields.stream().forEach(f -> {
            boolean bl = mdStep.fields.add((MdModel.MdField)f);
        });
        return createdFields;
    }

    private List<MdModel.MdField> createLoadFields(Template tpl, MdModel.MdStep step, LoadVisitor.LoadData loadData) {
        String locationConnectionId = this.buildHelper.getMapAPI().getMdEvaluator().evaluateConnectionId((IContainer)((RTemplate)tpl.getMapReference()).getTargetRef().get(0), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
        Stream<MdModel.MdField> streamSrc = loadData.expressionOnSrc.stream().sorted(new FieldOrderComparator.ExpressionComparator(this.buildHelper.getMapAPI())).map(e -> this.mdFieldFactory.createLoadFieldOnSrc(locationConnectionId, this.fieldSequence, (Expression)e, (Collection<Field>)loadData.extraStaticFields.get(e)));
        Stream<MdModel.MdField> streamWrk = loadData.fieldsFromWrk.stream().sorted(new FieldOrderComparator.FieldComparator(this.buildHelper.getMapAPI())).map(e -> this.mdFieldFactory.createLoadFieldOnWrk(locationConnectionId, this.fieldSequence, (ILogicalField)e));
        List<MdModel.MdField> res = Stream.concat(streamSrc, streamWrk).collect(Collectors.toList());
        res.forEach(f -> {
            boolean bl = mdStep.fields.add((MdModel.MdField)f);
        });
        loadData.joins.stream().map(join -> MdClauseFactory.createJoin(this.clauseIdGenerator, join, null)).forEach(j -> {
            boolean bl = mdStep.joins.add((MdModel.MdJoin)j);
        });
        loadData.filters.stream().map(f -> MdClauseFactory.createFilter(this.clauseIdGenerator, f, null)).forEach(f -> {
            boolean bl = mdStep.filters.add((MdModel.MdFilter)f);
        });
        return res;
    }

    private void addStagingAssets(Template tpl) {
        MdModel.MdStep step = this.steps.get(tpl);
        step.stageSetDescriptorExpression = ((Query)this.buildHelper.getMapAPI().getTargetRef(tpl).get(0)).getSubExpression();
    }

    private void addIntegrationAssets(Template tpl) {
        Datastore ds;
        MdModel.MdStep step = this.steps.get(tpl);
        IContainer trgContainer = (IContainer)this.buildHelper.getMapAPI().getTargetRef(tpl).get(0);
        if (trgContainer instanceof Datastore && (ds = (Datastore)trgContainer).eIsSet((EStructuralFeature)MapPackage.eINSTANCE.getDatastore_UpdateKeyRef())) {
            step.setIntegrationUpdateKeyRef(this.delegate(() -> ((Datastore)ds).getUpdateKeyRef()));
        }
    }

    private void addIntegrationAsset(Template tpl) {
        MdModel.MdStep step = this.steps.get(tpl);
        step.integrationSteps = this.buildHelper.getMapAPI().getTargetRef(tpl).stream().map(t -> this.mapModel.getIntegrationTemplate(t)).filter(t -> t != null).map(t -> this.steps.get(t)).collect(Collectors.toList());
    }

    private void addSerdeAsset(Template tpl) {
        IContainer iContainer;
        MdModel.MdStep step = this.steps.get(tpl);
        IContainer iContainer2 = (IContainer)this.buildHelper.getMapAPI().getTargetRef(tpl).get(0);
        if (iContainer2 instanceof Outliner) {
            Outliner outliner = (Outliner)iContainer2;
            step.setSerdeOutputField(this.delegate(() -> ((Outliner)outliner).getOutputFieldsReference()));
        }
        if ((iContainer = (IContainer)this.buildHelper.getMapAPI().getTargetRef(tpl).get(0)) instanceof Inliner) {
            Inliner inliner = (Inliner)iContainer;
            step.setSerdeInputField(this.delegate(() -> ((Inliner)inliner).getInputFieldsReference()));
        }
    }

    private void createStep(Template tpl) {
        EObject targetMd;
        MdModel.MdStep step = new MdModel.MdStep();
        int number = -1;
        IContainer tplTrgContainer = (IContainer)this.buildHelper.getMapAPI().getTargetRef(tpl).get(0);
        RTemplate.Type tplType = ((RTemplate)tpl.getMapReference()).getTemplateType();
        switch (tplType) {
            case INTEGRATION: {
                number = this.integrationSequence.getNext();
                break;
            }
            case LOAD: {
                number = this.loadSequence.getNext();
                break;
            }
            case SERDE: {
                number = this.serdeSequence.getNext();
                break;
            }
            case STAGING: {
                number = this.stageSequence.getNext();
                break;
            }
            case REJECT: {
                number = this.rejectSequence.getNext();
                break;
            }
            default: {
                throw new MappingBuildException(String.format("Unsupported template type %s", tplType.name()));
            }
        }
        if (tplType == RTemplate.Type.LOAD && tplTrgContainer.hasStagingArea()) {
            targetMd = tplTrgContainer.getStagingArea();
        } else {
            EObject n = (EObject)this.stageObjectTypeMdNode.get((IMetaData)tplTrgContainer);
            if (n == null) {
                n = ((IMetaData)tplTrgContainer).basicGetRef();
            }
            targetMd = n;
        }
        step.name = Utils.truncation(String.format("%s%s_%s", tplType.getProcessStepNamePrefix(), number == 0 ? "" : Integer.toString(number), tpl.getName().replaceFirst("[A-Z][0-9]*_", "")));
        step.number = number;
        step.templateType = tplType;
        step.setTargetMd(this.delegate(() -> targetMd));
        this.steps.put(tpl, step);
        this.stepsByTpl.put(step, tpl);
        this.stepsByName.put(step.name, step);
    }

    Collection<MdModel.MdStep> getSteps() {
        return this.steps.values();
    }

    public static String replaceReservedWords(String baseName, EObject targetMd) {
        if (targetMd instanceof MdNode) {
            MdNode mdNode = (MdNode)targetMd;
            try {
                Collection c;
                HashSet<String> set;
                Object o = mdNode.evaluateXpathExpressionMdSetCached("INTERNAL_RESERVED_WORDS");
                if (o instanceof Collection && !(set = new HashSet<String>(c = (Collection)o)).add(baseName)) {
                    return String.format("A_%s", baseName);
                }
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return baseName;
    }

    private class LegacyStepComparator
    implements Comparator<Map.Entry<Template, MdModel.MdStep>> {
        List<Map.Entry<Template, MdModel.MdStep>> legacySorted;

        public LegacyStepComparator() {
            List<Template> graphSortedTpl = MdModelBuilder.this.templateSorter.getSortedTemplates();
            this.legacySorted = MdModelBuilder.this.steps.entrySet().stream().sorted((e1, e2) -> Integer.compare(graphSortedTpl.indexOf(e1.getKey()), graphSortedTpl.indexOf(e2.getKey()))).collect(Collectors.toList());
        }

        @Override
        public int compare(Map.Entry<Template, MdModel.MdStep> e1, Map.Entry<Template, MdModel.MdStep> e2) {
            RTemplate.Type t1 = MdModelBuilder.this.buildHelper.getMapAPI().getTemplateType(e1.getKey());
            RTemplate.Type t2 = MdModelBuilder.this.buildHelper.getMapAPI().getTemplateType(e2.getKey());
            if (t1 == RTemplate.Type.SERDE) {
                if (t2 != RTemplate.Type.SERDE) {
                    return -1;
                }
            } else if (t2 == RTemplate.Type.SERDE) {
                return 1;
            }
            return Integer.compare(this.legacySorted.indexOf(e1), this.legacySorted.indexOf(e2));
        }
    }

    class MdSourceTracker {
        Map<MdModel.MdStep, Map<IContainer, Collection<MdModel.MdSource>>> sourcesMap = new HashMap<MdModel.MdStep, Map<IContainer, Collection<MdModel.MdSource>>>();

        MdSourceTracker() {
        }

        void track(MdModel.MdStep owner, MdModel.MdSource src, IContainer container) {
            this.sourcesMap.computeIfAbsent(owner, k -> new HashMap()).computeIfAbsent(container, k -> new HashSet()).add(src);
        }

        MdModel.MdSource find(MdModel.MdStep owner, IContainer container, String sourceSetName) {
            Optional<MdModel.MdSource> opt = ((Collection)this.sourcesMap.get(owner).getOrDefault(container, Collections.emptySet())).stream().filter(src -> Objects.equals(src.sourceSetName, sourceSetName)).findAny();
            if (opt.isPresent()) {
                return opt.get();
            }
            return null;
        }
    }
}

