/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal.debug;

import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.generation.mapping.internal.debug.DebugMdModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

class MdModelSerializer {
    BufferedWriter writer;

    MdModelSerializer() {
    }

    static void serializeModel(DebugMdModel model, File outputFile) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile, StandardCharsets.UTF_8));){
            MdModelSerializer serializer = new MdModelSerializer();
            serializer.writer = writer;
            serializer.serialize(model);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<Field> getFields(Class c) {
        return Arrays.asList(c.getDeclaredFields()).stream().filter(f -> !Collection.class.isAssignableFrom(f.getType()) || ((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0] == String.class || ((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0] == DebugMdModel.PlaceHolder.class).filter(f -> !f.isAnnotationPresent(Ignored.class)).sorted((f1, f2) -> f1.getName().compareTo(f2.getName())).collect(Collectors.toList());
    }

    private void serialize(DebugMdModel model) throws Exception {
        for (DebugMdModel.Step s3 : model.steps.stream().sorted((s1, s2) -> s1.name.compareTo(s2.name)).collect(Collectors.toList())) {
            this.writer.write("-Step:" + s3.name);
            this.writer.newLine();
            this.serializeSimpleProperties(s3, this.getFields(DebugMdModel.Step.class), 2);
            for (DebugMdModel.Source src : s3.source.stream().sorted((s1, s2) -> s1.name.compareTo(s2.name)).collect(Collectors.toList())) {
                this.writeOffset(2);
                this.writer.write("-Source:" + src.name);
                this.writer.newLine();
                this.serializeSimpleProperties(src, this.getFields(DebugMdModel.Source.class), 4);
            }
            for (Object f : s3.field.stream().sorted((s1, s2) -> s1.name.compareTo(s2.name)).collect(Collectors.toList())) {
                this.writeOffset(2);
                this.writer.write("-Field:" + ((DebugMdModel.Field)f).name);
                this.writer.newLine();
                this.serializeSimpleProperties(f, this.getFields(DebugMdModel.Field.class), 4);
                for (DebugMdModel.ExtraStatic e : ((DebugMdModel.Field)f).extraStaticRelation) {
                    this.writeOffset(4);
                    this.writer.write("-ExtraStaticRelation:");
                    this.writer.newLine();
                    this.serializeSimpleProperties(e, this.getFields(DebugMdModel.ExtraStatic.class), 6);
                }
            }
            for (DebugMdModel.Join join : s3.join.stream().filter(j -> j.expression.readValue != null).sorted(new JoinComparator()).collect(Collectors.toList())) {
                this.writeOffset(2);
                this.writer.write("-Join:");
                this.writer.newLine();
                this.serializeSimpleProperties(join, this.getFields(DebugMdModel.Join.class), 4);
            }
            for (Object f : s3.filter.stream().filter(j -> j.expression.readValue != null).sorted((s1, s2) -> s1.expression.replacedValue.compareTo(s2.expression.replacedValue)).collect(Collectors.toList())) {
                this.writeOffset(2);
                this.writer.write("-Filter:");
                this.writer.newLine();
                this.serializeSimpleProperties(f, this.getFields(DebugMdModel.Filter.class), 4);
            }
            for (DebugMdModel.Constraint cns : s3.constraint.stream().sorted((s1, s2) -> s1.name == null ? 1 : s1.name.compareTo(s2.name)).collect(Collectors.toList())) {
                this.writeOffset(2);
                this.writer.write("-Constraint:");
                this.writer.newLine();
                this.serializeSimpleProperties(cns, this.getFields(DebugMdModel.Constraint.class), 4);
            }
        }
        for (String l2 : model.mdLinks.stream().map(l -> CacheHelper.extractEltID((String)l.referenceURI)).filter(s -> s != null).sorted(Comparable::compareTo).collect(Collectors.toList())) {
            this.writer.write("-MdLink: ");
            this.writer.write(l2);
            this.writer.newLine();
        }
    }

    private void writeOffset(int offset) throws IOException {
        int i = 0;
        while (i < offset) {
            this.writer.write(" ");
            ++i;
        }
    }

    private void serializeSimpleProperties(Object bean, List<Field> fields, int offset) throws Exception {
        for (Field f : fields) {
            Object res = f.get(bean);
            if (res == null && (!(res instanceof DebugMdModel.PlaceHolder) || ((DebugMdModel.PlaceHolder)res).isNull())) continue;
            this.writeOffset(offset);
            this.writer.write(f.getName() + ":");
            if (Collection.class.isAssignableFrom(f.getType())) {
                String w = ((Collection)res).stream().map(o -> o.toString()).sorted().collect(Collectors.joining(",", "[", "]"));
                this.writer.write(w);
            } else {
                this.writer.write(res.toString());
            }
            this.writer.newLine();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Ignored {
    }

    static class JoinComparator
    implements Comparator<DebugMdModel.Join> {
        JoinComparator() {
        }

        @Override
        public int compare(DebugMdModel.Join s1, DebugMdModel.Join s2) {
            int i;
            if (s1.order != null && (i = s1.order.compareTo(s2.order)) != 0) {
                return i;
            }
            return s1.expression.readValue.compareTo(s2.expression.readValue);
        }
    }
}

