/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.md;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EnvironmentVariableHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.generation.md.MdXMLReorderer;
import com.semarchy.xdi.designer.generation.md.Messages;
import com.stambia.md.MdPackage;
import com.stambia.md.Version;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import com.stambia.tech.Tech;
import com.stambia.tech.TechPackage;
import com.stambia.tech.Value;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class MdReader {
    private final Logger logger = LogManager.getLogger(MdReader.class);
    boolean allRead = false;
    LinkedList<URI> uriStack;
    Tech tech;
    Stack<ReaderWrapper> readerStack = new Stack();
    ReaderWrapper currentReader = null;
    XMLInputFactory factory;
    Queue<Event> events = new LinkedList<Event>();
    URI baseURI;
    ResourceSet techResourceSet;
    Stack<String> nodeIdStack = new Stack();
    Collection<URI> invalidXMLURI;
    Set<String> fileIdFromStak = new HashSet<String>();
    private XDIModelURIResolver resolver;
    private Stack<Version> versionStack = new Stack();
    static final QName Q_VALUE = new QName("value");
    static final QName Q_KEY = new QName("key");
    static final QName Q_MD_INTERNAL_VERSION = new QName(MdPackage.eINSTANCE.getMdRootNode_InternalVersion().getName());
    static final QName Q_MD_SUBMD = new QName("subMd");
    private Set<String> writtenNodeIds = new HashSet<String>();
    private Set<String> confNames4CurrentNodeId = new HashSet<String>();

    public MdReader(XDIModelURIResolver resolver, Tech tech, LinkedList<URI> mdURIStack, URI baseURI, ResourceSet techResourceSet, Collection<URI> invalidXMLURI) {
        this.factory = XMLInputFactory.newInstance();
        this.factory.setProperty("javax.xml.stream.supportDTD", false);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        if (tech == null) {
            throw new RuntimeException(String.format(Messages.MdReader_0, baseURI));
        }
        this.resolver = resolver;
        this.tech = tech;
        this.uriStack = mdURIStack;
        this.baseURI = baseURI;
        this.techResourceSet = techResourceSet;
        this.invalidXMLURI = invalidXMLURI;
        for (URI u : mdURIStack) {
            String id = CacheHelper.extractFileID((String)u.fragment());
            if (id == null) continue;
            this.fileIdFromStak.add(id);
        }
    }

    private ReaderWrapper createNextReader() throws Exception {
        URI uri = this.uriStack.pop();
        while (!uri.isEmpty() && !"md".equals(uri.fileExtension())) {
            uri = this.uriStack.pop();
        }
        InputStream fis = null;
        File f = this.resolver.resolve(uri);
        if (this.invalidXMLURI.contains(uri)) {
            try {
                fis = this.reorderMdModel(f);
            }
            catch (Exception ex) {
                throw new Exception(String.format(Messages.MdReader_1, uri), ex);
            }
        } else {
            fis = new FileInputStream(f);
        }
        if (!(fis instanceof BufferedInputStream)) {
            fis = new BufferedInputStream(fis);
        }
        XMLEventReader reader = this.factory.createXMLEventReader(fis);
        return this.readerStack.push(new ReaderWrapper(reader, fis, uri));
    }

    private InputStream reorderMdModel(File f) throws Exception {
        InputStream fis = null;
        try {
            ByteArrayInputStream byteArrayInputStream;
            block18: {
                fis = new BufferedInputStream(new FileInputStream(f));
                XMLEventReader reader = this.factory.createXMLEventReader(fis);
                LinkedList<XMLEvent> stack = new LinkedList<XMLEvent>();
                ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
                HashMap<XMLEvent, List<XMLEvent>> mdNodesContent = new HashMap<XMLEvent, List<XMLEvent>>();
                try {
                    while (reader.hasNext()) {
                        XMLEvent event = reader.nextEvent();
                        events.add(event);
                        if (event.isStartElement()) {
                            if (!stack.isEmpty()) {
                                ((List)mdNodesContent.get(stack.peek())).add(event);
                            }
                            stack.push(event);
                            mdNodesContent.put(event, new ArrayList());
                            continue;
                        }
                        if (event.isEndElement()) {
                            stack.pop();
                            if (stack.isEmpty()) continue;
                            ((List)mdNodesContent.get(stack.peek())).add(event);
                            continue;
                        }
                        if (stack.isEmpty()) continue;
                        ((List)mdNodesContent.get(stack.peek())).add(event);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (fis != null) {
                        fis.close();
                        fis = null;
                    }
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                XMLEventWriter writer = null;
                try {
                    writer = XMLOutputFactory.newFactory().createXMLEventWriter(bos, "UTF-8");
                    MdXMLReorderer reorder = new MdXMLReorderer(events, mdNodesContent, writer);
                    reorder.write();
                    byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
                    if (writer == null) break block18;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        writer.close();
                    }
                    throw throwable;
                }
                writer.close();
            }
            return byteArrayInputStream;
        }
        finally {
            if (fis != null) {
                fis.close();
                fis = null;
            }
        }
    }

    public boolean hasNext() throws Exception {
        if (this.events.isEmpty()) {
            if (this.allRead) {
                return false;
            }
            if (this.currentReader != null) {
                return true;
            }
            return !this.uriStack.isEmpty();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public Event getNextEvent() throws Exception {
        block14: {
            if (!this.events.isEmpty()) {
                return this.events.poll();
            }
            if (this.allRead) {
                throw new Exception(Messages.MdReader_2);
            }
            if (this.currentReader == null) {
                this.currentReader = this.createNextReader();
            }
            try {
                do {
                    event = this.currentReader.reader.nextEvent();
                    switch (event.getEventType()) {
                        case 8: {
                            this.handleEndDocument();
                            break;
                        }
                        case 2: {
                            this.handleEndElement(event.asEndElement());
                            break;
                        }
                        case 7: {
                            this.handleStartDocument();
                            break;
                        }
                        case 1: {
                            this.handleStartElement(event.asStartElement());
                        }
                    }
                } while (this.events.isEmpty() && !this.allRead);
                break block14;
            }
            catch (Exception ex) {
                w = this.currentReader;
                ** while (!this.readerStack.isEmpty())
            }
lbl-1000:
            // 1 sources

            {
                this.currentReader = this.readerStack.pop();
                this.currentReader.reader.close();
                this.currentReader.inputStream.close();
                continue;
            }
lbl31:
            // 1 sources

            if (w != null) {
                throw new Exception(String.format(Messages.MdReader_3, new Object[]{w.uri}), ex);
            }
            throw ex;
        }
        return this.events.poll();
    }

    private void handleStartDocument() throws Exception {
    }

    private void handleEndDocument() throws Exception {
        ReaderWrapper w = this.readerStack.pop();
        w.reader.close();
        w.inputStream.close();
        this.currentReader = !this.readerStack.isEmpty() ? this.readerStack.peek() : null;
        if (!this.hasNext()) {
            this.events.add(new EndEvent());
            this.allRead = true;
        }
    }

    private void handleStartElement(StartElement event) throws Exception {
        String localPart = event.getName().getLocalPart();
        if ("node".equals(localPart)) {
            boolean opened = this.openNode(event);
            if (!opened) {
                ArrayDeque<XMLEvent> ignored = new ArrayDeque<XMLEvent>();
                ignored.push(event);
                while (this.currentReader.reader.hasNext() && !ignored.isEmpty()) {
                    XMLEvent e = this.currentReader.reader.nextEvent();
                    if (e.isStartElement()) {
                        ignored.push(e);
                    } else if (e.isEndElement()) {
                        ignored.pop();
                    }
                    if (!e.isEndDocument()) continue;
                    this.handleEndDocument();
                }
            }
        } else if ("attribute".equals(localPart)) {
            this.createAttribute(event);
        } else if ("configuration".equals(localPart)) {
            this.openConf(event);
        } else if ("metaDataLink".equals(localPart)) {
            this.createMdLink(event);
        } else if ("externalize".equals(localPart)) {
            this.createExternalize(event);
        }
    }

    private void createExternalize(StartElement event) {
        String defType = null;
        boolean enabled = false;
        Iterator<Attribute> it = event.getAttributes();
        while (it.hasNext()) {
            Attribute att = it.next();
            if (att.getName().getLocalPart().equals("defType")) {
                defType = att.getValue();
                continue;
            }
            if (!att.getName().getLocalPart().equals("enable")) continue;
            enabled = Boolean.valueOf(att.getValue());
        }
        if (defType != null) {
            ExternalizeEvent ev = new ExternalizeEvent();
            ev.defType = defType;
            ev.enabled = enabled;
            this.events.add(ev);
        }
    }

    private void createMdLink(StartElement event) {
        MdLinkEvent ev = new MdLinkEvent();
        Iterator<Attribute> it = event.getAttributes();
        while (it.hasNext()) {
            Attribute att = it.next();
            if (att.getName().getLocalPart().equals("name")) {
                ev.name = att.getValue();
                continue;
            }
            if (!att.getName().getLocalPart().equals("target")) continue;
            ev.target = att.getValue();
        }
        if (ev.target != null) {
            ev.target = this.formatReference(ev.target);
        }
        this.events.add(ev);
    }

    private void openConf(StartElement event) throws Exception {
        ConfEvent ev = new ConfEvent();
        Iterator<Attribute> it = event.getAttributes();
        while (it.hasNext()) {
            Attribute att = it.next();
            if (!"name".equals(att.getName().getLocalPart())) continue;
            ev.confName = att.getValue();
        }
        if (ev.confName == null) {
            ArrayDeque<StartElement> stack = new ArrayDeque<StartElement>();
            stack.push(event);
            while (!stack.isEmpty()) {
                if (!this.currentReader.reader.hasNext()) {
                    throw new Exception(Messages.MdReader_4);
                }
                XMLEvent e = this.currentReader.reader.nextEvent();
                if (e.getEventType() == 1) {
                    stack.push(e.asStartElement());
                    continue;
                }
                if (e.getEventType() != 2) continue;
                stack.pop();
            }
        } else {
            this.events.add(ev);
            if (!this.confNames4CurrentNodeId.add(ev.confName)) {
                throw new Exception(String.format(Messages.MdReader_5, ev.confName, this.nodeIdStack.peek(), this.baseURI.toPlatformString(true)));
            }
        }
    }

    private void handleEndElement(EndElement event) throws Exception {
        if ("node".equals(event.getName().getLocalPart())) {
            this.closeNode(event);
        } else if ("configuration".equals(event.getName().getLocalPart())) {
            this.closeConf(event);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void closeNode(EndElement event) throws Exception {
        block4: {
            block3: {
                if (event.getName().getPrefix().equals("md")) {
                    this.versionStack.pop();
                }
                --this.currentReader.currentReaderDepth;
                if (this.currentReader.currentReaderDepth != 0) break block3;
                if (this.currentReader.isSubMd) {
                    this.currentReader = null;
                    this.events.add(new EndNode(this.nodeIdStack.pop()));
                    w = this.readerStack.pop();
                    w.reader.close();
                    w.inputStream.close();
                }
                if (this.uriStack.isEmpty()) ** GOTO lbl21
                this.currentReader = this.createNextReader();
                break block4;
lbl-1000:
                // 1 sources

                {
                    this.currentReader = this.readerStack.pop();
                    this.currentReader.reader.close();
                    this.currentReader.inputStream.close();
                    this.events.add(new EndNode(this.nodeIdStack.pop()));
lbl21:
                    // 2 sources

                    ** while (!this.readerStack.isEmpty())
                }
lbl22:
                // 1 sources

                this.allRead = true;
                break block4;
            }
            this.events.add(new EndNode(this.nodeIdStack.pop()));
        }
    }

    private void closeConf(EndElement event) {
        this.events.add(new EndConf());
    }

    private Level findLevel(String defType) {
        ArrayList<Level> lvls = new ArrayList<Level>();
        for (Level l : this.tech.getLevel()) {
            if (!defType.startsWith(l.getCode())) continue;
            lvls.add(l);
        }
        Collections.sort(lvls, (o1, o2) -> Integer.compare(o1.getCode().length(), o2.getCode().length()));
        if (lvls.isEmpty()) {
            return null;
        }
        return (Level)lvls.get(lvls.size() - 1);
    }

    private String formatReference(String ref) {
        URI refResourceURI;
        String fragment;
        String fileID;
        if (ref != null && ((String)ref).contains("#") && (fileID = CacheHelper.extractFileID((String)(fragment = ((String)ref).substring(((String)ref).indexOf("#") + 1)))) != null && (refResourceURI = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(fileID)) != null) {
            if ("tech".equals(refResourceURI.fileExtension()) || "tech_ext".equals(refResourceURI.fileExtension())) {
                try {
                    EObject o = this.techResourceSet.getEObject(refResourceURI.appendFragment(fragment), true);
                    if (o instanceof Value) {
                        return ((Value)o).getValue();
                    }
                    return null;
                }
                catch (Exception ex) {
                    this.logger.error("Failed to load {}", (Object)refResourceURI, (Object)ex);
                }
            } else {
                if (this.fileIdFromStak.contains(fileID)) {
                    String id = CacheHelper.extractEltID((String)fragment);
                    return "#" + id;
                }
                refResourceURI = refResourceURI.appendFragment(fragment);
                IPath path = null;
                if (refResourceURI.isPlatformPlugin()) {
                    StringBuilder buf = new StringBuilder();
                    int i = 1;
                    while (i < refResourceURI.segmentCount()) {
                        buf.append("/");
                        buf.append(URI.decode((String)refResourceURI.segment(i)));
                        ++i;
                    }
                    path = new Path(buf.toString());
                } else {
                    path = URIUtils.toPath((URI)refResourceURI.trimFragment());
                }
                IPath curPath = URIUtils.toPath((URI)this.baseURI.trimFragment());
                if (curPath == null && this.baseURI.isPlatformPlugin()) {
                    StringBuilder buf = new StringBuilder();
                    int i = 1;
                    while (i < this.baseURI.trimFragment().segmentCount()) {
                        buf.append("/");
                        buf.append(URI.decode((String)this.baseURI.segment(i)));
                        ++i;
                    }
                    Path basePath = new Path(buf.toString());
                    IPath relPath = path.makeRelativeTo((IPath)basePath);
                    ref = relPath.toString() + "#" + CacheHelper.extractEltID((String)fragment);
                } else if (curPath != null) {
                    IPath curpath = curPath.removeLastSegments(1);
                    IPath relPath = path.makeRelativeTo(curpath);
                    ref = relPath.toString() + "#" + CacheHelper.extractEltID((String)fragment);
                }
                return ref;
            }
        }
        return ref;
    }

    private void createAttribute(StartElement event) throws Exception {
        XMLEvent curXMLEv = event;
        String value = null;
        String defType = null;
        String id = null;
        String xmlName = null;
        ArrayList<String> vals = null;
        HashMap<String, String> map = null;
        Iterator<Attribute> it = event.getAttributes();
        while (it.hasNext()) {
            Attribute att = it.next();
            if ("defType".equals(att.getName().getLocalPart())) {
                defType = att.getValue();
                continue;
            }
            if ("id".equals(att.getName().getLocalPart())) {
                id = att.getValue();
                continue;
            }
            if ("value".equals(att.getName().getLocalPart())) {
                value = this.replaceEnvironmentVariables(att.getValue());
                continue;
            }
            if (!"ref".equals(att.getName().getLocalPart())) continue;
            value = att.getValue();
        }
        boolean skip = false;
        if (defType == null) {
            skip = true;
        } else {
            Level lv = this.findLevel(defType);
            Property prop = null;
            if (lv == null) {
                skip = true;
            } else {
                prop = lv.getAttributeByCode(defType);
                if (prop == null) {
                    skip = true;
                } else {
                    if (prop.getType() == PropertyType.REFERENCE) {
                        value = this.formatReference(value);
                    }
                    xmlName = prop.getXmlName();
                    if (!prop.isUnbounded()) {
                        xmlEvent = this.currentReader.reader.nextEvent();
                        while (!(xmlEvent.isEndDocument() || xmlEvent.isEndElement() && xmlEvent.asEndElement().getName().getLocalPart().equals("attribute"))) {
                            xmlEvent = this.currentReader.reader.nextEvent();
                        }
                        curXMLEv = xmlEvent;
                    } else {
                        map = prop.isKeyValue() ? new HashMap<String, String>() : null;
                        vals = !prop.isKeyValue() ? new ArrayList<String>() : null;
                        xmlEvent = this.currentReader.reader.nextEvent();
                        while (!(xmlEvent.isEndDocument() || xmlEvent.isEndElement() && xmlEvent.asEndElement().getName().getLocalPart().equals("attribute"))) {
                            if (xmlEvent.isStartElement()) {
                                StartElement s = xmlEvent.asStartElement();
                                if (vals != null && s.getName().getLocalPart().equals("values") && !prop.isKeyValue()) {
                                    StringBuilder buf = new StringBuilder();
                                    while (!(xmlEvent.isEndDocument() || xmlEvent.isEndElement() && (xmlEvent.asEndElement().getName().getLocalPart().equals("values") || xmlEvent.asEndElement().getName().getLocalPart().equals("refs") || xmlEvent.asEndElement().getName().getLocalPart().equals("attribute")))) {
                                        xmlEvent = this.currentReader.reader.nextEvent();
                                        if (!xmlEvent.isCharacters()) continue;
                                        buf.append(xmlEvent.asCharacters().getData());
                                    }
                                    if (buf.length() > 0) {
                                        if (prop.getType() == PropertyType.REFERENCE) {
                                            vals.add(this.formatReference(buf.toString()));
                                        } else {
                                            vals.add(this.replaceEnvironmentVariables(buf.toString()));
                                        }
                                    }
                                } else if (map != null && s.getName().getLocalPart().equals("valueEntry") && prop.isKeyValue()) {
                                    String v = null;
                                    String k = null;
                                    Attribute a = s.getAttributeByName(Q_VALUE);
                                    if (a != null) {
                                        v = a.getValue();
                                        v = prop.getType() == PropertyType.REFERENCE ? this.formatReference(v) : this.replaceEnvironmentVariables(v);
                                    }
                                    if ((a = s.getAttributeByName(Q_KEY)) != null) {
                                        k = a.getValue();
                                    }
                                    if (k != null) {
                                        map.put(k, v);
                                    }
                                } else if (vals != null && s.getName().getLocalPart().equals("refs")) {
                                    xmlEvent = this.currentReader.reader.nextEvent();
                                    StringBuilder b = new StringBuilder();
                                    while (xmlEvent.isCharacters()) {
                                        b.append(xmlEvent.asCharacters().getData());
                                        xmlEvent = this.currentReader.reader.nextEvent();
                                    }
                                    if (b.length() > 0) {
                                        vals.add(this.formatReference(b.toString()));
                                    }
                                }
                            }
                            xmlEvent = this.currentReader.reader.nextEvent();
                        }
                        curXMLEv = xmlEvent;
                    }
                }
            }
        }
        if (!skip) {
            AttributeEvent ev = AttributeEvent.of(defType, xmlName, value, vals, map, this.versionStack.peek(), id);
            if (ev.value != null || ev.values != null && !ev.values.isEmpty() || ev.map != null && !ev.map.isEmpty()) {
                this.events.add(ev);
            }
        }
        while (!(curXMLEv.isEndDocument() || curXMLEv.isEndElement() && curXMLEv.asEndElement().getName().getLocalPart().equals("attribute"))) {
            curXMLEv = this.currentReader.reader.nextEvent();
        }
        if (curXMLEv.isEndDocument()) {
            this.handleEndDocument();
        }
    }

    private String replaceEnvironmentVariables(String value) throws Exception {
        if (value.contains("%{env:")) {
            try {
                return EnvironmentVariableHelper.resolveEnvironmentVariables((String)value, (EnvironmentVariableHelper.Mode)EnvironmentVariableHelper.Mode.MdModel);
            }
            catch (Exception ex) {
                throw new Exception(String.format(Messages.MdReader_6, value, this.currentReader.uri, ex.getMessage()), ex);
            }
        }
        return value;
    }

    private boolean openNode(StartElement event) {
        boolean subMdProvided = false;
        boolean __subMdExtracted = false;
        if (event.getName().getPrefix().equals("md")) {
            Version currentMdVersion = Version.UNSPECIFIED;
            Attribute att = event.getAttributeByName(Q_MD_INTERNAL_VERSION);
            if (att != null) {
                currentMdVersion = Version.get((String)att.getValue());
            }
            if (currentMdVersion != Version.UNSPECIFIED) {
                subMdProvided = true;
                att = event.getAttributeByName(Q_MD_SUBMD);
                __subMdExtracted = att != null && "true".equals(att.getValue());
            }
            this.versionStack.push(currentMdVersion);
        }
        NodeEvent ev = new NodeEvent();
        ev.modelURI = this.currentReader.uri;
        Iterator<Attribute> it = event.getAttributes();
        while (it.hasNext()) {
            Attribute att = it.next();
            if ("defType".equals(att.getName().getLocalPart())) {
                ev.defType = att.getValue();
                continue;
            }
            if ("id".equals(att.getName().getLocalPart())) {
                ev.id = att.getValue();
                continue;
            }
            if ("name".equals(att.getName().getLocalPart())) {
                ev.name = att.getValue();
                continue;
            }
            if ("position".equals(att.getName().getLocalPart())) {
                ev.position = att.getValue();
                continue;
            }
            if (!"ref".equals(att.getName().getLocalPart())) continue;
            ev.ref = this.formatReference(att.getValue());
        }
        if (ev.defType == null) {
            return false;
        }
        Level lvl = this.tech.getLevel(ev.defType);
        if (lvl == null) {
            return false;
        }
        ev.lvl = lvl;
        if (lvl.eIsSet((EStructuralFeature)TechPackage.eINSTANCE.getLevel_ConnectionClass()) && lvl.getConnectionClass() != null && !lvl.getConnectionClass().isEmpty()) {
            ev.isConnection = true;
        }
        if (this.currentReader.rootLevel == null) {
            String s;
            String eltID;
            this.currentReader.rootLevel = lvl;
            if (this.readerStack.size() > 1 && ev.ref != null && lvl.isSubMetaDataFileCapability() && (subMdProvided && __subMdExtracted || !subMdProvided && !lvl.isIsFile()) && !this.writtenNodeIds.add(eltID = CacheHelper.extractEltID((String)(s = ev.ref.substring(ev.ref.indexOf("#") + 1))))) {
                ev.isSubMd = true;
                this.currentReader.isSubMd = true;
            }
        }
        ++this.currentReader.currentReaderDepth;
        this.events.add(ev);
        this.nodeIdStack.push(ev.id);
        this.writtenNodeIds.add(ev.id);
        this.confNames4CurrentNodeId.clear();
        return true;
    }

    static class AttributeEvent
    extends Event {
        String id;
        String defType;
        String xmlName;
        String value;
        List<String> values;
        Map<String, String> map;
        Version mdModelVersion;

        AttributeEvent() {
        }

        static AttributeEvent of(String defType, String xmlName, String value, List<String> values, Map<String, String> map, Version mdModelVersion, String id) {
            AttributeEvent ev = new AttributeEvent();
            ev.defType = defType;
            ev.xmlName = xmlName;
            ev.value = value;
            ev.values = values;
            ev.map = map;
            ev.mdModelVersion = mdModelVersion;
            if (id == null || id.isEmpty()) {
                id = UUID.randomUUID().toString();
            }
            ev.id = id;
            return ev;
        }

        public boolean discardEmptyValue() {
            if (this.value != null && this.value.isEmpty() && this.mdModelVersion != null) {
                return this.mdModelVersion.ordinal() < Version.V200.ordinal();
            }
            return false;
        }
    }

    class ConfEvent
    extends Event {
        String confName;

        ConfEvent() {
        }
    }

    class EndConf
    extends Event {
        EndConf() {
        }
    }

    class EndEvent
    extends Event {
        EndEvent() {
        }
    }

    class EndNode
    extends Event {
        String id;

        public EndNode(String id) {
            this.id = id;
        }
    }

    static class Event {
        Event() {
        }
    }

    class ExternalizeEvent
    extends Event {
        String defType;
        boolean enabled;

        ExternalizeEvent() {
        }
    }

    class MdLinkEvent
    extends Event {
        String target;
        public String name;

        MdLinkEvent() {
        }
    }

    class NodeEvent
    extends Event {
        String defType;
        String xmlName;
        String name;
        String id;
        String position;
        String ref;
        Level lvl;
        boolean isSubMd;
        boolean isConnection;
        public URI modelURI;

        NodeEvent() {
        }
    }

    class ReaderWrapper {
        URI uri;
        XMLEventReader reader;
        InputStream inputStream;
        int currentReaderDepth = 0;
        Level rootLevel;
        boolean isSubMd = false;

        ReaderWrapper(XMLEventReader reader, InputStream stream, URI uri) {
            this.reader = reader;
            this.inputStream = stream;
            this.uri = uri;
        }
    }
}

