/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.md;

import com.indy.gmf.proc.custom.ActionDefinitionHelper;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.registry.ProcessToolDescriptor;
import com.semarchy.xdi.designer.generation.md.Md2XmlConverter;
import com.semarchy.xdi.designer.generation.md.MdReader;
import com.stambia.tech.Level;
import com.stambia.tech.MetaDataLinkType;
import com.stambia.tech.Parameter;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import com.stambia.tech.Tech;
import com.stambia.tech.TechPackage;
import com.stambia.tech.XpathExpression;
import com.stambia.tech.XpathParameter;
import com.stambia.tech.XpathVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MdXmlWriter {
    XMLStreamWriter mdtoXmlWriter;
    Set<String> subMdParentId;
    Map<String, Collection<MdReader.AttributeEvent>> subMdParentAttributes = new HashMap<String, Collection<MdReader.AttributeEvent>>();
    String currentSubMdParent = null;
    List<MdReader.AttributeEvent> unboundedAttributes = new ArrayList<MdReader.AttributeEvent>();
    List<MdReader.AttributeEvent> confUnboundedAttributes = new ArrayList<MdReader.AttributeEvent>();
    boolean inConf = false;
    Set<String> writtenAttributeDefType = new HashSet<String>();
    Stack<Level> levelStack = new Stack();
    Stack<WithChildState> withChildStack = new Stack();
    Set<String> inheritedAttributes = new HashSet<String>();
    Level lastPoped = null;
    String curNodeId;
    Md2XmlConverter.AttributeDefaultValueEvaluator defaultEvaluator;

    public Set<String> handle(MdReader.Event event) throws Exception {
        if (!this.inheritedAttributes.isEmpty()) {
            this.inheritedAttributes = new HashSet<String>();
        }
        if (event instanceof MdReader.NodeEvent) {
            return this.handleNode((MdReader.NodeEvent)event);
        }
        if (event instanceof MdReader.MdLinkEvent) {
            return this.handleMdLink((MdReader.MdLinkEvent)event);
        }
        if (event instanceof MdReader.EndEvent) {
            return this.handleEnd((MdReader.EndEvent)event);
        }
        if (event instanceof MdReader.EndNode) {
            return this.handleNode((MdReader.EndNode)event);
        }
        if (event instanceof MdReader.AttributeEvent) {
            return this.handleAttribute((MdReader.AttributeEvent)event);
        }
        if (event instanceof MdReader.ConfEvent) {
            return this.handleConf(event);
        }
        if (event instanceof MdReader.EndConf) {
            return this.handleConf(event);
        }
        return this.inheritedAttributes;
    }

    private Set<String> handleMdLink(MdReader.MdLinkEvent event) throws Exception {
        this.flushUnwritterAttributes();
        this.flushUnboundedAttributes();
        this.mdtoXmlWriter.writeStartElement("metaDataLink");
        this.withChildStack.peek().withChild = true;
        if (event.name != null) {
            this.mdtoXmlWriter.writeAttribute("name", event.name);
        }
        if (event.target != null) {
            String[] p = event.target.split("#");
            if (p.length < 2) {
                this.mdtoXmlWriter.writeAttribute("target", event.target);
            } else {
                StringBuffer b = new StringBuffer();
                int i = 0;
                while (i < p.length) {
                    if (i == p.length - 1) {
                        b.append("#");
                    } else if (i > 0) {
                        b.append("%23");
                    }
                    b.append(p[i]);
                    ++i;
                }
                this.mdtoXmlWriter.writeAttribute("target", b.toString());
            }
        }
        this.mdtoXmlWriter.writeEndElement();
        return this.inheritedAttributes;
    }

    private Set<String> handleConf(MdReader.Event event) throws Exception {
        if (event instanceof MdReader.EndConf) {
            this.flushUnwritterAttributes();
            for (MdReader.AttributeEvent ev : this.confUnboundedAttributes) {
                int count = 0;
                if (ev.map != null) {
                    for (String s : ev.map.keySet()) {
                        this.mdtoXmlWriter.writeStartElement(ev.xmlName);
                        this.mdtoXmlWriter.writeAttribute("id", UUID.randomUUID().toString());
                        this.mdtoXmlWriter.writeAttribute("key", s);
                        this.mdtoXmlWriter.writeAttribute("position", "" + ++count);
                        this.mdtoXmlWriter.writeCharacters(ev.map.get(s));
                        this.mdtoXmlWriter.writeEndElement();
                    }
                } else if (ev.values != null) {
                    for (String s : ev.values) {
                        this.mdtoXmlWriter.writeStartElement(ev.xmlName);
                        this.mdtoXmlWriter.writeAttribute("position", "" + ++count);
                        this.mdtoXmlWriter.writeAttribute("id", UUID.randomUUID().toString());
                        this.mdtoXmlWriter.writeCharacters(s);
                        this.mdtoXmlWriter.writeEndElement();
                    }
                }
                if (count <= 0) continue;
                this.withChildStack.peek().withChild = true;
            }
            this.confUnboundedAttributes.clear();
            this.mdtoXmlWriter.writeEndElement();
            this.inConf = false;
        } else if (event instanceof MdReader.ConfEvent) {
            this.flushUnwritterAttributes();
            this.withChildStack.peek().withChild = true;
            this.inConf = true;
            this.mdtoXmlWriter.writeStartElement(this.levelStack.peek().getXmlName() + "Conf");
            this.mdtoXmlWriter.writeAttribute("name", ((MdReader.ConfEvent)event).confName);
        }
        return this.inheritedAttributes;
    }

    public MdXmlWriter(XMLStreamWriter writer, Map<URI, URI> subMdParent, Md2XmlConverter.AttributeDefaultValueEvaluator defaultEvaluator) throws Exception {
        this.mdtoXmlWriter = writer;
        this.subMdParentId = new HashSet<String>();
        this.defaultEvaluator = defaultEvaluator;
        for (URI u : subMdParent.values()) {
            String s = CacheHelper.extractEltID((String)u.fragment());
            if (s == null) continue;
            this.subMdParentId.add(s);
        }
        this.mdtoXmlWriter.writeStartDocument("UTF-8", "1.0");
        this.mdtoXmlWriter.writeStartElement("md");
        this.mdtoXmlWriter.writeNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.mdtoXmlWriter.writeNamespace("md", "http://www.stambia.com/md");
        this.mdtoXmlWriter.writeNamespace("ex", "http://www.stambia.com/externalize");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> handleAttribute(MdReader.AttributeEvent event) throws XMLStreamException {
        if (this.subMdParentId.contains(this.curNodeId)) {
            Collection<MdReader.AttributeEvent> c = this.subMdParentAttributes.get(this.curNodeId);
            if (c == null) {
                c = new ArrayList<MdReader.AttributeEvent>();
                this.subMdParentAttributes.put(this.curNodeId, c);
            }
            if (!this.inConf) {
                c.add(event);
            }
        }
        if (event.values != null && !event.values.isEmpty() || event.map != null && !event.map.isEmpty()) {
            if (!this.writtenAttributeDefType.add(event.defType)) throw new XMLStreamException(String.format("Multiples attributes with defType=%s  for the node %s", event.defType, this.curNodeId));
            if (this.inConf) {
                this.confUnboundedAttributes.add(event);
                return this.inheritedAttributes;
            } else {
                this.unboundedAttributes.add(event);
            }
            return this.inheritedAttributes;
        } else {
            if (event.value == null || event.discardEmptyValue() || this.levelStack.peek().getAttributeByCode(event.defType) == null) return this.inheritedAttributes;
            if (!this.writtenAttributeDefType.add(event.defType)) throw new XMLStreamException("Multiples attributes with defType=" + event.defType + " for the node " + this.curNodeId);
            this.mdtoXmlWriter.writeAttribute(event.xmlName, event.value);
        }
        return this.inheritedAttributes;
    }

    private void flushUnwritterAttributes() throws XMLStreamException {
        Collection<MdReader.AttributeEvent> c = this.subMdParentAttributes.get(this.currentSubMdParent);
        if (c != null) {
            for (MdReader.AttributeEvent ev : c) {
                Property p = this.levelStack.peek().getAttributeByCode(ev.defType);
                if (p == null || this.writtenAttributeDefType.contains(p.getFullCode())) continue;
                if (ev.value != null && !ev.value.isEmpty()) {
                    this.mdtoXmlWriter.writeAttribute(ev.xmlName, ev.value);
                    this.writtenAttributeDefType.add(p.getFullCode());
                } else {
                    this.unboundedAttributes.add(ev);
                }
                this.inheritedAttributes.add(this.curNodeId + "." + ev.xmlName);
            }
        }
        if (!this.levelStack.isEmpty() && !this.withChildStack.peek().withChild) {
            for (Property p : this.levelStack.peek().getAttribute()) {
                if (this.writtenAttributeDefType.contains(p.getFullCode()) || !p.supportDefaultValue()) continue;
                String value = this.defaultEvaluator.getDefaultValue(this.curNodeId, p);
                if (value == null || value.isEmpty()) {
                    value = p.getDefault();
                }
                if (value == null || value.isEmpty()) continue;
                this.mdtoXmlWriter.writeAttribute(p.getXmlName(), value);
            }
        }
        this.writtenAttributeDefType.clear();
        this.currentSubMdParent = null;
    }

    private void flushUnboundedAttributes() throws XMLStreamException {
        for (MdReader.AttributeEvent ev : this.unboundedAttributes) {
            int count = 0;
            if (ev.map != null) {
                for (String s : ev.map.keySet()) {
                    this.mdtoXmlWriter.writeStartElement(ev.xmlName);
                    this.mdtoXmlWriter.writeAttribute("id", ev.id + "_" + (count + 1));
                    this.mdtoXmlWriter.writeAttribute("key", s);
                    this.mdtoXmlWriter.writeAttribute("position", "" + ++count);
                    this.mdtoXmlWriter.writeCharacters(ev.map.get(s));
                    this.mdtoXmlWriter.writeEndElement();
                }
            } else if (ev.values != null) {
                for (String s : ev.values) {
                    this.mdtoXmlWriter.writeStartElement(ev.xmlName);
                    this.mdtoXmlWriter.writeAttribute("id", ev.id + "_" + (count + 1));
                    this.mdtoXmlWriter.writeAttribute("position", "" + ++count);
                    this.mdtoXmlWriter.writeCharacters(s);
                    this.mdtoXmlWriter.writeEndElement();
                }
            }
            if (count <= 0) continue;
            this.withChildStack.peek().withChild = true;
        }
        this.unboundedAttributes.clear();
    }

    private Set<String> handleNode(MdReader.EndNode event) throws XMLStreamException {
        this.flushUnwritterAttributes();
        this.flushUnboundedAttributes();
        this.withChildStack.pop();
        this.lastPoped = this.levelStack.pop();
        this.mdtoXmlWriter.writeEndElement();
        return this.inheritedAttributes;
    }

    private Set<String> handleEnd(MdReader.EndEvent event) {
        return this.inheritedAttributes;
    }

    private Set<String> handleNode(MdReader.NodeEvent event) throws XMLStreamException {
        this.flushUnwritterAttributes();
        this.flushUnboundedAttributes();
        this.curNodeId = event.id;
        this.levelStack.push(event.lvl);
        if (!this.withChildStack.isEmpty()) {
            this.withChildStack.peek().withChild = true;
        }
        this.withChildStack.push(new WithChildState());
        this.mdtoXmlWriter.writeStartElement(event.lvl.getXmlName());
        if (event.name != null) {
            this.mdtoXmlWriter.writeAttribute("name", event.name);
        }
        if (event.id != null) {
            this.mdtoXmlWriter.writeAttribute("id", event.id);
        }
        this.currentSubMdParent = null;
        this.mdtoXmlWriter.writeAttribute("defType", event.lvl.getCode());
        if (event.position != null) {
            this.mdtoXmlWriter.writeAttribute("position", event.position);
        }
        if (event.isConnection) {
            this.mdtoXmlWriter.writeAttribute("connection", "true");
        }
        if (event.ref != null) {
            URI uri = URI.createURI((String)event.ref);
            if (event.isSubMd) {
                String refID = CacheHelper.extractEltID((String)uri.fragment());
                this.mdtoXmlWriter.writeAttribute("md:refId", refID);
                this.currentSubMdParent = refID;
            }
            this.mdtoXmlWriter.writeAttribute("md:ref", uri.toString());
        }
        return this.inheritedAttributes;
    }

    public void writeTech(Tech tech) throws Exception {
        this.mdtoXmlWriter.writeStartElement("tech", "tech", "http://www.stambia.com/tech");
        this.mdtoXmlWriter.writeNamespace("tech", "http://www.stambia.com/tech");
        HashSet<String> levelCodes = new HashSet<String>();
        for (Level lvl : tech.getLevel()) {
            Object v;
            this.mdtoXmlWriter.writeStartElement("level");
            levelCodes.add(lvl.getCode());
            for (EAttribute a : lvl.eClass().getEAllAttributes()) {
                Object o;
                if (!lvl.eIsSet((EStructuralFeature)a) || a == TechPackage.eINSTANCE.getLevel_MappingType() || a == TechPackage.eINSTANCE.getLevel_Parent() || (o = lvl.eGet((EStructuralFeature)a)) == null || ((String)(v = o.toString())).isEmpty()) continue;
                this.mdtoXmlWriter.writeAttribute(a.getName(), (String)v);
            }
            ArrayList _exprs = new ArrayList(lvl.getXPathExpression());
            Collections.reverse(_exprs);
            HashSet<String> writtenCodes = new HashSet<String>();
            v = _exprs.iterator();
            while (v.hasNext()) {
                XpathExpression expr = (XpathExpression)v.next();
                ArrayList codes = new ArrayList(expr.getCode());
                Collections.reverse(codes);
                Iterator iterator = codes.iterator();
                while (iterator.hasNext()) {
                    QName code = (QName)iterator.next();
                    if (!writtenCodes.add(code.toString())) continue;
                    this.mdtoXmlWriter.writeStartElement("xPathExpression");
                    if (expr.getDescription() != null && !expr.getDescription().trim().isEmpty()) {
                        this.mdtoXmlWriter.writeAttribute("description", expr.getDescription());
                    }
                    if (expr.getExpression() != null && !expr.getExpression().isEmpty()) {
                        this.mdtoXmlWriter.writeAttribute("expression", expr.getExpression());
                    }
                    if (expr.eIsSet((EStructuralFeature)TechPackage.eINSTANCE.getXpathExpression_IsProvider())) {
                        this.mdtoXmlWriter.writeAttribute("isProvider", "" + expr.isIsProvider());
                    }
                    for (XpathParameter p2 : expr.getXPathParameter()) {
                        this.mdtoXmlWriter.writeStartElement("xPathParameter");
                        if (p2.eIsSet((EStructuralFeature)TechPackage.eINSTANCE.getXpathParameter_DefaultValue())) {
                            if (p2.getDefaultValue() != null) {
                                this.mdtoXmlWriter.writeAttribute("defaultValue", p2.getDefaultValue());
                            } else {
                                this.mdtoXmlWriter.writeAttribute("defaultValue", "");
                            }
                        }
                        if (p2.eIsSet((EStructuralFeature)TechPackage.eINSTANCE.getXpathParameter_Name())) {
                            this.mdtoXmlWriter.writeAttribute("name", p2.getName().getLiteral());
                        }
                        if (p2.eIsSet((EStructuralFeature)TechPackage.eINSTANCE.getXpathParameter_Substitution())) {
                            this.mdtoXmlWriter.writeAttribute("substitution", "" + p2.isSubstitution());
                        }
                        this.mdtoXmlWriter.writeEndElement();
                    }
                    for (XpathVariable v2 : expr.getXPathVariable()) {
                        this.mdtoXmlWriter.writeStartElement("xPathVariable");
                        this.mdtoXmlWriter.writeAttribute("expression", v2.getExpression());
                        if (v2.getName() != null && !v2.getName().trim().isEmpty()) {
                            this.mdtoXmlWriter.writeAttribute("name", v2.getName());
                        }
                        this.mdtoXmlWriter.writeEndElement();
                    }
                    this.mdtoXmlWriter.writeStartElement("code");
                    this.mdtoXmlWriter.writeCharacters(code.toString());
                    this.mdtoXmlWriter.writeEndElement();
                    this.mdtoXmlWriter.writeEndElement();
                }
            }
            lvl.getAttribute().stream().filter(p -> p.isSetXdgHarvested() && !p.isUnbounded() && !p.isKeyValue() && p.getType() != PropertyType.REFERENCE).forEach(p -> SafeRunner.run(() -> this.writeXdgHarvestedProperty((Property)p)));
            this.mdtoXmlWriter.writeEndElement();
        }
        ArrayList _exprs = new ArrayList(tech.getXPathExpression());
        Collections.reverse(_exprs);
        HashSet<String> writtenCodes = new HashSet<String>();
        for (XpathExpression expr : _exprs) {
            ArrayList codes = new ArrayList(expr.getCode());
            Collections.reverse(codes);
            for (Object code : codes) {
                if (!writtenCodes.add(((QName)code).toString())) continue;
                this.mdtoXmlWriter.writeStartElement("xPathExpression");
                if (expr.getDescription() != null) {
                    this.mdtoXmlWriter.writeAttribute("description", expr.getDescription());
                }
                if (expr.getExpression() != null && !expr.getExpression().isEmpty()) {
                    this.mdtoXmlWriter.writeAttribute("expression", expr.getExpression());
                }
                if (expr.eIsSet((EStructuralFeature)TechPackage.eINSTANCE.getXpathExpression_IsProvider())) {
                    this.mdtoXmlWriter.writeAttribute("isProvider", "" + expr.isIsProvider());
                }
                for (XpathParameter p3 : expr.getXPathParameter()) {
                    this.mdtoXmlWriter.writeStartElement("xPathParameter");
                    if (p3.eIsSet((EStructuralFeature)TechPackage.eINSTANCE.getXpathParameter_DefaultValue())) {
                        if (p3.getDefaultValue() != null) {
                            this.mdtoXmlWriter.writeAttribute("defaultValue", p3.getDefaultValue());
                        } else {
                            this.mdtoXmlWriter.writeAttribute("defaultValue", "");
                        }
                    }
                    if (p3.eIsSet((EStructuralFeature)TechPackage.eINSTANCE.getXpathParameter_Name())) {
                        this.mdtoXmlWriter.writeAttribute("name", p3.getName().getLiteral());
                    }
                    if (p3.eIsSet((EStructuralFeature)TechPackage.eINSTANCE.getXpathParameter_Substitution())) {
                        this.mdtoXmlWriter.writeAttribute("substitution", "" + p3.isSubstitution());
                    }
                    this.mdtoXmlWriter.writeEndElement();
                }
                for (Iterator v : expr.getXPathVariable()) {
                    this.mdtoXmlWriter.writeStartElement("xPathVariable");
                    this.mdtoXmlWriter.writeAttribute("expression", v.getExpression());
                    if (v.getName() != null && !v.getName().trim().isEmpty()) {
                        this.mdtoXmlWriter.writeAttribute("name", v.getName());
                    }
                    this.mdtoXmlWriter.writeEndElement();
                }
                this.mdtoXmlWriter.writeStartElement("code");
                this.mdtoXmlWriter.writeCharacters(((QName)code).toString());
                this.mdtoXmlWriter.writeEndElement();
                this.mdtoXmlWriter.writeEndElement();
            }
        }
        for (MetaDataLinkType l : tech.getMetaDataLinkType()) {
            this.mdtoXmlWriter.writeStartElement("metaDataLinkType");
            for (EAttribute a : l.eClass().getEAllAttributes()) {
                if (!l.eIsSet((EStructuralFeature)a) || a == TechPackage.eINSTANCE.getMetaDataLinkType_Technology()) continue;
                this.mdtoXmlWriter.writeAttribute(a.getName(), l.eGet((EStructuralFeature)a).toString());
            }
            for (Parameter p4 : l.getParameter()) {
                this.mdtoXmlWriter.writeStartElement("parameter");
                for (EAttribute a : p4.eClass().getEAllAttributes()) {
                    if (!p4.eIsSet((EStructuralFeature)a)) continue;
                    this.mdtoXmlWriter.writeAttribute(a.getName(), p4.eGet((EStructuralFeature)a).toString());
                }
                this.mdtoXmlWriter.writeEndElement();
            }
            for (Parameter p4 : l.getActionCoreProperty()) {
                this.mdtoXmlWriter.writeStartElement("actionCodeProperty");
                for (EAttribute a : p4.eClass().getEAllAttributes()) {
                    if (!p4.eIsSet((EStructuralFeature)a)) continue;
                    this.mdtoXmlWriter.writeAttribute(a.getName(), p4.eGet((EStructuralFeature)a).toString());
                }
                this.mdtoXmlWriter.writeEndElement();
            }
            for (String s : l.getTechnology()) {
                this.mdtoXmlWriter.writeStartElement("technology");
                this.mdtoXmlWriter.writeCharacters(s);
                this.mdtoXmlWriter.writeEndElement();
            }
            for (Level lv : l.getLevel()) {
                this.mdtoXmlWriter.writeStartElement("level");
                this.mdtoXmlWriter.writeCharacters("#" + lv.getCode());
                this.mdtoXmlWriter.writeEndElement();
            }
            this.mdtoXmlWriter.writeEndElement();
        }
        for (ActionDefinitionHelper.ActionDefinition def : ActionDefinitionHelper.getAllAction()) {
            HashMap paramDesc;
            if (!def.hasParamatersWithMdLinkInitializer() || (paramDesc = def.getToolDescriptor().getParametersPerLevels()) == null) continue;
            for (String lvl : paramDesc.keySet()) {
                this.mdtoXmlWriter.writeStartElement("metaDataLinkType");
                this.mdtoXmlWriter.writeStartElement("technology");
                this.mdtoXmlWriter.writeCharacters(def.getClassName());
                this.mdtoXmlWriter.writeEndElement();
                for (ProcessToolDescriptor.ParameterDescriptor pd : (List)paramDesc.get(lvl)) {
                    String val = pd.getMdLinkInitializationXPathExpression4Lvl(lvl);
                    if (val == null) continue;
                    this.mdtoXmlWriter.writeStartElement("parameter");
                    this.mdtoXmlWriter.writeAttribute("name", pd.getName());
                    this.mdtoXmlWriter.writeAttribute("value", val);
                    this.mdtoXmlWriter.writeEndElement();
                }
                this.mdtoXmlWriter.writeStartElement("level");
                this.mdtoXmlWriter.writeCharacters("#" + lvl);
                this.mdtoXmlWriter.writeEndElement();
                this.mdtoXmlWriter.writeEndElement();
            }
        }
        this.mdtoXmlWriter.writeEndElement();
        this.mdtoXmlWriter.writeEndElement();
        this.mdtoXmlWriter.writeEndDocument();
    }

    private void writeXdgHarvestedProperty(Property p) throws XMLStreamException {
        this.mdtoXmlWriter.writeStartElement("xdgHarvestedProperty");
        this.mdtoXmlWriter.writeAttribute("name", p.getXmlName());
        this.mdtoXmlWriter.writeEndElement();
    }

    class WithChildState {
        boolean withChild = false;

        WithChildState() {
        }
    }
}

