/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration;

import com.semarchy.xdi.designer.generation.xsl.TransformerFactoryImpl;
import com.semarchy.xdi.designer.generation.xsl.gene.GenerationEvaluator;
import com.semarchy.xdi.designer.generation.xsl.gene.GenerationMap;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.OneProcCompilation;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration.ExternalisationGenerator;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration.MdXmlParser;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration.Messages;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration.XDGAggregator;
import com.semarchy.xdi.designer.generation.xsl.global.Functions;
import com.semarchy.xdi.designer.generation.xsl.saxon.extension.impl.AttributeReader;
import com.semarchy.xdi.designer.generation.xsl.saxon.extension.impl.Configuration4Generation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.NodeInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;

public class MdConfigurationCompilation {
    private Logger logger = LogManager.getLogger(MdConfigurationCompilation.class);
    XMLInputFactory factory;
    XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    Transformer transfomer;
    String outputFolderPath;
    String confName;
    Set<String> handlingSources = new HashSet<String>();
    Set<String> handledSources = new HashSet<String>();
    ExternalisationGenerator externalizer = null;
    File configurationFolder = null;
    File confFile = null;
    File externalizedFile = null;
    String externalizationSuffix;
    String externalizationPrefix;
    int externalizationNumber = -1;
    HashMap<String, Integer> externalizedAttributesIndexes = new HashMap();
    private String stambiaRuntimeHome;
    private Map<String, URI> iconsPerLevel = null;
    GenerationMap aggregatedGenMap = null;
    XDGAggregator.PathResolver pathResolver = new XDGAggregator.PathResolver(){

        @Override
        public OutputStream getOutputStream(Path path) throws IOException {
            return new BufferedOutputStream(new FileOutputStream(path.toFile()));
        }

        @Override
        public InputStream getInputStream(Path path) throws IOException {
            return new BufferedInputStream(new FileInputStream(path.toFile()));
        }
    };
    XDGAggregator xdgAggregator = new XDGAggregator(this.pathResolver);

    public MdConfigurationCompilation(String stambiaRuntimeHome) {
        this.stambiaRuntimeHome = stambiaRuntimeHome;
        this.factory = XMLInputFactory.newInstance();
        this.factory.setProperty("javax.xml.stream.supportDTD", false);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
    }

    public void setIconsPerLevel(Map<String, URI> iconsPerLevel) {
        this.iconsPerLevel = iconsPerLevel;
    }

    /*
     * WARNING - void declaration
     */
    public Result compileMd(boolean externalize, String outputFolderPath, String sourceFilePath, String modelName, String confName, String externalizationPrefix, String externalizationSuffix, Properties configurationValues, boolean preseverExternalizationOffset) throws Exception {
        this.aggregatedGenMap = new GenerationMap();
        this.handlingSources.clear();
        this.handledSources.clear();
        this.externalizationPrefix = externalizationPrefix;
        this.externalizationSuffix = externalizationSuffix;
        this.outputFolderPath = outputFolderPath;
        this.confName = confName;
        if (!preseverExternalizationOffset) {
            this.externalizationNumber = 0;
            this.externalizedAttributesIndexes.clear();
        }
        try {
            Object is;
            String[] stringArray;
            if (externalize) {
                Object s;
                void var11_17;
                this.configurationFolder = new File(sourceFilePath.replace("\\", "/").replace("/wrk2", "/wrk1"));
                this.confFile = null;
                this.externalizedFile = null;
                stringArray = this.configurationFolder.list();
                int n = stringArray.length;
                boolean n2 = false;
                while (var11_17 < n) {
                    s = stringArray[var11_17];
                    if (((String)s).endsWith(modelName + ".conf.xml")) {
                        this.confFile = new File(this.configurationFolder, (String)s);
                    }
                    if (((String)s).endsWith(modelName + ".conf")) {
                        this.externalizedFile = new File(this.configurationFolder, (String)s);
                    }
                    if (this.externalizedFile != null && this.confFile != null) break;
                    ++var11_17;
                }
                this.externalizer = new ExternalisationGenerator(this.aggregatedGenMap, this.getStambiaRuntimeHome(), this.iconsPerLevel);
                s = null;
                Object throwable = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(this.confFile));
                    try {
                        this.externalizer.prepareExternalization((InputStream)is);
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (s == null) {
                        s = throwable2;
                    } else if (s != throwable2) {
                        ((Throwable)s).addSuppressed(throwable2);
                    }
                    throw s;
                }
            }
            this.transfomer = this.createTransformer(outputFolderPath);
            HashMap<File, Map<MdXmlParser.Info, String>> toCompile = new HashMap<File, Map<MdXmlParser.Info, String>>();
            for (File file : this.getMdFilePaths(sourceFilePath)) {
                toCompile.put(file, this.doPreCompile(file.getAbsolutePath().replace("\\", "/"), confName, configurationValues));
            }
            for (Map.Entry entry : toCompile.entrySet()) {
                if (((Map)entry.getValue()).isEmpty()) continue;
                this.doCompile2(((File)entry.getKey()).getAbsolutePath().replace("\\", "/"), externalize ? (Map)entry.getValue() : null);
            }
            if (externalize && this.confFile != null) {
                XMLStreamWriter xMLStreamWriter = null;
                try {
                    XMLStreamWriter xMLStreamWriter2;
                    try {
                        is = null;
                        stringArray = null;
                        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(outputFolderPath + "/" + this.confFile.getName())));){
                            xMLStreamWriter2 = this.outputFactory.createXMLStreamWriter(os, StandardCharsets.UTF_8.name());
                            this.externalizer.generateConf(xMLStreamWriter2, this.externalizedAttributesIndexes, externalizationPrefix, externalizationSuffix);
                            xMLStreamWriter2.flush();
                        }
                        catch (Throwable throwable) {
                            if (is == null) {
                                is = throwable;
                            } else if (is != throwable) {
                                ((Throwable)is).addSuppressed(throwable);
                            }
                            throw is;
                        }
                    }
                    catch (Throwable throwable) {
                        if (xMLStreamWriter != null) {
                            xMLStreamWriter.close();
                        }
                        throw throwable;
                    }
                    if (xMLStreamWriter2 != null) {
                        xMLStreamWriter2.close();
                    }
                }
                catch (Exception ex) {
                    throw new Exception(Messages.MdConfigurationCompilation_1, ex);
                }
            }
            Path path = this.xdgAggregator.createAggregatedFile(Path.of(outputFolderPath, new String[0]));
            Result result = () -> p == null ? null : p.toString();
            return result;
        }
        finally {
            this.externalizer = null;
            this.externalizationPrefix = null;
            this.externalizationSuffix = null;
            this.confFile = null;
            this.configurationFolder = null;
            this.confName = null;
            this.outputFolderPath = null;
            this.externalizedFile = null;
            this.transfomer = null;
            this.handlingSources.clear();
            this.handledSources.clear();
            Functions.clear();
            this.xdgAggregator = new XDGAggregator(this.pathResolver);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<MdXmlParser.Info, String> doPreCompile(String sourceFilePath, String confName, Properties configurationValues) throws Exception {
        Map<MdXmlParser.Info, String> m;
        File f;
        File mdResourceFile;
        block24: {
            mdResourceFile = new File(sourceFilePath);
            if (!sourceFilePath.endsWith(".md")) {
                return Collections.EMPTY_MAP;
            }
            File outputFile = new File(sourceFilePath.replace("\\", "/").replace("/wrk1/", "/wrk2/"));
            if (outputFile.exists()) {
                return Collections.EMPTY_MAP;
            }
            XMLEventReader mdXmlReader = null;
            XMLStreamWriter mdXmlWriter = null;
            f = new File(mdResourceFile.getAbsolutePath().replace("\\", "/").replace("/wrk1/", "/wrk2/") + ".tmp");
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            m = null;
            try {
                try {
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try {
                        BufferedInputStream is = new BufferedInputStream(new FileInputStream(mdResourceFile));
                        try {
                            try (EscapingBufferedOutputStream os = new EscapingBufferedOutputStream(new FileOutputStream(f));){
                                mdXmlReader = this.factory.createXMLEventReader(is, StandardCharsets.UTF_8.name());
                                mdXmlWriter = this.outputFactory.createXMLStreamWriter(os, StandardCharsets.UTF_8.name());
                                MdXmlParser parser = null;
                                parser = this.externalizer == null ? new MdXmlParser(mdXmlReader, mdXmlWriter, confName, configurationValues) : new MdXmlParser(mdXmlReader, mdXmlWriter, confName, configurationValues, this.externalizer.getInheritedAttributes(), this.externalizer.getExternalizedAttributesId(), this.externalizedAttributesIndexes, this.externalizationPrefix, this.externalizationSuffix, this.externalizationNumber);
                                m = parser.parse();
                                HashMap<String, Integer> res = parser.getResult();
                                if (res != null) {
                                    this.externalizationNumber += res.size();
                                    this.externalizedAttributesIndexes.putAll(res);
                                }
                                mdXmlWriter.flush();
                            }
                            if (is == null) break block24;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (is == null) throw throwable;
                            ((InputStream)is).close();
                            throw throwable;
                        }
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    throw new Exception(Messages.MdConfigurationCompilation_2 + mdResourceFile.getAbsolutePath(), ex);
                }
            }
            finally {
                if (mdXmlWriter != null) {
                    mdXmlWriter.close();
                }
                if (mdXmlReader != null) {
                    mdXmlReader.close();
                }
            }
        }
        if (!m.isEmpty()) return m;
        String newName = mdResourceFile.getAbsolutePath().replace("\\", "/").replace("/wrk1/", "/wrk2/");
        if (f.renameTo(new File(newName))) return Collections.EMPTY_MAP;
        this.logger.warn("Failed to move {} to {}", (Object)f, (Object)newName);
        return Collections.EMPTY_MAP;
    }

    private void doCompile2(String sourceFilePath, Map<MdXmlParser.Info, String> externalizedMap) throws Exception {
        File mdResourceFile = new File(sourceFilePath);
        if (!sourceFilePath.endsWith(".md")) {
            return;
        }
        if (this.handledSources.contains(mdResourceFile.getAbsolutePath())) {
            return;
        }
        if (!this.handlingSources.add(mdResourceFile.getAbsolutePath())) {
            throw new LoopDepenciesException(mdResourceFile);
        }
        this.generateMdFile(mdResourceFile, this.externalizer == null ? null : externalizedMap, this.transfomer);
        this.handlingSources.remove(sourceFilePath);
        this.handledSources.add(mdResourceFile.getAbsolutePath());
    }

    private Transformer createTransformer(String outputFolderPath) throws Exception {
        SaxonDelegateExpressionEvaluator delegateExpressionEvaluator = new SaxonDelegateExpressionEvaluator();
        TransformerFactory trFactory = TransformerFactory.newInstance("com.semarchy.xdi.designer.generation.xsl.TransformerFactoryImpl", null);
        trFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        trFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Configuration4Generation cfg = new Configuration4Generation();
        cfg.setRecoveryPolicy(0);
        cfg.setExternalizedExpressionsRegex(".*" + this.externalizationPrefix + "[0-9]+" + this.externalizationSuffix + ".*");
        ((AttributeReader)cfg.getValueResolver()).setEvaluator(delegateExpressionEvaluator);
        cfg.setGenerationMap4ExternalizedAttributes(this.aggregatedGenMap.getAll());
        ((TransformerFactoryImpl)((Object)trFactory)).setConfiguration(cfg);
        URIResolver uriResolver = new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                try {
                    if (href.endsWith(".md") || href.endsWith(".md.tmp")) {
                        URI uri = new URI(OneProcCompilation.formatURI(base.substring(0, base.lastIndexOf("/")) + "/" + href));
                        uri = uri.normalize();
                        SAXSource src = new SAXSource(new InputSource(new BufferedInputStream(uri.toURL().openStream())));
                        src.setSystemId(uri.toString());
                        return src;
                    }
                    URI uri = null;
                    if (href.startsWith("file:")) {
                        uri = new URI(OneProcCompilation.formatURI(href));
                    } else {
                        String s = MdConfigurationCompilation.this.getStambiaRuntimeHome() + "/build";
                        if (!(s = s + "/xsl/" + href).startsWith("/")) {
                            s = "/" + s;
                        }
                        uri = new URI("file:" + OneProcCompilation.formatURI(s));
                    }
                    uri = uri.normalize();
                    File f = new File(uri);
                    if (f.exists() && f.isFile()) {
                        SAXSource src = new SAXSource(new InputSource(new BufferedInputStream(uri.toURL().openStream())));
                        src.setSystemId(uri.toString());
                        return src;
                    }
                }
                catch (Exception ex) {
                    MdConfigurationCompilation.this.logger.error("Failed to resolve {}:{}", (Object)href, (Object)base, (Object)ex);
                }
                return null;
            }
        };
        trFactory.setURIResolver(uriResolver);
        SAXSource xslSource = this.createXSL();
        xslSource.setSystemId("file:" + outputFolderPath + "/foo1");
        Transformer tr = trFactory.newTransformer(xslSource);
        delegateExpressionEvaluator.setContext((XPathContext)new XPathContextMajor((Controller)tr));
        return tr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> generateMdFile(File mdResourceFile, Map<MdXmlParser.Info, String> m, Transformer tr) throws Exception {
        File ff;
        block21: {
            File f = new File(mdResourceFile.getAbsolutePath().replace("\\", "/").replace("/wrk1/", "/wrk2/") + ".tmp");
            GenerationEvaluator evaluator = new GenerationEvaluator(this.aggregatedGenMap);
            ff = new File(mdResourceFile.getAbsolutePath().replace("\\", "/").replace("/wrk1/", "/wrk2/"));
            if (!ff.getParentFile().exists()) {
                ff.getParentFile().mkdirs();
            }
            if (tr == null) return this.aggregatedGenMap.getAll();
            try {
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try {
                        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
                        try {
                            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(ff.getAbsolutePath() + ".out"));){
                                SAXSource src = new SAXSource(new InputSource(is));
                                src.setSystemId(f.toURI().toString());
                                StreamResult outputTarget = new StreamResult(os);
                                if (m != null) {
                                    for (Map.Entry<MdXmlParser.Info, String> entry : m.entrySet()) {
                                        if (this.externalizedAttributesIndexes.keySet().contains(entry.getKey().getNodeId() + "." + entry.getKey().getAttributeName())) {
                                            evaluator.addEvaluationExpression(entry.getKey().getNodeId(), entry.getKey().getNodePath(), "ext." + entry.getKey().getNodeId() + "." + entry.getKey().getXMLEntityType() + "." + entry.getKey().getAttributeName(), entry.getValue());
                                        }
                                        evaluator.addEvaluationExpression(entry.getKey().getNodeId(), entry.getKey().getNodePath(), entry.getKey().getNodeId() + "." + entry.getKey().getXMLEntityType() + "." + entry.getKey().getAttributeName(), entry.getValue());
                                    }
                                }
                                tr.setParameter("generationEvaluator", evaluator);
                                tr.transform(src, outputTarget);
                            }
                            if (is == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (is == null) throw throwable;
                            ((InputStream)is).close();
                            throw throwable;
                        }
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    throw new Exception(Messages.MdConfigurationCompilation_3 + String.valueOf(f));
                }
            }
            catch (Throwable throwable) {
                Files.move(new File(ff.getAbsolutePath() + ".out").toPath(), ff.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (!ff.toPath().toString().endsWith(".xdg.md")) throw throwable;
                this.xdgAggregator.addXDGPath(ff.toPath());
                throw throwable;
            }
        }
        Files.move(new File(ff.getAbsolutePath() + ".out").toPath(), ff.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (!ff.toPath().toString().endsWith(".xdg.md")) return this.aggregatedGenMap.getAll();
        this.xdgAggregator.addXDGPath(ff.toPath());
        return this.aggregatedGenMap.getAll();
    }

    private SAXSource createXSL() throws IOException {
        ByteArrayOutputStream evalOs = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream is = new BufferedInputStream(this.getClass().getResourceAsStream("evalgraph.xsl"));){
            byte[] buf = new byte[2048];
            int sz = -1;
            while ((sz = ((InputStream)is).read(buf)) != -1) {
                evalOs.write(buf, 0, sz);
            }
            evalOs.flush();
            evalOs.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new SAXSource(new InputSource(new BufferedInputStream(new ByteArrayInputStream(evalOs.toByteArray()))));
    }

    private List<File> getMdFilePaths(String folderPath) {
        File f = new File(folderPath);
        ArrayList<File> res = new ArrayList<File>();
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File c = fileArray[n2];
            if (c.isDirectory()) {
                res.addAll(this.getMdFilePaths(c.getAbsolutePath()));
            } else if (c.getName().endsWith(".md")) {
                res.add(c);
            }
            ++n2;
        }
        return res;
    }

    private String getStambiaRuntimeHome() {
        return this.stambiaRuntimeHome;
    }

    private class EscapingBufferedOutputStream
    extends BufferedOutputStream {
        List<Integer> buffer;
        boolean buffered;

        public EscapingBufferedOutputStream(OutputStream out) {
            super(out);
            this.buffer = new ArrayList<Integer>();
            this.buffered = false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public synchronized void write(int b) throws IOException {
            byte[] str = null;
            if (this.buffered) {
                if (b == "&quot;".charAt(this.buffer.size())) {
                    this.buffer.add(b);
                    if (b != 59) return;
                    this.buffered = false;
                    this.buffer.clear();
                    str = "&#34;".getBytes(StandardCharsets.UTF_8);
                } else {
                    this.buffered = false;
                    for (Integer i : this.buffer) {
                        super.write(i);
                    }
                    this.buffer.clear();
                }
            }
            if (b == 13) {
                str = "&#xD;".getBytes(StandardCharsets.UTF_8);
            } else if (b == 10) {
                str = "&#xA;".getBytes(StandardCharsets.UTF_8);
            } else if (b == 9) {
                str = "&#x9;".getBytes(StandardCharsets.UTF_8);
            } else if (b == 38) {
                this.buffer.add(b);
                this.buffered = true;
                return;
            }
            if (str != null) {
                int i = 0;
                while (i < str.length) {
                    super.write(str[i]);
                    ++i;
                }
                return;
            } else {
                super.write(b);
            }
        }
    }

    public class LoopDepenciesException
    extends Exception {
        private static final long serialVersionUID = 4057731534533405918L;
        final File mdGeneratingFile;

        public LoopDepenciesException(File mdGeneratingFile) {
            this.mdGeneratingFile = mdGeneratingFile;
        }

        public File getMdGeneratingFile() {
            return this.mdGeneratingFile;
        }

        @Override
        public String getMessage() {
            int i = this.getMdGeneratingFile().getAbsolutePath().replace("\\", "/").indexOf("/wrk1/");
            String fName = this.getMdGeneratingFile().getAbsolutePath().substring(i + 5);
            return Messages.MdConfigurationCompilation_0 + fName;
        }
    }

    public static interface Result {
        public String getXDGAggregatedFile();
    }

    class SaxonDelegateExpressionEvaluator
    implements AttributeReader.IDelegateExpressionEvaluator {
        XPathContext ctx = null;
        GenerationEvaluator delegate;

        SaxonDelegateExpressionEvaluator() {
            this.delegate = new GenerationEvaluator(MdConfigurationCompilation.this.aggregatedGenMap);
        }

        void setContext(XPathContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public CharSequence evaluateExpression(String storageKey, NodeInfo node, CharSequence expression) {
            String res;
            String string = res = storageKey == null ? null : MdConfigurationCompilation.this.aggregatedGenMap.getCode(storageKey);
            if (res != null) {
                return res;
            }
            try {
                res = this.delegate.evaluateX(this.ctx, node, expression.toString());
                if (storageKey != null) {
                    MdConfigurationCompilation.this.aggregatedGenMap.store(storageKey, res);
                }
                return res;
            }
            catch (Exception e) {
                MdConfigurationCompilation.this.logger.error("Failed to evaluate {}", (Object)expression, (Object)e);
                return expression;
            }
        }
    }
}

