/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.sql;

import com.semarchy.xdi.designer.generation.xsl.sql.ResultSetManager;
import java.sql.Connection;
import java.util.HashMap;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sql.SQLQuery;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class SQLResultSetManager
extends SQLQuery {
    Expression connection;
    String rowTag;
    String colTag;
    boolean disable = false;
    Expression querys;

    public void prepareAttributes() throws XPathException {
        String disableAtt;
        String querysAtt = this.getAttributeValue("", "querys");
        if (querysAtt == null) {
            this.reportAbsence("querys");
        } else {
            this.querys = this.makeExpression(querysAtt);
        }
        String connectAtt = this.getAttributeValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
        this.rowTag = this.getAttributeValue("", "row-tag");
        if (this.rowTag == null) {
            this.rowTag = "row";
        }
        if (this.rowTag.indexOf(58) >= 0) {
            this.compileError("rowTag must not contain a colon");
        }
        this.colTag = this.getAttributeValue("", "column-tag");
        if (this.colTag == null) {
            this.colTag = "col";
        }
        if (this.colTag.indexOf(58) >= 0) {
            this.compileError("colTag must not contain a colon");
        }
        if ((disableAtt = this.getAttributeValue("", "disable-output-escaping")) != null) {
            if (disableAtt.equals("yes")) {
                this.disable = true;
            } else if (disableAtt.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable exec) throws XPathException {
        return new QueryInstruction(this.connection, this.querys, this.rowTag, this.colTag, this.disable);
    }

    private static class QueryInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int QUERYS = 1;
        String rowTag;
        String colTag;
        int options;
        ResultSetManager resultSetManaget;
        Expression querys;

        public QueryInstruction(Expression connection, Expression querys, String rowTag, String colTag, boolean disable) {
            Expression[] sub = new Expression[]{connection, querys};
            this.setArguments(sub);
            this.querys = querys;
            this.rowTag = rowTag;
            this.colTag = colTag;
            this.options = disable ? 1 : 0;
        }

        public int getImplementationMethod() {
            return 1;
        }

        public int computeCardinality() {
            return 16384;
        }

        public String getExpressionType() {
            return "sql:resultSetManager";
        }

        public Item evaluateItem(XPathContext context) throws XPathException {
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                XPathException de = new XPathException("Value of connection expression is not a JDBC Connection");
                de.setXPathContext(context);
                throw de;
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            Item _querys = this.arguments[1].evaluateItem(context);
            HashMap<String, String> querysMap = new HashMap<String, String>();
            HashMap<String, String> sourceSetMap = new HashMap<String, String>();
            AxisIterator ai = ((TinyDocumentImpl)_querys).iterateAxis((byte)3);
            while (ai.next() != null) {
                Item item = ai.current();
                String query = Navigator.getAttributeValue((NodeInfo)((NodeInfo)item), null, (String)"query");
                String sourceSet = Navigator.getAttributeValue((NodeInfo)((NodeInfo)item), null, (String)"sourceSet");
                String name = Navigator.getAttributeValue((NodeInfo)((NodeInfo)item), null, (String)"name");
                querysMap.put(name, query);
                sourceSetMap.put(name, sourceSet);
            }
            this.resultSetManaget = new ResultSetManager(connection, querysMap, sourceSetMap);
            return new ObjectValue((Object)this.resultSetManaget);
        }
    }
}

