/*
 * Decompiled with CFR 0.152.
 */
package com.indy.shell;

import com.indy.shell.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class WorkspaceSynchronizer {
    private File sourceFolder;

    public WorkspaceSynchronizer(File sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public IStatus synchronizeWithWorkspace() throws InterruptedException {
        final Visitor v = new Visitor();
        v.visit(this.sourceFolder);
        WorkspaceJob job = new WorkspaceJob(Messages.WorkspaceSynchronizer_1){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IWorkspace wkps = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot root = wkps.getRoot();
                for (File projectFolder : v.projectsFolders) {
                    try {
                        IProject project = root.getProject(projectFolder.getName());
                        if (project.exists()) continue;
                        IProjectDescription desc = wkps.newProjectDescription(project.getName());
                        ICommand command = desc.newCommand();
                        command.setBuilderName("com.indy.gmf.map.diagram.id1");
                        desc.setBuildSpec(new ICommand[]{command});
                        Path locationPath = new Path(projectFolder.getAbsolutePath());
                        if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                            desc.setLocation(null);
                        } else {
                            desc.setLocation((IPath)locationPath);
                        }
                        project.create(desc, monitor);
                        System.out.println("Created project " + project.getName());
                        project.open(monitor);
                        project.refreshLocal(2, monitor);
                    }
                    catch (Exception ex) {
                        return new Status(4, "com.indy.shell", Messages.WorkspaceSynchronizer_5 + projectFolder.getAbsolutePath(), (Throwable)ex);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        job.join();
        return job.getResult();
    }

    private class Visitor {
        List<File> projectsFolders = new ArrayList<File>();

        private Visitor() {
        }

        public void visit(File folder) {
            boolean isProject = false;
            ArrayList<File> folders = new ArrayList<File>();
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    folders.add(f);
                } else if (f.isFile() && f.getName().equals(".project")) {
                    isProject = true;
                    break;
                }
                ++n2;
            }
            if (isProject) {
                this.projectsFolders.add(folder);
            } else {
                for (File f : folders) {
                    this.visit(f);
                }
            }
        }
    }
}

