/*
 * Decompiled with CFR 0.152.
 */
package com.indy.shell.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

class MappingWorkspaceVisitor
implements IResourceVisitor {
    private static final Collection<String> IGNORED_FOLDERS = Arrays.asList("indy.build", "indy.diagram");
    private List<IFile> mappingFiles = new ArrayList<IFile>();

    MappingWorkspaceVisitor() {
    }

    public boolean visit(IResource resource) throws CoreException {
        boolean visit = false;
        switch (resource.getType()) {
            case 4: {
                visit = resource.getProject().isOpen();
                break;
            }
            case 2: {
                visit = !resource.isDerived() && !IGNORED_FOLDERS.contains(resource.getName());
                break;
            }
            case 1: {
                if (!"map".equals(resource.getFileExtension())) break;
                this.mappingFiles.add((IFile)resource);
                break;
            }
            default: {
                visit = true;
            }
        }
        return visit;
    }

    List<IFile> getMappings() {
        return this.mappingFiles;
    }
}

