/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine;

import com.indy.ui.engine.WatchEngine;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={WatchEngine.ISessionListenerManager.class})
public class ComponentSessionListenerManager
implements WatchEngine.ISessionListenerManager {
    private Map<String, Collection<WatchEngine.IUIListener>> listenerMapByModelId = Collections.synchronizedMap(new HashMap());
    private Map<String, Collection<WatchEngine.IUIListener>> listenerMapBySessionId = Collections.synchronizedMap(new HashMap());

    @Reference(policy=ReferencePolicy.DYNAMIC, unbind="unbind", cardinality=ReferenceCardinality.MULTIPLE)
    public void bind(WatchEngine.IUIListener sessionListener, Map serviceProperties) {
        String sessionId;
        String modelId = (String)serviceProperties.get("com.indy.ui.engine.IUIListener.modelId");
        if (modelId != null) {
            Collection<WatchEngine.IUIListener> c = this.listenerMapByModelId.get(modelId);
            if (c == null) {
                c = new HashSet<WatchEngine.IUIListener>();
                this.listenerMapByModelId.put(modelId, c);
            }
            c.add(sessionListener);
        }
        if ((sessionId = (String)serviceProperties.get("com.indy.ui.engine.IUIListener.sessionId")) != null) {
            Collection<WatchEngine.IUIListener> c = this.listenerMapBySessionId.get(sessionId);
            if (c == null) {
                c = new HashSet<WatchEngine.IUIListener>();
                this.listenerMapBySessionId.put(sessionId, c);
            }
            c.add(sessionListener);
        }
    }

    public void unbind(WatchEngine.IUIListener sessionListener, Map serviceProperties) {
        Collection<WatchEngine.IUIListener> c;
        String sessionId;
        Collection<WatchEngine.IUIListener> c2;
        String modelId = (String)serviceProperties.get("com.indy.ui.engine.IUIListener.modelId");
        if (modelId != null && (c2 = this.listenerMapByModelId.get(modelId)) != null) {
            c2.remove(sessionListener);
            if (c2.isEmpty()) {
                this.listenerMapByModelId.remove(modelId);
            }
        }
        if ((sessionId = (String)serviceProperties.get("com.indy.ui.engine.IUIListener.sessionId")) != null && (c = this.listenerMapBySessionId.get(modelId)) != null) {
            c.remove(sessionListener);
            if (c.isEmpty()) {
                this.listenerMapBySessionId.remove(modelId);
            }
        }
    }

    @Override
    public Collection<WatchEngine.IUIListener> getListeners(String modelId) {
        Collection<WatchEngine.IUIListener> c = this.listenerMapByModelId.get(modelId);
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        return c;
    }

    @Override
    public Collection<WatchEngine.IUIListener> getListenersBySession(String sessionId) {
        Collection<WatchEngine.IUIListener> c = this.listenerMapBySessionId.get(sessionId);
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        return c;
    }
}

