/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.handlers;

import com.indy.engine.core.common.objects2.IActionDataExchange;
import com.indy.gmf.proc.ActionProcess;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.custom.out.gmf.MultipleEditorInputProvider;
import com.indy.ui.engine.ClientVariable;
import com.indy.ui.engine.EngineGlobal;
import com.semarchy.xdi.designer.core.MonitorCapability;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.sax.TransformerHandler;
import org.eclipse.core.runtime.Platform;
import org.xml.sax.helpers.AttributesImpl;

public class Dumper {
    private static final String NODE_VARIABLE = "variable";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String MODE_EXECUTED = "executed";
    private static final String NODE_ACTION = "action";
    private static final String NODE_ACTION_FAILED = "actionError";
    private static final String NODE_SESSION = "session";
    private MonitorCapability currentRootProcess;
    private List<String> currentActionChildIds;
    private String actionProcessUniqueId;
    private String actionCodeUniqueId;
    private String sessionId;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Dumper(String sessionId, ActionProcess process) {
        this.sessionId = sessionId;
        this.currentRootProcess = (MonitorCapability)Platform.getAdapterManager().getAdapter((Object)process, MonitorCapability.class);
        this.initIds();
        this.actionCodeUniqueId = this.actionProcessUniqueId;
        try {
            this.currentActionChildIds = EngineGlobal.engine.getLstChildIds(sessionId, this.actionCodeUniqueId);
        }
        catch (Exception e) {
            this.actionProcessUniqueId = null;
        }
    }

    private Dumper(String sessionId, MonitorCapability currentRootProcess, String actionProcessUniqueId, String actionCodeUniqueId) {
        this.sessionId = sessionId;
        this.currentRootProcess = currentRootProcess;
        this.actionCodeUniqueId = actionCodeUniqueId;
        this.actionProcessUniqueId = actionProcessUniqueId;
        this.initIds();
        try {
            this.currentActionChildIds = EngineGlobal.engine.getLstChildIds(sessionId, actionCodeUniqueId);
        }
        catch (Exception e) {
            actionProcessUniqueId = null;
        }
    }

    public void dumpCurrentLevel(TransformerHandler hd) throws Exception {
        if (hd == null) {
            Dumper.dumpInfoConsole(this.sessionId, this.actionCodeUniqueId, EngineGlobal.getEngine().getActionLstVariables(this.sessionId, this.actionCodeUniqueId));
        } else {
            Map<String, Map<String, Object>> errors;
            if (this.actionCodeUniqueId == this.actionProcessUniqueId) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "", ATTRIBUTE_ID, "", this.sessionId);
                hd.startElement("", "", NODE_SESSION, atts);
                Map<String, Map<String, Object>> sessionVariables = EngineGlobal.getEngine().getLstRootSessionVariables(this.sessionId);
                Dumper.dumpInfoXml(this.sessionId, null, sessionVariables, hd);
            }
            Map<String, Map<String, Object>> variables = EngineGlobal.getEngine().getActionLstVariables(this.sessionId, this.actionCodeUniqueId);
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", ATTRIBUTE_ID, "", this.actionCodeUniqueId);
            String actionString = null;
            if (variables != null) {
                actionString = variables.keySet().iterator().next();
                String actionName = actionString.substring(0, actionString.lastIndexOf("/"));
                if (actionName.contains("/")) {
                    actionName = actionName.substring(actionName.lastIndexOf("/") + 1);
                }
                atts.addAttribute("", "", ATTRIBUTE_NAME, "", actionName);
            }
            String tag = (errors = EngineGlobal.getEngine().getLstSessionErrors(this.sessionId)).get(this.actionCodeUniqueId) != null ? NODE_ACTION_FAILED : NODE_ACTION;
            hd.startElement("", "", tag, atts);
            Dumper.dumpInfoXml(this.sessionId, this.actionCodeUniqueId, variables, hd);
            if (this.currentActionChildIds != null) {
                for (String s : this.currentActionChildIds) {
                    new Dumper(this.sessionId, this.currentRootProcess, this.actionProcessUniqueId, s).dumpCurrentLevel(hd);
                }
            }
            hd.endElement("", "", tag);
            if (this.actionCodeUniqueId == this.actionProcessUniqueId) {
                hd.endElement("", "", NODE_SESSION);
            }
        }
    }

    private static void dumpInfoConsole(String sessionId, String actionId, Map<String, Map<String, Object>> actionVariables) {
        System.out.println(actionId);
        if (actionVariables == null) {
            return;
        }
        for (String k : actionVariables.keySet()) {
            System.out.println("\t" + k + "=" + String.valueOf(actionVariables.get(k)));
        }
    }

    private static void dumpInfoXml(String sessionId, String actionId, Map<String, Map<String, Object>> actionVariables, TransformerHandler hd) throws Exception {
        AttributesImpl atts = new AttributesImpl();
        for (String k : actionVariables.keySet()) {
            String s;
            ClientVariable v;
            IActionDataExchange currentInfo;
            Map<String, Object> o;
            atts.clear();
            atts.addAttribute("", "", ATTRIBUTE_NAME, "", ((String)actionVariables.get(k).get(ATTRIBUTE_NAME)).substring(((String)actionVariables.get(k).get(ATTRIBUTE_NAME)).lastIndexOf("/") + 1));
            hd.startElement("", "", NODE_VARIABLE, atts);
            String val = (String)actionVariables.get(k).get("value");
            boolean cdata = atts.getValue(ATTRIBUTE_NAME).equals("CORE_ACTION_TXT");
            if (cdata) {
                hd.startCDATA();
            }
            hd.characters(val.toCharArray(), 0, val.length());
            if (cdata) {
                hd.endCDATA();
            }
            hd.endElement("", "", NODE_VARIABLE);
            if (!atts.getValue(ATTRIBUTE_NAME).equals("CORE_ACTION_TXT") || sessionId == null || actionId == null || (o = actionVariables.get((currentInfo = EngineGlobal.getEngine().getActionInfo(sessionId, actionId)).getName() + "/CORE_ACTION_EXECUTED_TXT")) == null || (v = new ClientVariable(o)) == null || (s = v.getValue()).equals(val)) continue;
            atts.addAttribute("", "", ATTRIBUTE_MODE, "", MODE_EXECUTED);
            hd.startElement("", "", NODE_VARIABLE, atts);
            hd.startCDATA();
            hd.characters(s.toCharArray(), 0, s.length());
            hd.endCDATA();
            hd.endElement("", "", NODE_VARIABLE);
        }
    }

    private void initIds() {
        try {
            ClientVariable var;
            Map<String, Object> o;
            Map<String, Map<String, Object>> tmGlobalVariables;
            if (this.currentRootProcess != null && this.currentRootProcess.getId() != null) {
                String actionProcessSrcId = this.currentRootProcess.getId();
                Queue ids2 = ((MultipleEditorInputProvider)EngineVariable.INSTANCE.getSelectedEditor()).getContextRefId();
                String currentProcessRealId = null;
                while (!ids2.isEmpty()) {
                    String id4;
                    String id2 = (String)ids2.poll();
                    String id3 = EngineVariable.INSTANCE.getAltIdToInstance(actionProcessSrcId);
                    String string = id4 = id2 != null ? EngineVariable.INSTANCE.getAltIdToInstance(id2) : null;
                    if (id4 != null) {
                        currentProcessRealId = id4;
                        continue;
                    }
                    if (id2 == null && id3 != null) {
                        currentProcessRealId = id3;
                        continue;
                    }
                    Map<String, Map<String, Object>> map = null;
                    if (currentProcessRealId == null) {
                        map = EngineGlobal.engine.getLstInstanciatedIds(EngineVariable.INSTANCE.getSessionId(), actionProcessSrcId);
                        if (map != null && map.size() > 0) {
                            currentProcessRealId = map.keySet().iterator().next();
                        } else {
                            currentProcessRealId = null;
                            break;
                        }
                    }
                    if (id2 == null) continue;
                    map = EngineGlobal.engine.getLstInstanciatedIds(EngineVariable.INSTANCE.getSessionId(), id2);
                    if (map != null && map.size() > 0) {
                        currentProcessRealId = map.keySet().iterator().next();
                        continue;
                    }
                    currentProcessRealId = null;
                    break;
                }
                this.actionProcessUniqueId = currentProcessRealId;
            }
            if (this.actionProcessUniqueId == null && (tmGlobalVariables = EngineGlobal.engine.getLstRootSessionVariables(this.sessionId)) != null && (o = tmGlobalVariables.get("CORE_ROOT")) != null && (var = new ClientVariable(o)) != null) {
                String id;
                this.actionProcessUniqueId = id = EngineGlobal.engine.getActionId(this.sessionId, var.getValue());
                this.actionCodeUniqueId = id;
                return;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "An exception occured : ", e);
        }
    }
}

