/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.handlers;

import com.indy.gmf.proc.ActionProcess;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.custom.out.patch.FileDialogPatch;
import com.indy.ui.engine.Activator;
import com.indy.ui.engine.EngineGlobal;
import com.indy.ui.engine.EngineServerWrapper;
import com.indy.ui.engine.Messages;
import com.indy.ui.engine.handlers.Dumper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.helpers.AttributesImpl;

public class GenerateErrorLogEngine
extends AbstractHandler {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String NODE_OS = "operatingSystemProperty";
    private static final String NODE_JVM = "jvmProperty";
    private static final String NODE_SYSTEM = "systemProperty";
    private static final String NODE_MONITORING = "monitoring";
    private static final String NODE_RUNTIME = "runtime";
    private static final String NODE_API_VERSION = "runtimeApiVersion";
    private static final String NODE_ENGINE_VERSION = "runtimeEngineVersion";
    private static final String NODE_SCHEDULER_VERSION = "runtimeSchedulerVersion";
    private static final String NODE_COMMON_VERSION = "runtimeCommonVersion";
    private static final String NODE_ACTION_VERSION = "runtimeActionVersion";
    private static final int BUFFER = 2048;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog fd = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        fd.setFilterExtensions(new String[]{"*.zip"});
        String fName = fd.open();
        fName = FileDialogPatch.addFileExtensionIfRequired((String)fName, (FileDialog)fd);
        if (fName == null) {
            return null;
        }
        File file = new File(fName);
        if (file.exists() && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GenerateErrorLogEngine_16, (String)Messages.bind((String)Messages.GenerateErrorLogEngine_17, (Object)file.getAbsolutePath()))) {
            return null;
        }
        ByteArrayOutputStream bos = null;
        try {
            bos = this.generateXmlDump();
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GenerateErrorLogEngine_19, (String)Messages.GenerateErrorLogEngine_20);
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.engine", ex.getMessage(), (Throwable)ex));
            return null;
        }
        File pictureFile = null;
        try {
            pictureFile = this.generatePicture();
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.engine", Messages.GenerateErrorLogEngine_21 + ex.getMessage(), (Throwable)ex));
        }
        ByteArrayOutputStream bos2 = null;
        try {
            bos2 = this.generateMonitoringInfo();
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.engine", Messages.GenerateErrorLogEngine_22 + ex.getMessage(), (Throwable)ex));
        }
        try {
            try {
                Throwable ex = null;
                Object var9_14 = null;
                try (FileOutputStream dest = new FileOutputStream(file);){
                    Throwable throwable = null;
                    Object var12_19 = null;
                    try (BufferedOutputStream buff = new BufferedOutputStream(dest);){
                        Throwable throwable2 = null;
                        Object var15_24 = null;
                        try (ZipOutputStream out = new ZipOutputStream(buff);){
                            out.setMethod(8);
                            out.setLevel(9);
                            if (pictureFile != null) {
                                GenerateErrorLogEngine.writeZipEntry(out, new FileInputStream(pictureFile), "processErrorOverview.png");
                            }
                            GenerateErrorLogEngine.writeZipEntry(out, new ByteArrayInputStream(bos.toByteArray()), "processErrorDump.xml");
                            if (bos2 != null) {
                                GenerateErrorLogEngine.writeZipEntry(out, new ByteArrayInputStream(bos2.toByteArray()), "systemInformation.xml");
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (ex == null) {
                        ex = throwable;
                    } else if (ex != throwable) {
                        ex.addSuppressed(throwable);
                    }
                    throw ex;
                }
            }
            catch (Exception ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.engine", Messages.GenerateErrorLogEngine_26 + ex.getMessage(), (Throwable)ex));
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GenerateErrorLogEngine_27, (String)(Messages.GenerateErrorLogEngine_28 + ex.getMessage()));
                if (pictureFile != null) {
                    pictureFile.delete();
                }
            }
        }
        finally {
            if (pictureFile != null) {
                pictureFile.delete();
            }
        }
        return null;
    }

    private ByteArrayOutputStream generateMonitoringInfo() throws Exception {
        Map<String, String> map = EngineGlobal.getEngine().getMonitoringSummary();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String val;
            String s;
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler hd = tf.newTransformerHandler();
            Transformer serializer = hd.getTransformer();
            serializer.setOutputProperty("indent", Messages.GenerateErrorLogEngine_29);
            PrintWriter out = new PrintWriter(bos);
            StreamResult streamResult = new StreamResult(out);
            hd.setResult(streamResult);
            hd.startDocument();
            AttributesImpl atts = new AttributesImpl();
            hd.startElement("", "", NODE_MONITORING, atts);
            hd.startElement("", "", NODE_RUNTIME, atts);
            hd.startElement("", "", NODE_API_VERSION, atts);
            String v = EngineGlobal.getEngine().getApiVersion();
            hd.characters(v.toCharArray(), 0, v.toCharArray().length);
            hd.endElement("", "", NODE_API_VERSION);
            hd.startElement("", "", NODE_ENGINE_VERSION, atts);
            v = EngineGlobal.getEngine().getEngineVersion();
            hd.characters(v.toCharArray(), 0, v.toCharArray().length);
            hd.endElement("", "", NODE_ENGINE_VERSION);
            hd.startElement("", "", NODE_SCHEDULER_VERSION, atts);
            v = EngineGlobal.getEngine().getSchedulerVersion();
            hd.characters(v.toCharArray(), 0, v.toCharArray().length);
            hd.endElement("", "", NODE_SCHEDULER_VERSION);
            hd.startElement("", "", NODE_COMMON_VERSION, atts);
            v = EngineGlobal.getEngine().getCommonVersion();
            hd.characters(v.toCharArray(), 0, v.toCharArray().length);
            hd.endElement("", "", NODE_COMMON_VERSION);
            hd.startElement("", "", NODE_ACTION_VERSION, atts);
            v = EngineGlobal.getEngine().getActionVersion();
            hd.characters(v.toCharArray(), 0, v.toCharArray().length);
            hd.endElement("", "", NODE_ACTION_VERSION);
            hd.endElement("", "", NODE_RUNTIME);
            String[] stringArray = EngineServerWrapper._JVM_INFOS;
            int n = EngineServerWrapper._JVM_INFOS.length;
            int n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                atts.clear();
                atts.addAttribute("", "", ATTRIBUTE_NAME, "", s);
                hd.startElement("", "", NODE_JVM, atts);
                val = map.get(s);
                if (val != null) {
                    hd.characters(val.toCharArray(), 0, val.toCharArray().length);
                }
                hd.endElement("", "", NODE_JVM);
                ++n2;
            }
            stringArray = EngineServerWrapper._OS_INFOS;
            n = EngineServerWrapper._OS_INFOS.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                atts.addAttribute("", "", ATTRIBUTE_NAME, "", s);
                hd.startElement("", "", NODE_OS, atts);
                val = map.get(s);
                if (val != null) {
                    hd.characters(val.toCharArray(), 0, val.toCharArray().length);
                }
                hd.endElement("", "", NODE_OS);
                ++n2;
            }
            stringArray = EngineServerWrapper._SYSTEM_INFOS;
            n = EngineServerWrapper._SYSTEM_INFOS.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                atts.addAttribute("", "", ATTRIBUTE_NAME, "", s);
                hd.startElement("", "", NODE_SYSTEM, atts);
                val = map.get(s);
                if (val != null) {
                    hd.characters(val.toCharArray(), 0, val.toCharArray().length);
                }
                hd.endElement("", "", NODE_SYSTEM);
                ++n2;
            }
            hd.endElement("", "", NODE_MONITORING);
            hd.endDocument();
        }
        return bos;
    }

    private static void writeZipEntry(ZipOutputStream out, InputStream is, String entryName) throws Exception {
        int count;
        BufferedInputStream buffi = new BufferedInputStream(is, 2048);
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        byte[] data = new byte[2048];
        while ((count = buffi.read(data, 0, 2048)) != -1) {
            out.write(data, 0, count);
        }
        out.closeEntry();
        buffi.close();
    }

    private ByteArrayOutputStream generateXmlDump() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler hd = tf.newTransformerHandler();
            Transformer serializer = hd.getTransformer();
            serializer.setOutputProperty("indent", Messages.GenerateErrorLogEngine_79);
            PrintWriter out = new PrintWriter(os);
            StreamResult streamResult = new StreamResult(out);
            hd.setResult(streamResult);
            hd.startDocument();
            Dumper d = new Dumper(EngineVariable.INSTANCE.getSessionId(), (ActionProcess)EngineVariable.INSTANCE.getSelectedDiagram().resolveSemanticElement());
            try {
                d.dumpCurrentLevel(hd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            hd.endDocument();
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return os;
    }

    private File generatePicture() throws Exception {
        CopyToImageUtil copyToImageUtil = new CopyToImageUtil();
        Path outPath = new Path("tmp_" + new Object().hashCode() + ".png");
        copyToImageUtil.copyToImage((DiagramEditPart)EngineVariable.INSTANCE.getSelectedDiagram(), (IPath)outPath, ImageFileFormat.PNG, (IProgressMonitor)new NullProgressMonitor());
        return outPath.toFile();
    }

    public static class SessionSourceProvider
    extends AbstractSourceProvider {
        public static final String SESSION_ERROR_STATE = "com.indy.ui.engine.handlers.errorLogState";
        public static final String SESSION_MATCH_EDITOR_STATE = "com.indy.ui.engine.handlers.sessionMatchEditorState";
        public static final String ENABLED = "enabled";
        public static final String DISABLED = "disabled";
        private boolean enabled = false;
        private boolean sessionMatch = false;

        public void dispose() {
        }

        public Map getCurrentState() {
            HashMap<String, String> currentState = new HashMap<String, String>(1);
            currentState.put(SESSION_ERROR_STATE, this.enabled ? ENABLED : DISABLED);
            currentState.put(SESSION_MATCH_EDITOR_STATE, this.sessionMatch ? ENABLED : DISABLED);
            return currentState;
        }

        public void setSessionErrorLogEnabled(boolean enabled) {
            if (this.enabled == enabled) {
                return;
            }
            this.enabled = enabled;
            String currentState = enabled ? ENABLED : DISABLED;
            this.fireSourceChanged(0, SESSION_ERROR_STATE, currentState);
        }

        public void setSessionMacthEditor(boolean enabled) {
            if (this.sessionMatch == enabled) {
                return;
            }
            this.sessionMatch = enabled;
            String currentState = enabled ? ENABLED : DISABLED;
            this.fireSourceChanged(0, SESSION_MATCH_EDITOR_STATE, currentState);
        }

        public String[] getProvidedSourceNames() {
            return new String[]{SESSION_ERROR_STATE, SESSION_MATCH_EDITOR_STATE};
        }
    }
}

