/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.util;

import com.indy.engine.core.common.objects2.IVariable;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.engine.Activator;
import com.indy.ui.engine.EngineGlobal;
import com.indy.ui.engine.api.ActionStatus;
import com.semarchy.xdi.designer.core.MonitorCapability;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;

public class Functions {
    public static final int ACTION_NOT_GENERATED = -1000;
    public static final int ACTION_TOLERATED_ERRORS = -1001;

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static void printVariableList(TreeMap tm) {
        TreeMap _tm = new TreeMap(tm);
        for (String aName : tm.keySet()) {
            System.out.println("---- " + aName);
            IVariable var = (IVariable)_tm.get(aName);
            System.out.println("\tValue = " + var.getValue());
            System.out.println("\tType  = " + var.getType());
        }
    }

    public static Image getImageSessionStatus(int status) {
        switch (status) {
            case 2: {
                return Activator.getImage("icons/Running16x16.png");
            }
            case 1: {
                return Activator.getImage("icons/OK1_16x16.png");
            }
            case -1: {
                return Activator.getImage("icons/Error_16x16.png");
            }
            case 9: {
                return Activator.getImage("icons/Wait16x16.png");
            }
            case 10: {
                return Activator.getImage("icons/Wait16x16.png");
            }
            case -2: {
                return Activator.getImage("icons/Killed16x16.png");
            }
            case -4: {
                return Activator.getImage("icons/Dead16x16.png");
            }
        }
        return null;
    }

    public static Image getImageActionStatus(int status, boolean toleratedError) {
        ActionStatus as = ActionStatus.getActionStatusById(status, toleratedError);
        if (as == null) {
            return null;
        }
        return as.getImage();
    }

    public static Color getColorActionStatus(int intStatus, boolean toleratedError) {
        ActionStatus as = ActionStatus.getActionStatusById(intStatus, toleratedError);
        if (as == null) {
            return ColorConstants.cyan;
        }
        return as.getColor();
    }

    public static String getFormatDate(Date date) {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").format(date).toString();
    }

    public static String getCurrrentActionId() {
        String result = null;
        if (EngineGlobal.getSelectedAction() != null) {
            result = EngineGlobal.getSelectedAction().getId();
        }
        return result;
    }

    public static String getFirstCurrrentActionId() {
        String result = null;
        if (EngineGlobal.getSelectedAction() != null) {
            result = EngineGlobal.getSelectedAction().getId();
            try {
                Map<String, Map<String, Object>> map = EngineGlobal.engine.getLstInstanciatedIds(EngineVariable.INSTANCE.getSessionId(), EngineGlobal.getSelectedAction().getId());
                if (map != null && map.size() > 0) {
                    result = map.keySet().iterator().next();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static MonitorCapability getCurrrentAction() {
        return EngineGlobal.getSelectedAction();
    }
}

