/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.variable;

import com.indy.engine.core.common.objects2.IVariable;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.custom.out.TextDialogEditor;
import com.indy.ui.engine.ClientVariable;
import com.indy.ui.engine.EngineGlobal;
import com.indy.ui.engine.EngineServerWrapper;
import com.indy.ui.engine.Messages;
import com.indy.ui.engine.session.SessionToProcessNavigatorHelper;
import com.indy.ui.engine.variable.VariableContentProvider;
import com.indy.ui.engine.variable.VariableLabelProviderMode1;
import com.indy.ui.engine.variable.VariableList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class VariableComposite
extends Composite {
    public static final int VAR_ACTION = 0;
    public static final int VAR_GLOBAL = 1;
    public static final int VAR_NUMERIC = 2;

    public VariableComposite(Composite parent, int style, VariableList list, int mode, final PopupContent contentType) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        this.setLayoutData(gridData);
        final Table tbl = new Table((Composite)this, 67584);
        final Composite _parent = parent;
        tbl.addListener(8, new Listener(){

            private void openActionInEditor(ClientVariable variable) {
                EngineServerWrapper engine = EngineGlobal.getEngine();
                if (engine != null) {
                    try {
                        String actionId;
                        String sessionId = EngineVariable.INSTANCE.getSessionId();
                        String currentActionPath = variable.getActionName();
                        if (currentActionPath != null && (actionId = engine.getActionId(sessionId, currentActionPath)) != null) {
                            SessionToProcessNavigatorHelper helper = new SessionToProcessNavigatorHelper();
                            helper.openAction(sessionId, actionId);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void handleEvent(Event event) {
                Point pt = new Point(event.x, event.y);
                TableItem item = tbl.getItem(pt);
                if (item == null) {
                    return;
                }
                String tmp = null;
                if (contentType == PopupContent.SOURCE) {
                    tmp = ((IVariable)item.getData()).getSource() != null ? ((IVariable)item.getData()).getSource() : ((IVariable)item.getData()).getValue();
                } else if (contentType == PopupContent.VALUE) {
                    tmp = ((IVariable)item.getData()).getValue() != null ? ((IVariable)item.getData()).getValue() : ((IVariable)item.getData()).getSource();
                }
                this.openActionInEditor((ClientVariable)item.getData());
                TextDialogEditor tde = new TextDialogEditor(_parent.getShell(), Messages.VariableComposite_0, ((IVariable)item.getData()).getName(), tmp, false);
                tde.open();
            }
        });
        tbl.setHeaderVisible(true);
        gridData = new GridData();
        gridData.heightHint = 100;
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        tbl.setLayoutData((Object)gridData);
        tbl.setLinesVisible(true);
        TableViewer viewer = new TableViewer(tbl);
        viewer.setContentProvider((IContentProvider)new VariableContentProvider(list, viewer));
        switch (mode) {
            case 0: {
                VariableComposite.configureVariableTableMode1(tbl);
                viewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProviderMode1(false));
                break;
            }
            case 1: {
                this.configureVariableTableMode2(tbl);
                viewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProviderMode1(true));
                break;
            }
            case 2: {
                this.configureVariableTableMode3(tbl);
                viewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProviderMode1(false));
            }
        }
        viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                IVariable var1 = (IVariable)o1;
                IVariable var2 = (IVariable)o2;
                if (var1 != null && var1.getName() != null && var2 != null && var2.getName() != null) {
                    return var1.getName().compareTo(var2.getName());
                }
                return 0;
            }
        });
        viewer.setInput((Object)list);
    }

    private void configureVariableTableMode2(Table tbl) {
        TableColumn statColumn3 = new TableColumn(tbl, 0);
        statColumn3.setText(Messages.VariableComposite_1);
        statColumn3.setWidth(250);
        TableColumn statColumn2 = new TableColumn(tbl, 0);
        statColumn2.setText(Messages.VariableComposite_2);
        statColumn2.setWidth(250);
    }

    private void configureVariableTableMode3(Table tbl) {
        TableColumn statColumn3 = new TableColumn(tbl, 0);
        statColumn3.setText(Messages.VariableComposite_3);
        statColumn3.setWidth(175);
        TableColumn statColumn2 = new TableColumn(tbl, 0);
        statColumn2.setText(Messages.VariableComposite_4);
        statColumn2.setWidth(75);
        statColumn2.setAlignment(131072);
    }

    public static void configureVariableTableMode1(Table tbl) {
        TableColumn statColumn = new TableColumn(tbl, 0);
        statColumn.setText(Messages.VariableComposite_5);
        statColumn.setWidth(250);
        TableColumn statColumn2 = new TableColumn(tbl, 0);
        statColumn2.setText(Messages.VariableComposite_6);
        statColumn2.setWidth(250);
        TableColumn statColumn1 = new TableColumn(tbl, 0);
        statColumn1.setText(Messages.VariableComposite_7);
        statColumn1.setWidth(75);
    }

    public static enum PopupContent {
        SOURCE,
        VALUE;

    }
}

