/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.view;

import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.ui.custom.out.INoPropertySheetProvider;
import com.indy.ui.engine.EngineGlobal;
import com.indy.ui.engine.handlers.GenerateErrorLogEngine;
import com.indy.ui.engine.session.SessionsOfEngine;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.ISourceProviderService;

public class ListSessionView
extends ViewPart
implements ISelectionChangedListener,
INoPropertySheetProvider {
    public static final String ID = "com.indy.ui.custom.session.ListSessionView";
    private SessionsOfEngine sessionsOfEngine;

    public void createPartControl(Composite parent) {
        this.setTitleToolTip(this.getTitle());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.indy.ui.help.redirects/designer/session-view");
        this.sessionsOfEngine = new SessionsOfEngine(parent, 4);
        this.hookContextMenu();
        this.sessionsOfEngine.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.sessionsOfEngine.getTableViewer());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        boolean enable;
        IStructuredSelection ss = (IStructuredSelection)event.getSelection();
        boolean bl = enable = !ss.isEmpty();
        if (enable && ss.getFirstElement() instanceof ISessionDataExchange) {
            enable = enable && ((ISessionDataExchange)ss.getFirstElement()).getStatus() == -1;
        }
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISourceProviderService service = (ISourceProviderService)win.getService(ISourceProviderService.class);
        GenerateErrorLogEngine.SessionSourceProvider sessionSourceProvider = (GenerateErrorLogEngine.SessionSourceProvider)service.getSourceProvider("com.indy.ui.engine.handlers.errorLogState");
        sessionSourceProvider.setSessionErrorLogEnabled(enable);
        EngineGlobal.watchEngine.checkError4Session();
    }

    public void dispose() {
        this.sessionsOfEngine.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.sessionsOfEngine.setFocus();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ListSessionView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.sessionsOfEngine.getTableViewer().getControl());
        this.sessionsOfEngine.getTableViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu("com.indy.ui.MdTreeViewer", menuMgr, (ISelectionProvider)this.sessionsOfEngine.getTableViewer());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }
}

