/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.indy.administration.AdministrationHelper;
import com.semarchy.xdi.designer.core.CacheCapability;
import com.semarchy.xdi.designer.core.Constants;
import com.semarchy.xdi.designer.core.indexation.IndexationRegisterExtension;
import com.semarchy.xdi.designer.core.models.IndyResourceUtil;
import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.models.OutdatedModelDiagnostic;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.CacheDuplicateException;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.internal.FastResolverCrossReferencer;
import com.semarchy.xdi.designer.index.internal.LoadSourceException;
import com.semarchy.xdi.designer.index.internal.Messages;
import com.semarchy.xdi.designer.index.internal.NoResourceException;
import com.semarchy.xdi.designer.index.model.Elt;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.model.StateType;
import com.semarchy.xdi.designer.index.model.Super;
import com.semarchy.xdi.designer.index.model.impl.SourceImpl;
import com.semarchy.xdi.designer.index.model.impl.SuperImpl;
import com.semarchy.xdi.designer.index.parsers.StaxFastResourceLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.log.LogService;

public class EMFAnalyzer {
    private CacheImpl cache;
    private IRegistryService registryService;
    private Logger logger = LogManager.getLogger(EMFAnalyzer.class);

    private static boolean hasParentSegment(URI path, String parent) {
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (parent.equals(segment)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isExcludeResourceForReference(Resource resource) {
        return resource.getURI().segment(2).equals(Constants.indyWorkBuildDirectoryName) || EMFAnalyzer.hasParentSegment(resource.getURI(), Constants.indyWorkDiagramDirectoryName);
    }

    public static Resource loadOrReload(ResourceSet cacheResourceSet, URI uri) throws WrappedException, IOException {
        Resource re = null;
        if (uri.isPlatformResource() && "tech".equals(uri.fileExtension()) && !AdministrationHelper.supportTechModelFromWorkspace()) {
            throw new WrappedException(new Exception(Messages.EMFAnalyzer_1));
        }
        re = cacheResourceSet.getResource(uri, false);
        if (re == null) {
            re = cacheResourceSet.getResource(uri, true);
        } else {
            if (re.isLoaded()) {
                re.unload();
            }
            if (re instanceof IndyResourceUtil.IndyResource && ((IndyResourceUtil.IndyResource)re).getIntrinsicIDToEObjectMap() != null) {
                ((IndyResourceUtil.IndyResource)re).setIntrinsicIDToEObjectMap(new TreeMap());
            }
            re = cacheResourceSet.getResource(uri, true);
        }
        return re;
    }

    protected EMFAnalyzer(CacheImpl cache, IRegistryService registryService) {
        this.cache = cache;
        this.registryService = registryService;
    }

    private Resource getCacheResource() {
        return this.cache.getCacheResource();
    }

    private ResourceSet getCacheResourceSet() {
        return this.cache.getRs();
    }

    private Super getSuper() {
        return this.cache.getSuper();
    }

    private void refreshRegistries(Source source, IRegistryService.IRegistrationContribution resource) {
        block14: {
            source.getContributedRegistry().clear();
            for (Class c : resource.getContributedRegistries()) {
                source.getContributedRegistry().add((Object)c.getName());
            }
            try {
                List l;
                List l2;
                IRegistryService.IRegistry reg;
                String disabledFileIds = (String)source.getRemark().get((Object)"com.indy.emf.uri.remark.udfDisabledId");
                String oldPrefix = null;
                if (disabledFileIds != null && source.getContributedRegistry().contains((Object)UDF.class.getName()) && (reg = this.registryService.getRegistry(UDF.class)) != null && (l2 = reg.find((IRegistryService.IRegistryMatcher)new UDF.UDFProviderMatcher(source.getId()))) != null && !l2.isEmpty()) {
                    oldPrefix = ((UDF.UDFKey)((UDF)l2.get(0)).getRegistrationKey()).getPrefix();
                }
                this.registryService.updateObjectsFrom(resource);
                this.unflagSourceAsDisabled(source);
                if (disabledFileIds == null || disabledFileIds.trim().isEmpty() || oldPrefix == null) break block14;
                String newPrefix = null;
                IRegistryService.IRegistry reg2 = this.registryService.getRegistry(UDF.class);
                if (reg2 != null && (l = reg2.find((IRegistryService.IRegistryMatcher)new UDF.UDFProviderMatcher(source.getId()))) != null && !l.isEmpty()) {
                    newPrefix = ((UDF.UDFKey)((UDF)l.get(0)).getRegistrationKey()).getPrefix();
                }
                if (oldPrefix.equals(newPrefix)) break block14;
                String[] stringArray = disabledFileIds.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    Source disabledSource = this.getSuper().getSource(s);
                    if (disabledSource != null && disabledSource.getState() == StateType.SYNCHRO) {
                        try {
                            Resource disabledResource = EMFAnalyzer.loadOrReload(this.getCacheResourceSet(), disabledSource.getURI());
                            if (disabledResource instanceof IRegistryService.IRegistrationContribution) {
                                this.refreshRegistries(disabledSource, (IRegistryService.IRegistrationContribution)disabledResource);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
            catch (CacheDuplicateException e) {
                this.registryService.unregisterObjectsFrom(source.getId());
                Source original = this.getSuper().getSource(e.getExistingSourceURI());
                if (original != null) {
                    if (original != source) {
                        source.flagAsDisabledBy(original);
                    }
                } else {
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.semarchy.designer.index").error(NLS.bind((String)Messages.EMFAnalyzer_34, (Object)e.getExistingSourceURI().toPlatformString(true)), (Object)e);
                }
            }
            catch (Exception e) {
                this.logger.error("unexpected", (Throwable)e);
            }
        }
    }

    private void resolveSource(Source s, Resource re) {
        if (s.getElt().isEmpty()) {
            return;
        }
        if (s.getURI() != null) {
            ArrayList<Elt> list = new ArrayList<Elt>((Collection<Elt>)s.getElt());
            for (Elt elt : list) {
                this.resolveElt(elt, re);
            }
        }
    }

    private void resolveAll(Resource resource) {
        TreeIterator i = resource.getAllContents();
        while (i.hasNext()) {
            i.next();
        }
    }

    private void updateRef(Source s, Resource re) throws Exception {
        block30: {
            try {
                if (!EMFAnalyzer.isExcludeResourceForReference(re)) {
                    if (s.getState() == null || !s.getState().equals((Object)StateType.SYNCHRO) && s.getURI() != null) {
                        for (Elt elt : s.getElt()) {
                            elt.getReference().clear();
                        }
                    }
                    s.getMandatoryElt().clear();
                    if (re == null || s.getURI() == null) break block30;
                    this.resolveAll(re);
                    EObject root = EMFResourceUtil.getFirstElement((Resource)re);
                    FastResolverCrossReferencer crossRef = new FastResolverCrossReferencer(this.cache, s.getId(), root);
                    Map map = crossRef.findExternalCrossReferences();
                    HashSet<EObject> handled = new HashSet<EObject>();
                    crossRef.fastResolve();
                    for (Object ob : map.keySet()) {
                        InternalEObject idObject = (InternalEObject)ob;
                        Collection o = (Collection)map.get(idObject);
                        for (EStructuralFeature.Setting set : o) {
                            EObject refObject = set.getEObject();
                            boolean ok = true;
                            boolean hasNoId = false;
                            if (refObject instanceof CacheCapability) {
                                if (((CacheCapability)refObject).isToCache()) {
                                    hasNoId = ((CacheCapability)refObject).elementHasNoId();
                                } else {
                                    ok = false;
                                }
                            }
                            if (hasNoId) {
                                refObject = refObject.eContainer();
                            }
                            if (refObject == null || refObject.eResource() == null || refObject == null || refObject.eResource() == null || !ok || !IndexationRegisterExtension.EXTENSION_MANAGER.isAvailableRelation2(set.getEStructuralFeature(), refObject)) continue;
                            try {
                                Elt idElt = this.getSuper().getOrCreateElt((EObject)idObject);
                                Elt refElt = this.getSuper().getOrCreateElt(refObject);
                                refElt.setState(StateType.EXISTS);
                                if (!refElt.getReference().contains((Object)idElt)) {
                                    refElt.getReference().add((Object)idElt);
                                }
                                handled.add(refObject);
                            }
                            catch (NoResourceException ex) {
                                String refId = null;
                                try {
                                    refId = EcoreUtil.getURI((EObject)refObject).fragment();
                                }
                                catch (Exception ex2) {
                                    refId = refObject.toString();
                                }
                                throw new NoResourceException(String.format(Messages.EMFAnalyzer_0, refId, set.getEStructuralFeature().eClass().getName(), set.getEStructuralFeature().getName()));
                            }
                        }
                    }
                    for (Elt elt : s.getElt()) {
                        if (!((IndyXMLResource)re).getId().equals(s.getId())) continue;
                        EObject o = re.getEObject(elt.getRealId());
                        if (o == null) {
                            elt.setState(StateType.INEXISTENT);
                            continue;
                        }
                        elt.setState(StateType.EXISTS);
                        SuperImpl.updateEltLevelCode(o, elt);
                        handled.add(o);
                    }
                    for (EObject mandatoryRefproxy : crossRef.getMandatoryRefProxy()) {
                        if (mandatoryRefproxy == null) continue;
                        s.getMandatoryElt().add((Object)this.getSuper().getOrCreateElt(mandatoryRefproxy));
                    }
                    TreeIterator it = re.getAllContents();
                    while (it.hasNext()) {
                        EObject o = (EObject)it.next();
                        if (!IndexationRegisterExtension.EXTENSION_MANAGER.isIndexable(o) || handled.contains(o)) continue;
                        this.getSuper().getOrCreateElt(o);
                    }
                    EObject mainMandatoryRefProxy = crossRef.getMainMandatoryRefProxy();
                    if (mainMandatoryRefProxy == null) {
                        s.setMainReference(null);
                    } else {
                        Elt elt = this.getSuper().getOrCreateElt(mainMandatoryRefProxy);
                        s.setMainReference(elt);
                    }
                    s.setState(StateType.SYNCHRO);
                    s.setLastScan((XMLGregorianCalendar)new XMLCalendar(new Date(), 0));
                    this.getCacheResource().setModified(true);
                    break block30;
                }
                s.setState(StateType.SYNCHRO);
                s.setLastScan((XMLGregorianCalendar)new XMLCalendar(new Date(), 0));
                this.getCacheResource().setModified(true);
            }
            finally {
                if (re instanceof IRegistryService.IRegistrationContribution) {
                    this.refreshRegistries(s, (IRegistryService.IRegistrationContribution)re);
                }
                if (re != null) {
                    TransactionalEditingDomain editingDomain;
                    ResourceSet rs = re.getResourceSet();
                    if (rs != null && (editingDomain = TransactionUtil.getEditingDomain((ResourceSet)rs)) != null) {
                        editingDomain.getCommandStack().flush();
                    }
                    try {
                        re.unload();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void resolveElt(Elt elt, Resource re) {
        Source s = null;
        if (elt.getSource() != null) {
            s = elt.getSource();
        }
        if ((elt.getUsage() == null || elt.getUsage().isEmpty()) && (elt.getReference() == null || elt.getReference().isEmpty()) && elt.getDependantSource().isEmpty()) {
            this.getSuper().removeElt(elt);
        } else {
            try {
                re = this.getCacheResourceSet().getResource(s.getURI(), true);
            }
            catch (WrappedException ex) {
                this.logger.error("Failed to load {}", (Object)elt.getSource().getURI(), (Object)ex);
            }
            EObject eo = null;
            if (s != null && re != null && (eo = re.getEObject(elt.getRealId())) != null) {
                elt.setState(StateType.EXISTS);
                SuperImpl.updateEltLevelCode(eo, elt);
                elt.setInfo(null);
            } else {
                elt.setState(StateType.INEXISTENT);
            }
        }
    }

    private Date getMappingBuiltDate(URI mappingURI) {
        if (!"map".equals(mappingURI.fileExtension())) {
            return null;
        }
        Collection l = URIUtils.getMappingBuiltFiles((URI)mappingURI.trimFragment(), (XDIModelURIResolver)this.cache.modelProvider, (boolean)false).stream().filter(u -> this.cache.modelProvider.exists(u)).collect(Collectors.toList());
        long modifTime = -1L;
        if (l.size() >= 2) {
            boolean hasProc = false;
            boolean hasMd = false;
            for (URI b : l) {
                if ("proc".equals(b.fileExtension())) {
                    hasProc = true;
                }
                if ("md".equals(b.fileExtension()) && mappingURI.trimFileExtension().lastSegment().equals(b.trimFileExtension().lastSegment())) {
                    hasMd = true;
                }
                modifTime = Math.max(this.cache.modelProvider.resolve(b).lastModified(), modifTime);
            }
            if (!hasMd || !hasProc) {
                return null;
            }
            if (modifTime >= this.cache.modelProvider.resolve(mappingURI).lastModified()) {
                return new Date(modifTime);
            }
        }
        return null;
    }

    public Source create(URI resourceURI) throws LoadSourceException, WrappedException, IOException, Exception {
        Source s = null;
        Resource re = null;
        WrappedException parseException = null;
        try {
            re = EMFAnalyzer.loadOrReload(this.getCacheResourceSet(), resourceURI);
        }
        catch (WrappedException ex) {
            if (ex.getCause() instanceof XMIException && ex.getCause().getClass() != XMIException.class) {
                re = this.getCacheResourceSet().getResource(resourceURI, false);
                parseException = ex;
            }
            throw ex;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(Messages.EMFAnalyzer_46 + String.valueOf(resourceURI), t);
        }
        String ID = EMFResourceUtil.getFirstId((Resource)re);
        if (ID == null) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_47, (Object)resourceURI.toPlatformString(true)));
        }
        s = this.getSuper().getSource(ID);
        if (s != null && s.getState() != StateType.INEXISTENT) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_49, (Object)ID));
        }
        if (s == null && (s = this.getSuper().getSource(re.getURI())) != null && s.getState() != StateType.INEXISTENT && s.getState() != StateType.DUPLICATE) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_51, (Object)ID));
        }
        if (s == null) {
            s = this.getSuper().addSource(ID, re.getURI(), this.getMappingBuiltDate(re.getURI()));
        } else {
            s.setURI(resourceURI);
            s.setState(StateType.EXISTS);
            s.setId(ID);
            s.getDuplicates().clear();
            s.setOverridenPluginUri(null);
        }
        s.setDateFile((XMLGregorianCalendar)this.getCalendar(re));
        s.setState(StateType.EXISTS);
        this.updateInternalVersion(re, s);
        this.resolveAndUpdate(s, re);
        this.getSuper().cleanSource(s);
        this.getCacheResource().setModified(true);
        if (parseException != null) {
            throw new LoadSourceException(s, parseException);
        }
        return s;
    }

    private XMLCalendar getCalendar(Resource re) {
        if (re != null) {
            if (re.getURI().isPlatformPlugin()) {
                return ICacheService.calendar;
            }
            Long t = this.cache.modelProvider.resolve(re.getURI()).lastModified();
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(t);
            return new XMLCalendar(gc.getTime(), 0);
        }
        return null;
    }

    public Source duplicate(String duplicatedSourceID, URI duplicateURI, URI resource, XMLCalendar resourceModificationDate) throws Exception {
        Source source = this.getSuper().getSource(duplicatedSourceID);
        if (source == null) {
            throw new OperationDeniedByCacheInconsistencyException(NLS.bind((String)Messages.EMFAnalyzer_53, (Object)duplicatedSourceID));
        }
        if (source.getState() != StateType.SYNCHRO) {
            throw new OperationDeniedByCacheInconsistencyException(NLS.bind((String)Messages.EMFAnalyzer_55, (Object)duplicatedSourceID));
        }
        Source duplicate = this.getSuper().getSource(duplicateURI);
        if (duplicate == null) {
            duplicate = this.getSuper().addSource(duplicatedSourceID, duplicateURI, null);
        } else if (!duplicate.getId().equals(duplicatedSourceID)) {
            if (duplicate.getState() == StateType.INEXISTENT) {
                duplicate.setId(duplicatedSourceID);
            } else {
                throw new OperationDeniedByCacheInconsistencyException(Messages.EMFAnalyzer_57);
            }
        }
        if (!duplicate.getElt().isEmpty()) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.EMFAnalyzer_58);
        }
        duplicate.setDateFile((XMLGregorianCalendar)resourceModificationDate);
        duplicate.setOverridenPluginUri(source.getOverridenPluginUri());
        duplicate.setState(StateType.DUPLICATE);
        if (!duplicate.getDuplicates().isEmpty()) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_59, (Object)duplicateURI.toPlatformString(true)));
        }
        source.getDuplicates().add((Object)duplicate);
        return duplicate;
    }

    public Source remove(String sourceID) throws OperationDeniedByCacheInconsistencyException {
        Source source = this.getSuper().getSource(sourceID);
        if (source == null) {
            throw new OperationDeniedByCacheInconsistencyException(NLS.bind((String)Messages.EMFAnalyzer_61, (Object)sourceID));
        }
        if (!source.getDuplicates().isEmpty()) {
            throw new OperationDeniedByCacheInconsistencyException(NLS.bind((String)Messages.EMFAnalyzer_63, (Object)sourceID));
        }
        if (source.getState() != StateType.SYNCHRO) {
            throw new OperationDeniedByCacheInconsistencyException(NLS.bind((String)Messages.EMFAnalyzer_65, (Object)sourceID));
        }
        ArrayList<Source> usage = new ArrayList<Source>();
        for (Elt elt : source.getElt()) {
            for (Elt u : elt.getUsage()) {
                if (usage.contains(u.getSource())) continue;
                usage.add(u.getSource());
            }
        }
        source.getMandatoryElt().clear();
        source.setOverridenPluginUri(null);
        source.setState(StateType.INEXISTENT);
        source.setLastBuildAttempt(null);
        source.setLastScan(null);
        this.unflagSourceAsDisabled(source);
        Super sup = this.cache.getSuper();
        if (source.getElt().isEmpty()) {
            sup.removeSource(source);
        }
        this.registryService.unregisterObjectsFrom(sourceID);
        for (Source u : usage) {
            try {
                this.update(u.getURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return source;
    }

    public Source update(URI resourceURI) throws LoadSourceException, WrappedException, IOException, Exception {
        Source s = null;
        Resource re = null;
        WrappedException parseException = null;
        try {
            re = EMFAnalyzer.loadOrReload(this.getCacheResourceSet(), resourceURI);
        }
        catch (WrappedException ex) {
            if (ex.getCause() instanceof XMIException && ex.getCause().getClass() != XMIException.class) {
                re = this.getCacheResourceSet().getResource(resourceURI, false);
                parseException = ex;
            }
            throw ex;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(Messages.EMFAnalyzer_67 + String.valueOf(resourceURI), t);
        }
        s = this.getSuper().getSource(resourceURI);
        if (s == null) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_68, (Object)resourceURI.toPlatformString(true)));
        }
        String ID = EMFResourceUtil.getFirstId((Resource)re);
        if (!ID.equals(s.getId())) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_70, (Object)resourceURI.toPlatformString(true)));
        }
        s.setDateFile((XMLGregorianCalendar)this.getCalendar(re));
        s.setState(StateType.EXISTS);
        if (s != null) {
            this.updateInternalVersion(re, s);
        }
        this.resolveAndUpdate(s, re);
        this.getSuper().cleanSource(s);
        this.getCacheResource().setModified(true);
        if (parseException != null) {
            throw new LoadSourceException(s, parseException);
        }
        return s;
    }

    public Source load(URI uri) throws Exception {
        Source s = null;
        s = this.cache.getSuper().getSource(uri);
        if (s == null || !s.getState().equals((Object)StateType.SYNCHRO)) {
            Resource re = null;
            String ID = null;
            try {
                StaxFastResourceLoader loader = new StaxFastResourceLoader();
                ID = loader.fastParse(uri);
            }
            catch (Exception e) {
                try {
                    re = EMFAnalyzer.loadOrReload(this.cache.getRs(), uri);
                    ID = EMFResourceUtil.getFirstId((Resource)re);
                }
                catch (WrappedException ex) {
                    if (ex.getCause() instanceof XMIException && ex.getCause().getClass() != XMIException.class) {
                        re = this.cache.getRs().getResource(uri, false);
                    } else {
                        this.logger.error("unexpected error on {}", (Object)uri, (Object)ex);
                    }
                    ID = EMFResourceUtil.getFirstId((Resource)re);
                }
            }
            if (ID != null) {
                if ((s = s != null && !s.getId().equals(ID) ? null : this.cache.getSuper().getSource(ID)) != null) {
                    this.cache.getSuper().cleanSource(s);
                    s.setURI(uri);
                    s.setDateFile((XMLGregorianCalendar)ICacheService.calendar);
                } else {
                    s = this.cache.getSuper().addSource(ID, uri, this.getMappingBuiltDate(uri));
                    s.setDateFile((XMLGregorianCalendar)ICacheService.calendar);
                }
                this.cache.getCacheResource().setModified(true);
            } else {
                this.logger.warn("unreadable model id from {}", (Object)uri);
            }
        }
        return s;
    }

    public Source move(URI oldURI, URI newURI) throws OperationDeniedByCacheInconsistencyException {
        Source s = this.cache.getSuper().getSource(oldURI);
        if (s == null) {
            throw new OperationDeniedByCacheInconsistencyException(NLS.bind((String)Messages.EMFAnalyzer_90, (Object)oldURI.toPlatformString(true)));
        }
        s.setURI(newURI);
        this.getCacheResource().setModified(true);
        return s;
    }

    public Source override(String sourceId, URI newURI, URI overridenURI) throws LoadSourceException, IOException, Exception {
        Source source = this.getSuper().getSource(sourceId);
        if (source == null) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_92, (Object)sourceId));
        }
        if (source.getState() != StateType.SYNCHRO) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_94, (Object)sourceId));
        }
        if (!overridenURI.isPlatformPlugin() || !"com.indy.environment".equals(overridenURI.segment(1))) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_97, (Object)sourceId));
        }
        Resource re = null;
        WrappedException parseException = null;
        try {
            re = EMFAnalyzer.loadOrReload(this.getCacheResourceSet(), newURI);
        }
        catch (WrappedException ex) {
            if (ex.getCause() instanceof XMIException && ex.getCause().getClass() != XMIException.class) {
                re = this.getCacheResourceSet().getResource(newURI, false);
                parseException = ex;
            }
            throw ex;
        }
        catch (Throwable t) {
            throw new IOException(Messages.EMFAnalyzer_99 + String.valueOf(newURI), t);
        }
        String ID = EMFResourceUtil.getFirstId((Resource)re);
        if (!ID.equals(source.getId())) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_100, (Object)newURI.toPlatformString(true)));
        }
        source.setState(StateType.EXISTS);
        source.setOverridenPluginUri(overridenURI.toString());
        source.setURI(newURI);
        source.setDateFile((XMLGregorianCalendar)this.getCalendar(re));
        this.updateInternalVersion(re, source);
        this.resolveAndUpdate(source, re);
        this.getSuper().cleanSource(source);
        this.getCacheResource().setModified(true);
        if (parseException != null) {
            throw new LoadSourceException(source, parseException);
        }
        return source;
    }

    public Source restore(String sourceId, URI internalResourceURI) throws LoadSourceException, IOException, Exception {
        Source source = this.getSuper().getSource(sourceId);
        if (source == null) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_102, (Object)sourceId));
        }
        if (source.getState() != StateType.SYNCHRO) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_104, (Object)sourceId));
        }
        URI resourceURI = source.getURI();
        if (!resourceURI.isPlatformResource()) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_106, (Object)sourceId));
        }
        source.setState(StateType.EXISTS);
        source.setOverridenPluginUri(null);
        source.setURI(internalResourceURI);
        Resource re = null;
        WrappedException parseException = null;
        try {
            re = EMFAnalyzer.loadOrReload(this.getCacheResourceSet(), internalResourceURI);
        }
        catch (WrappedException ex) {
            if (ex.getCause() instanceof XMIException && ex.getCause().getClass() != XMIException.class) {
                re = this.getCacheResourceSet().getResource(internalResourceURI, false);
                parseException = ex;
            }
            throw ex;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(Messages.EMFAnalyzer_108 + String.valueOf(internalResourceURI), t);
        }
        String ID = EMFResourceUtil.getFirstId((Resource)re);
        if (!ID.equals(source.getId())) {
            throw new OperationDeniedByCacheInconsistencyException(NLS.bind((String)Messages.EMFAnalyzer_109, (Object)resourceURI.toPlatformString(true)));
        }
        source.setDateFile((XMLGregorianCalendar)ICacheService.calendar);
        this.updateInternalVersion(re, source);
        this.resolveAndUpdate(source, re);
        this.getSuper().cleanSource(source);
        this.getCacheResource().setModified(true);
        if (parseException != null) {
            throw new LoadSourceException(source, parseException);
        }
        return source;
    }

    public Source replace(String sourceID, URI replacementURI) throws LoadSourceException, IOException, Exception {
        Source source = this.getSuper().getSource(sourceID);
        if (source == null) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_111, (Object)sourceID));
        }
        if (source.getState() != StateType.SYNCHRO) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_113, (Object)sourceID));
        }
        URI resourceURI = source.getURI();
        if (!resourceURI.isPlatformResource()) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_115, (Object)sourceID));
        }
        Source replacement = this.getSuper().getSource(replacementURI);
        if (!(replacement.getId().equals(sourceID) || replacement.getState() == StateType.DUPLICATE && replacement.getContributedRegistry().contains((Object)"com.indy.ui.custom.out.udf.UDF") && source.getContributedRegistry().contains((Object)"com.indy.ui.custom.out.udf.UDF"))) {
            throw new OperationDeniedByCacheInconsistencyException(NLS.bind((String)Messages.EMFAnalyzer_119, (Object)sourceID));
        }
        ArrayList<Source> usage = new ArrayList<Source>();
        for (Elt elt : source.getElt()) {
            for (Elt u : elt.getUsage()) {
                if (usage.contains(u.getSource())) continue;
                usage.add(u.getSource());
            }
        }
        Resource re = null;
        WrappedException parseException = null;
        try {
            re = EMFAnalyzer.loadOrReload(this.getCacheResourceSet(), replacementURI);
        }
        catch (WrappedException ex) {
            if (ex.getCause() instanceof XMIException && ex.getCause().getClass() != XMIException.class) {
                re = this.getCacheResourceSet().getResource(replacementURI, false);
                parseException = ex;
            }
            throw ex;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(Messages.EMFAnalyzer_121 + String.valueOf(replacementURI), t);
        }
        String ID = EMFResourceUtil.getFirstId((Resource)re);
        if (!(ID.equals(source.getId()) || replacement.getState() == StateType.DUPLICATE && replacement.getContributedRegistry().contains((Object)"com.indy.ui.custom.out.udf.UDF") && source.getContributedRegistry().contains((Object)"com.indy.ui.custom.out.udf.UDF"))) {
            throw new OperationDeniedByCacheInconsistencyException(Messages.bind((String)Messages.EMFAnalyzer_124, (Object)sourceID));
        }
        source.setState(StateType.DUPLICATE);
        source.getRemark().removeKey((Object)"com.indy.emf.uri.remark.udfActiveId");
        source.getRemark().removeKey((Object)"com.indy.emf.uri.remark.udfDisabledId");
        replacement.setState(StateType.EXISTS);
        replacement.setURI(replacementURI);
        replacement.setOverridenPluginUri(source.getOverridenPluginUri());
        replacement.setDateFile((XMLGregorianCalendar)this.getCalendar(re));
        this.updateInternalVersion(re, replacement);
        ArrayList<Elt> elts = new ArrayList<Elt>((Collection<Elt>)source.getElt());
        for (Elt e : elts) {
            e.setSource(replacement);
        }
        source.getElt().clear();
        replacement.getElt().addAll(elts);
        this.registryService.unregisterObjectsFrom(source.getId());
        this.resolveAndUpdate(replacement, re);
        this.getSuper().cleanSource(replacement);
        source.getDuplicates().remove((Object)replacement);
        replacement.getDuplicates().add((Object)source);
        replacement.getDuplicates().addAll(source.getDuplicates());
        source.getDuplicates().clear();
        for (Source u : usage) {
            try {
                this.update(u.getURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getCacheResource().setModified(true);
        if (parseException != null) {
            throw new LoadSourceException(source, parseException);
        }
        return replacement;
    }

    private void updateInternalVersion(Resource resource, Source source) {
        Object v;
        boolean outdated = false;
        EObject root = (EObject)((EObject)resource.getContents().get(0)).eContents().get(0);
        EStructuralFeature f = root.eClass().getEStructuralFeature("internalVersion");
        String internalVersion = null;
        if (f != null && (v = root.eGet(f)) != null) {
            internalVersion = v instanceof String ? (String)v : v.toString();
        }
        source.setInternalVersion(internalVersion);
        for (Resource.Diagnostic d : resource.getWarnings()) {
            if (!(d instanceof OutdatedModelDiagnostic)) continue;
            source.setOutdated(true);
            outdated = true;
            break;
        }
        if (!outdated && source.isOutdated()) {
            source.setOutdated(false);
        }
    }

    public Source deleteDuplicate(String sourceID, URI currentURI) throws OperationDeniedByCacheInconsistencyException {
        Source source = this.getSuper().getSource(sourceID);
        for (Source s : source.getDuplicates()) {
            if (!s.getURI().equals(currentURI)) continue;
            s.setState(StateType.INEXISTENT);
            source.getDuplicates().remove((Object)s);
            this.unflagSourceAsDisabled(s);
            source.getRemark().keySet().remove("com.indy.emf.uri.remark.udfDisabledId");
            SourceImpl.REGISTRY.removeUriMap(currentURI);
            s.setOverridenPluginUri(null);
            this.getSuper().cleanSource(s);
            this.getCacheResource().setModified(true);
            if (!s.getElt().isEmpty()) {
                throw new OperationDeniedByCacheInconsistencyException(Messages.EMFAnalyzer_126);
            }
            return s;
        }
        return null;
    }

    private void resolveAndUpdate(Source source, Resource re) throws Exception {
        if (re instanceof XMLResourceImpl) {
            if (!((XMLResourceImpl)re).getEObjectToExtensionMap().isEmpty()) {
                ArrayList<String> ids = new ArrayList<String>();
                for (EObject key : ((XMLResourceImpl)re).getEObjectToExtensionMap().keySet()) {
                    String id = ((IndyXMLResource)re).getURIFragment(key);
                    if (id == null || (id = CacheHelper.extractEltID((String)id)) == null) continue;
                    ids.add(id);
                }
                Collections.sort(ids);
                StringBuffer buf = new StringBuffer();
                for (String s : ids) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(s);
                }
                source.getRemark().put((Object)"com.stambia.resource.marker.featureNotFound", (Object)(Messages.EMFAnalyzer_4 + buf.toString()));
            } else {
                source.getRemark().remove((Object)"com.stambia.resource.marker.featureNotFound");
            }
            this.getSuper().getCacheState().updateFeatureNotFound(source);
        }
        if (!EMFAnalyzer.isExcludeResourceForReference(re)) {
            this.resolveSource(source, re);
        }
        if (!re.isLoaded()) {
            re = this.getCacheResourceSet().getResource(source.getURI(), true);
        }
        try {
            this.updateRef(source, re);
        }
        catch (NoResourceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void unflagSourceAsDisabled(Source s) {
        String activeId = (String)s.getRemark().removeKey((Object)"com.indy.emf.uri.remark.udfActiveId");
        s.unflagAsDisabled(this.cache.getSuper().getSource(activeId));
    }

    public static class OperationDeniedByCacheInconsistencyException
    extends Exception {
        OperationDeniedByCacheInconsistencyException(String message) {
            super(message);
        }
    }
}

