/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.indy.administration.AdministrationHelper;
import com.semarchy.xdi.designer.core.services.IComponentService;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.index.internal.InternalResourceFolderRegistry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class InternalResourceFolder
implements IInternalResourceRegistry.InternalResourceProvider {
    private String bundlePath;
    private String[] extensions;
    private String internalResourcePath;
    private String bundleName;
    private Map<URI, URI> deployedURIResources = new HashMap<URI, URI>();
    private boolean fileGenerated = false;
    private String resourceImportPath;
    private IComponentService.IComponent component;

    public InternalResourceFolder(IComponentService.IComponent component, String bundleName, String bundlePath, String[] extensions, String internalResourcePath, String resourceImportPath) throws Exception {
        this.bundlePath = bundlePath;
        this.extensions = extensions;
        this.internalResourcePath = internalResourcePath;
        this.bundleName = bundleName;
        this.resourceImportPath = resourceImportPath;
        this.component = component;
        this.detectInternalResourceURI();
    }

    public String getInternalResourcePath() {
        return this.internalResourcePath;
    }

    protected Set<URI> getFilesURI() {
        return this.deployedURIResources.keySet();
    }

    private void detectInternalResourceURI() {
        Bundle bundle = Platform.getBundle((String)this.bundleName);
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ArrayList l = new ArrayList();
        if (this.extensions == null) {
            l.addAll(wiring.listResources(this.bundlePath, "*", 1));
        } else {
            String[] stringArray = this.extensions;
            int n = this.extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                l.addAll(wiring.listResources(this.bundlePath, "*." + s, 1));
                ++n2;
            }
        }
        for (String name : l) {
            StringBuffer b = null;
            boolean isTranslation = name.endsWith("." + Platform.getNL() + ".ext");
            b = isTranslation ? new StringBuffer(this.bundleName) : new StringBuffer("com.indy.environment");
            String _name = name.replace(this.bundlePath, "");
            Object s = null;
            s = isTranslation ? name : this.internalResourcePath + (_name.startsWith("/") || this.internalResourcePath.endsWith("/") ? "" : "/") + _name;
            b.append("/" + (String)s);
            URI uri = URI.createPlatformPluginURI((String)b.toString(), (boolean)true);
            this.deployedURIResources.put(uri, URI.createURI((String)name));
        }
    }

    public void generateFilesInto() {
        if (this.fileGenerated) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)this.bundleName);
        this.detectInternalResourceURI();
        for (URI uri : this.deployedURIResources.keySet()) {
            if (uri.fileExtension().equals("properties")) continue;
            IPath p = Platform.getStateLocation((Bundle)Platform.getBundle((String)"com.semarchy.xdi.designer.index")).append("/internalResource");
            int i = 2;
            while (i < uri.segmentCount()) {
                p = p.append("/" + URI.decode((String)uri.segment(i)));
                ++i;
            }
            File f = p.toFile();
            if (f.exists()) {
                f.delete();
            }
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            InputStream is = null;
            OutputStream os = null;
            StringBuilder s = new StringBuilder();
            URI u = this.getPathRelativeToBundle(uri);
            int i2 = 0;
            while (i2 < u.segmentCount()) {
                s.append("/");
                s.append(URI.decode((String)u.segment(i2)));
                ++i2;
            }
            Path relativePathToBundle = new Path(s.toString());
            URL _url = null;
            try {
                try {
                    _url = bundle.getEntry(relativePathToBundle.toString());
                    is = new BufferedInputStream(_url.openStream());
                    os = new BufferedOutputStream(new FileOutputStream(p.toFile()));
                    byte[] buffer = new byte[2048];
                    int sz = -1;
                    while ((sz = is.read(buffer)) != -1) {
                        os.write(buffer, 0, sz);
                    }
                    Logger.getLogger(this.getClass().getName()).info("Generated internalResource file for " + String.valueOf(uri) + " from " + String.valueOf(_url));
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Generated internalResource file for " + String.valueOf(uri) + " from  " + String.valueOf(_url), ex);
                    if (is != null) {
                        try {
                            is.close();
                            is = null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (os == null) continue;
                    try {
                        os.close();
                        os = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                        os = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (os == null) continue;
            try {
                os.close();
                os = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fileGenerated = true;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getResourceFolderPath() {
        return this.resourceImportPath;
    }

    public Collection<URI> getProvidedResourceURI() {
        return this.deployedURIResources.keySet();
    }

    public URI getPathRelativeToBundle(URI resourceURI) {
        return this.deployedURIResources.get(resourceURI);
    }

    protected List<URL> getBundleEntryURL() {
        Bundle bundle = Platform.getBundle((String)this.bundleName);
        return this.getFilesURI().stream().map(uri -> this.deployedURIResources.get(uri)).filter(InternalResourceFolderRegistry.filterIndexableModels()).map(uri -> bundle.getEntry(URI.decode((String)uri.toString()))).filter(u -> u != null).collect(Collectors.toList());
    }

    public IComponentService.IComponent getComponent() {
        return this.component;
    }

    public boolean isAuthorized() {
        if (this.component == null) {
            return true;
        }
        return AdministrationHelper.componentAuthorized((IComponentService.IComponent)this.component);
    }
}

