/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.provider.custom;

import com.semarchy.xdi.designer.core.services.registry.ProcessToolDescriptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public enum ToolImageProvider {
    INSTANCE;

    private static ImageRegistry images;
    private static Object lock;

    static {
        images = null;
        lock = new Object();
    }

    public ImageDescriptor getLargeImageDescriptor(ProcessToolDescriptor desc) {
        return this.getImageDescriptor(desc.getLargeIcon(), desc.getDefaultLargeIconPath());
    }

    public ImageDescriptor getSmallImageDescriptor(ProcessToolDescriptor a) {
        return this.getImageDescriptor(a.getSmallIcon(), a.getDefaultSmallIconPath());
    }

    private ImageDescriptor findImageDescriptor(URL url) {
        if (url.getProtocol().equals("platform")) {
            URI uri = URI.createPlatformPluginURI((String)url.getPath().replace("plugin/", ""), (boolean)true);
            Path p = new Path(uri.path());
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(1), (String)p.removeFirstSegments(2).makeAbsolute().toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageDescriptor getImageDescriptor(ProcessToolDescriptor.IconDescriptor desc, String defaultIconPath) {
        Object object = lock;
        synchronized (object) {
            if (images == null) {
                images = new ImageRegistry();
            }
        }
        try {
            if (desc != null) {
                if (desc.isRaw()) {
                    Image img = new Image((Device)Display.getDefault(), (InputStream)new ByteArrayInputStream(desc.getIconData()));
                    images.remove(desc.getKey());
                    images.put(desc.getKey(), img);
                    return images.getDescriptor(desc.getKey());
                }
                return this.findImageDescriptor(new URL(desc.getKey()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ToolImageProvider.findImageDescriptor(defaultIconPath);
    }

    private static ImageDescriptor findImageDescriptor(String path) {
        Path p = new Path(path);
        if (p.isAbsolute() && p.segmentCount() > 1) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
        }
        return null;
    }
}

