/*
 * Decompiled with CFR 0.152.
 */
package com.indy.environment;

import com.indy.environment.Messages;
import com.indy.environment.navigator.resources.PreferenceHelper;
import com.indy.ui.custom.out.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class EnvironmentPlugin
extends AbstractUIPlugin
implements BundleActivator {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public static final String PLUGIN_ID = "com.indy.environment";
    private static EnvironmentPlugin plugin;
    private static HashMap<String, Bundle> initProjectRegistry;

    public static HashMap<String, Bundle> getInitProjectRegistry() {
        return initProjectRegistry;
    }

    public void start(BundleContext context) throws Exception {
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Starting Bundle com.indy.environment");
        super.start(context);
        plugin = this;
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Started Bundle com.indy.environment");
    }

    public void stop(BundleContext context) throws Exception {
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Stopping Bundle com.indy.environment");
        plugin = null;
        super.stop(context);
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Stopped Bundle com.indy.environment");
    }

    public static EnvironmentPlugin getDefault() {
        return plugin;
    }

    public void initEnv() {
        final UIJob j = new UIJob(Messages.EnvironmentPlugin_5){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                EnvironmentPlugin.this.handleWorkspaceS17(monitor);
                if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                    IWorkspaceDescription d = ResourcesPlugin.getWorkspace().getDescription();
                    d.setAutoBuilding(true);
                    try {
                        ResourcesPlugin.getWorkspace().setDescription(d);
                    }
                    catch (CoreException e) {
                        EnvironmentPlugin.this.logger.log(Level.WARNING, "unexpected", e);
                    }
                    EnvironmentPlugin.getDefault().getLog().log((IStatus)new Status(1, EnvironmentPlugin.PLUGIN_ID, Messages.EnvironmentPlugin_6));
                    MessageDialog.openInformation((Shell)new Shell(this.getDisplay()), (String)Messages.EnvironmentPlugin_7, (String)Messages.EnvironmentPlugin_8);
                }
                final ArrayList<IProject> l = new ArrayList<IProject>();
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    if (p.isOpen()) {
                        l.add(p);
                    }
                    ++n2;
                }
                Job j = new Job(Messages.EnvironmentPlugin_9){

                    protected IStatus run(IProgressMonitor monitor) {
                        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.EnvironmentPlugin_10, (int)(l.size() * 2));
                        for (IProject p : l) {
                            Logger.getLogger(EnvironmentPlugin.class.getName()).fine("Clean build on Project " + p.getName());
                            try {
                                p.build(15, (IProgressMonitor)sub.newChild(1));
                            }
                            catch (CoreException e) {
                                (this).EnvironmentPlugin.this.logger.log(Level.WARNING, "unexpected", e);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                j.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                j.setUser(true);
                j.schedule();
                return Status.OK_STATUS;
            }
        };
        final String baseProp = System.getProperty("javax.xml.transform.TransformerFactory");
        WorkspaceJob job = new WorkspaceJob(Messages.EnvironmentPlugin_13){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    ISaveParticipant p = new ISaveParticipant(){

                        public void doneSaving(ISaveContext context) {
                        }

                        public void prepareToSave(ISaveContext context) throws CoreException {
                            if (baseProp != null) {
                                System.setProperty("javax.xml.transform.TransformerFactory", baseProp);
                            } else {
                                System.getProperties().remove("javax.xml.transform.TransformerFactory");
                            }
                        }

                        public void rollback(ISaveContext context) {
                        }

                        public void saving(ISaveContext context) throws CoreException {
                        }
                    };
                    ResourcesPlugin.getWorkspace().addSaveParticipant(EnvironmentPlugin.PLUGIN_ID, p);
                }
                catch (Exception e1) {
                    EnvironmentPlugin.this.logger.log(Level.WARNING, "unexpected", e1);
                }
                EnvironmentPlugin.initGlobal(monitor);
                if (EnvironmentPlugin.this.isWorkspaceS17()) {
                    j.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.log(Level.FINE, "interrupted", e);
        }
    }

    private boolean isWorkspaceS17() {
        boolean isWorkspaceS17 = false;
        PreferenceHelper.CleanMode cm = null;
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("com.indy.environment.navigator.resources");
        int modeVal = pref.getInt("cleanMode", -1);
        if (modeVal >= 0) {
            try {
                cm = PreferenceHelper.CleanMode.values()[modeVal];
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "unexpected", e);
            }
        }
        isWorkspaceS17 = cm == null && modeVal == -1;
        return isWorkspaceS17;
    }

    private void handleWorkspaceS17(IProgressMonitor monitor) {
        PreferenceHelper.CleanMode clean = PreferenceHelper.INSTANCE.handleClean();
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(".tech");
        try {
            if (clean == PreferenceHelper.CleanMode.Close) {
                if (p.exists()) {
                    p.close(monitor);
                }
            } else if (clean == PreferenceHelper.CleanMode.DeleteFromFileSystem) {
                if (p.exists()) {
                    p.delete(true, true, monitor);
                }
            } else if (clean == PreferenceHelper.CleanMode.DeleteFromWorkspace && p.exists()) {
                p.delete(false, true, monitor);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "unexpected", ex);
        }
    }

    private static void initGlobal(IProgressMonitor monitor) {
        initProjectRegistry = new HashMap();
        initProjectRegistry.put(".tech", plugin.getBundle());
        IProject globalProj = ResourcesPlugin.getWorkspace().getRoot().getProject("global");
        if (!globalProj.exists()) {
            Util.initEnv((Bundle)plugin.getBundle(), (String)"global", (String)"*", (boolean)true, (boolean)true, (boolean)true, (IProgressMonitor)monitor);
        }
    }
}

