/*
 * Decompiled with CFR 0.152.
 */
package com.indy.environment.navigator.resources;

import com.indy.environment.EnvironmentPlugin;
import com.indy.environment.Messages;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceHelper {
    public static final String PREF_NODE = "com.indy.environment.navigator.resources";
    public static final String PREF_INTERNAL_RESOURCE_CLEAN_MODE = "cleanMode";
    public static PreferenceHelper INSTANCE = new PreferenceHelper();

    private PreferenceHelper() {
    }

    public CleanMode handleClean() {
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode(PREF_NODE);
        int modeVal = pref.getInt(PREF_INTERNAL_RESOURCE_CLEAN_MODE, -1);
        if (EnvironmentPlugin.getDefault().getPreferenceStore().getBoolean("com.indy.environment.preferences.showCleanTechPopup")) {
            modeVal = -1;
        }
        IProject techProject = ResourcesPlugin.getWorkspace().getRoot().getProject(".tech");
        CleanMode cm = null;
        if (modeVal >= 0) {
            try {
                cm = CleanMode.values()[modeVal];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (techProject.exists() && techProject.isOpen() && (modeVal == -1 || cm == null || cm != CleanMode.Keep)) {
            CleanModeDialog d = new CleanModeDialog(new Shell(48));
            d.setBlockOnOpen(true);
            d.open();
            try {
                pref.putInt(PREF_INTERNAL_RESOURCE_CLEAN_MODE, d.mode.ordinal());
                pref.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            return d.mode;
        }
        try {
            if (!(techProject.exists() && techProject.isOpen() || modeVal != -1)) {
                pref.putInt(PREF_INTERNAL_RESOURCE_CLEAN_MODE, -2);
            }
            pref.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static enum CleanMode {
        Close(Messages.PreferenceHelper_2),
        DeleteFromWorkspace(Messages.PreferenceHelper_3),
        DeleteFromFileSystem(Messages.PreferenceHelper_4),
        Keep(Messages.PreferenceHelper_5);

        private String label;

        private CleanMode(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private class CleanModeDialog
    extends Dialog {
        protected CleanMode mode;

        protected CleanModeDialog(Shell parentShell) {
            super(parentShell);
            this.mode = CleanMode.Close;
            this.setShellStyle(this.getShellStyle() & 0xFFFFFFBF);
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(Messages.PreferenceHelper_7);
            Composite c = new Composite(parent, 0);
            c.setLayout((Layout)new GridLayout());
            Label l = new Label(c, 64);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.PreferenceHelper_8 + Messages.PreferenceHelper_9);
            ArrayList<Button> bs = new ArrayList<Button>();
            int i = 0;
            while (i < CleanMode.values().length) {
                Button b = new Button(c, 16);
                b.setLayoutData((Object)new GridData());
                b.setText(CleanMode.values()[i].getLabel());
                bs.add(b);
                ++i;
            }
            new Label(c, 258).setLayoutData((Object)new GridData(4, 3, true, false));
            final Button b = new Button(c, 32);
            int i2 = 0;
            while (i2 < CleanMode.values().length) {
                Button b1 = (Button)bs.get(i2);
                final int j = i2;
                if (CleanMode.values()[i2] == CleanMode.Keep && EnvironmentPlugin.getDefault().getPreferenceStore().getBoolean("com.indy.environment.preferences.showCleanTechPopup")) {
                    b1.setSelection(true);
                    b.setEnabled(true);
                    this.mode = CleanMode.Keep;
                }
                b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (((Button)e.widget).getSelection()) {
                            CleanModeDialog.this.mode = CleanMode.values()[j];
                            if (CleanModeDialog.this.mode == CleanMode.Keep) {
                                b.setEnabled(true);
                                b.setSelection(true);
                                EnvironmentPlugin.getDefault().getPreferenceStore().setValue("com.indy.environment.preferences.showCleanTechPopup", true);
                            } else {
                                EnvironmentPlugin.getDefault().getPreferenceStore().setValue("com.indy.environment.preferences.showCleanTechPopup", false);
                                b.setEnabled(false);
                                b.setSelection(false);
                            }
                        }
                    }
                });
                ++i2;
            }
            b.setLayoutData((Object)new GridData());
            b.setText(Messages.PreferenceHelper_10);
            b.setSelection(EnvironmentPlugin.getDefault().getPreferenceStore().getBoolean("com.indy.environment.preferences.showCleanTechPopup"));
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean state = ((Button)e.widget).getSelection();
                    EnvironmentPlugin.getDefault().getPreferenceStore().setValue("com.indy.environment.preferences.showCleanTechPopup", state);
                }
            });
            return c;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }
}

