/*
 * Decompiled with CFR 0.152.
 */
package com.indy.environment.navigator.resources;

import java.util.concurrent.Semaphore;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ResourcesView
extends CommonNavigator
implements IResourceChangeListener {
    private static final Color bgColor = new Color(null, 255, 255, 255);
    private static final Color frColor = new Color(null, 128, 128, 128);
    private static final String SEARCH_TEXT = "type filter text";
    private static final TabbedPropertySheetWidgetFactory toolkit = new TabbedPropertySheetWidgetFactory();
    private String name;
    private ViewerFilter nameFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (ResourcesView.this.name == null || ResourcesView.this.name.isEmpty()) {
                return true;
            }
            if (element instanceof TreeNode) {
                if (((TreeNode)element).getParent() == null) {
                    return true;
                }
                Object val = ((TreeNode)element).getValue();
                Object s = "";
                if (val instanceof URI) {
                    int i = 2;
                    while (i < ((URI)val).segmentCount()) {
                        s = (String)s + "/" + ((URI)val).segment(i);
                        ++i;
                    }
                } else {
                    s = val.toString();
                }
                if (((String)s).toLowerCase().matches(".*" + ResourcesView.this.name.toLowerCase().replace("*", ".*") + ".*")) {
                    return true;
                }
            }
            return false;
        }
    };
    private Semaphore lock = new Semaphore(1);
    private IStateListener treeLayoutListener = new IStateListener(){

        public void handleStateChange(State state, Object oldValue) {
            if (ResourcesView.this.lock.tryAcquire() && Boolean.FALSE.equals(oldValue)) {
                try {
                    try {
                        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        IHandlerService s = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                        s.executeCommand("com.indy.environment.command.internalResourceLayoutList", null);
                        if (Boolean.TRUE.equals(state.getValue())) {
                            ResourcesView.this.getCommonViewer().getExpandedTreePaths();
                            ResourcesView.this.getCommonViewer().refresh();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ResourcesView.this.lock.release();
                    }
                }
                finally {
                    ResourcesView.this.lock.release();
                }
            }
        }
    };
    private IStateListener listLayoutListener = new IStateListener(){

        public void handleStateChange(State state, Object oldValue) {
            if (ResourcesView.this.lock.tryAcquire() && Boolean.FALSE.equals(oldValue)) {
                try {
                    try {
                        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        IHandlerService s = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                        s.executeCommand("com.indy.environment.command.internalResourceLayoutTree", null);
                        if (Boolean.TRUE.equals(state.getValue())) {
                            ResourcesView.this.getCommonViewer().refresh();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ResourcesView.this.lock.release();
                    }
                }
                finally {
                    ResourcesView.this.lock.release();
                }
            }
        }
    };
    private UIJob refreshViewerJob;
    public static final String VIEW_ID = "com.indy.environment.navigator.view";

    public ResourcesView() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.getCommand("com.indy.environment.command.internalResourceLayoutTree").getState("org.eclipse.ui.commands.toggleState").addListener(this.treeLayoutListener);
        commandService.getCommand("com.indy.environment.command.internalResourceLayoutList").getState("org.eclipse.ui.commands.toggleState").addListener(this.listLayoutListener);
    }

    public void dispose() {
        ICommandService commandService;
        if (this.refreshViewerJob != null) {
            this.refreshViewerJob.cancel();
            this.refreshViewerJob = null;
        }
        if (ResourcesPlugin.getWorkspace() != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        if ((commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)) != null) {
            commandService.getCommand("com.indy.environment.command.internalResourceLayoutTree").getState("org.eclipse.ui.commands.toggleState").removeListener(this.treeLayoutListener);
            commandService.getCommand("com.indy.environment.command.internalResourceLayoutList").getState("org.eclipse.ui.commands.toggleState").removeListener(this.listLayoutListener);
        }
        super.dispose();
    }

    public void createPartControl(Composite aParent) {
        this.setTitleToolTip(this.getTitle());
        toolkit.setBackground(bgColor);
        Composite main = toolkit.createComposite(aParent, 0);
        GridLayout l = new GridLayout();
        l.horizontalSpacing = 0;
        l.verticalSpacing = 0;
        main.setLayout((Layout)l);
        Composite c = toolkit.createComposite(main, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 1, true, false);
        c.setLayoutData((Object)gd);
        Text search = toolkit.createText(c, SEARCH_TEXT, 2048);
        search.setLayoutData((Object)new GridData(4, 1, true, false));
        search.setForeground(frColor);
        search.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Text l = (Text)e.widget;
                if (l.getText().trim().isEmpty()) {
                    l.setForeground(frColor);
                    l.setText(ResourcesView.SEARCH_TEXT);
                }
            }

            public void focusGained(FocusEvent e) {
                Text l = (Text)e.widget;
                if (frColor.equals((Object)l.getForeground())) {
                    l.setForeground(null);
                    l.setText("");
                }
            }
        });
        search.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Text l = (Text)e.widget;
                l.selectAll();
            }
        });
        search.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourcesView.this.name = frColor.equals((Object)((Text)e.widget).getForeground()) ? null : ((Text)e.widget).getText();
                ResourcesView.this.getCommonViewer().refresh();
            }
        });
        super.createPartControl(main);
        this.getCommonViewer().getControl().setLayoutData((Object)new GridData(1808));
        this.getCommonViewer().addFilter(this.nameFilter);
        this.getCommonViewer().setAutoExpandLevel(1);
        this.contributeActionsToolbar();
    }

    private void contributeActionsToolbar() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            this.refeshNavigator();
        }
    }

    private void refeshNavigator() {
        Display display;
        if (this.refreshViewerJob == null && (display = this.getSite().getShell().getDisplay()) != null) {
            this.refreshViewerJob = new UIJob(display, "Refesh Internal Resources"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    CommonViewer v = ResourcesView.this.getCommonViewer();
                    if (v != null && v.getControl() != null && !v.getControl().isDisposed()) {
                        ResourcesView.this.getCommonViewer().refresh();
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        if (this.refreshViewerJob != null) {
            this.refreshViewerJob.schedule(200L);
        }
    }
}

