/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom;

import com.indy.ui.custom.out.EditorInputManager;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.gmf.IDiagramResourceInitializer;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import com.indy.ui.custom.out.services.IDiagramProviderService;
import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.IntrospectionUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={IGenerationService.IGenerationImageService.class}, scope=ServiceScope.SINGLETON)
public class GenerateImage
implements IGenerationService.IGenerationImageService {
    Logger logger = LogManager.getLogger(GenerateImage.class);
    Map<URI, IPath> generated = new HashMap<URI, IPath>();
    Display display;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void bind(IWorkbench workbench) {
        this.display = workbench.getDisplay();
    }

    public void unbind(IWorkbench workbench) {
        this.display = null;
    }

    private void generatesByFile(Map<String, URI> inputs, String outDir) {
        TransactionalEditingDomain domain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
        ResourceSet resourceSet = domain.getResourceSet();
        resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        resourceSet.getLoadOptions().put("STB_OPTION_DISABLE_ALL_MAP_ADAPTER", Boolean.TRUE);
        for (String id : inputs.keySet()) {
            try {
                IDiagramProviderService service;
                Path outPath = new Path(outDir + "/" + id + ".png");
                long imageTime = outPath.toFile().exists() ? outPath.toFile().lastModified() : 0L;
                URI diagramURI = null;
                URI semanticURI = inputs.get(id);
                if (semanticURI == null) {
                    throw new RuntimeException("Unable to find the URI for the id=" + id + " in the cache");
                }
                String extension = semanticURI.fileExtension();
                long modelDate = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceState(semanticURI).getLastModified();
                if ("proc".equals(extension)) {
                    diagramURI = EditorInputManager.getDiagramURI((URI)semanticURI, (String)"proc");
                } else if ("map".equals(extension)) {
                    diagramURI = EditorInputManager.getDiagramURI((URI)semanticURI, (String)"map");
                }
                IFile diagramFile = Util.convertEMFURIToFile((URI)diagramURI);
                if (diagramFile != null && diagramFile.exists()) {
                    modelDate = Math.max(modelDate, ((Path)diagramFile.getRawLocation()).toFile().lastModified());
                }
                if (modelDate <= imageTime || (service = (IDiagramProviderService)E4InjectorHelper.getService(IDiagramProviderService.class)) == null) continue;
                IDiagramResourceInitializer initializer = service.getInitializer(semanticURI);
                if (initializer == null) {
                    throw new RuntimeException("No IDiagramResourceInitializer for the resource " + String.valueOf(semanticURI));
                }
                Resource semanticResource = resourceSet.getResource(semanticURI, true);
                try {
                    Resource diagramResource = initializer.createResourceDiagram(semanticResource, diagramURI);
                    this.generate(diagramResource, outDir);
                }
                catch (Exception ex) {
                    this.logger.error("Failed to generate diagram {}", (Object)diagramURI, (Object)ex);
                }
            }
            catch (Exception ex) {
                this.logger.error("Failed to generate image for id {}", (Object)id, (Object)ex);
            }
        }
    }

    public void clearImages() {
        this.generated.clear();
    }

    private void generate(final Resource resource, String outDir) {
        if (resource instanceof GMFResource) {
            try {
                for (EObject obj : new ArrayList(resource.getContents())) {
                    Diagram diagram;
                    if (!(obj instanceof Diagram) || (diagram = (Diagram)obj).getElement() == null || this.generated.get(EcoreUtil.getURI((EObject)diagram.getElement())) != null) continue;
                    IndyXMLResource semanticResource = (IndyXMLResource)diagram.getElement().eResource();
                    String id = semanticResource.getID(diagram.getElement());
                    if (id == null) {
                        id = (String)IntrospectionUtils.getMethod((Object)diagram.getElement(), (String)"getId");
                    }
                    Path outPath = new Path(outDir + "/" + id + ".png");
                    if (this.display == null) {
                        try {
                            this.display = Display.getDefault();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.display == null) {
                        try {
                            Bundle bundle = Platform.getBundle((String)"com.indy.environment");
                            Path path = new Path("doc/images/no-display.png");
                            URL fileURL = Platform.find((Bundle)bundle, (IPath)path);
                            Throwable throwable = null;
                            Object var13_17 = null;
                            try (InputStream in = fileURL.openStream();){
                                Files.copy(in, Paths.get(outPath.toFile().toURI()), StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception ex) {
                            this.logger.error("unexpected", (Throwable)ex);
                        }
                        continue;
                    }
                    this.display.syncExec(new Runnable((IPath)outPath){
                        private final /* synthetic */ IPath val$outPath;
                        {
                            this.val$outPath = iPath;
                        }

                        @Override
                        public void run() {
                            block17: {
                                DiagramEditPart diagramEditPart = null;
                                Shell sh = null;
                                try {
                                    try {
                                        EObject eObject;
                                        CopyToImageUtil copyToImageUtil = new CopyToImageUtil();
                                        sh = new Shell();
                                        diagramEditPart = copyToImageUtil.createDiagramEditPart(diagram, sh, PreferencesHint.USE_DEFAULTS);
                                        ArrayList<Node> nodes = new ArrayList<Node>();
                                        int minX = Integer.MAX_VALUE;
                                        int minY = Integer.MAX_VALUE;
                                        for (Object o : diagramEditPart.getChildren()) {
                                            LayoutConstraint lc;
                                            Object model;
                                            if (!(o instanceof IGraphicalEditPart) || !((model = ((IGraphicalEditPart)o).getModel()) instanceof Node) || !((lc = ((Node)model).getLayoutConstraint()) instanceof Bounds)) continue;
                                            nodes.add((Node)model);
                                            minX = Math.min(minX, ((Bounds)lc).getX());
                                            minY = Math.min(minY, ((Bounds)lc).getY());
                                        }
                                        if (minX < 0 || minY < 0) {
                                            CompoundCommand cc = new CompoundCommand();
                                            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagramEditPart.getDiagramView());
                                            for (Node n : nodes) {
                                                if (minX < 0) {
                                                    cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)n.getLayoutConstraint(), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)(((Bounds)n.getLayoutConstraint()).getX() + Math.abs(minX) + 10)));
                                                }
                                                if (minY >= 0) continue;
                                                cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)n.getLayoutConstraint(), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)(((Bounds)n.getLayoutConstraint()).getY() + Math.abs(minY) + 10)));
                                            }
                                            domain.getCommandStack().execute((Command)cc);
                                            diagramEditPart.getFigure().invalidateTree();
                                        }
                                        diagramEditPart.getViewport().validate();
                                        if (diagramEditPart instanceof DiagramEditPart) {
                                            diagramEditPart.getViewport().getHorizontalRangeModel().setValue(diagramEditPart.getViewport().getHorizontalRangeModel().getMinimum());
                                            diagramEditPart.getViewport().getVerticalRangeModel().setValue(diagramEditPart.getViewport().getVerticalRangeModel().getMinimum());
                                        }
                                        if ((eObject = diagramEditPart.resolveSemanticElement()) == null) break block17;
                                        if ("map".equals(resource.getURI().fileExtension())) {
                                            IFigure f = diagramEditPart.getLayer((Object)"Printable Layers");
                                            Rectangle r = f.getBounds().getCopy();
                                            f.getBounds().translate(-r.x, -r.y);
                                            f.setBounds(r);
                                            diagramEditPart.getViewer().flush();
                                            Image img = new Image(null, r.width - Math.min(0, r.x), r.height - Math.min(0, r.y));
                                            GC gc = new GC((Drawable)img);
                                            SWTGraphics graphics = new SWTGraphics(gc);
                                            f.paint((Graphics)graphics);
                                            ImageLoader loader = new ImageLoader();
                                            loader.data = new ImageData[]{img.getImageData()};
                                            loader.save(this.val$outPath.toOSString(), 5);
                                            graphics.dispose();
                                            gc.dispose();
                                            img.dispose();
                                            GenerateImage.this.generated.put(EcoreUtil.getURI((EObject)diagramEditPart.getDiagramView().getElement()), this.val$outPath);
                                            break block17;
                                        }
                                        try {
                                            copyToImageUtil.copyToImage(diagramEditPart, this.val$outPath, ImageFileFormat.PNG, (IProgressMonitor)new NullProgressMonitor());
                                            GenerateImage.this.generated.put(EcoreUtil.getURI((EObject)diagramEditPart.getDiagramView().getElement()), this.val$outPath);
                                        }
                                        catch (Exception ex) {
                                            GenerateImage.this.logger.error("Failed to generate image for {}", (Object)resource.getURI(), (Object)ex);
                                        }
                                    }
                                    catch (Exception e) {
                                        GenerateImage.this.logger.error("unexpected", (Throwable)e);
                                        if (diagramEditPart != null) {
                                            diagramEditPart.deactivate();
                                        }
                                        if (sh != null) {
                                            sh.dispose();
                                        }
                                    }
                                }
                                finally {
                                    if (diagramEditPart != null) {
                                        diagramEditPart.deactivate();
                                    }
                                    if (sh != null) {
                                        sh.dispose();
                                    }
                                }
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                this.logger.error("unexpected", (Throwable)e);
            }
        }
    }

    public void generateById(List<String> ids, String outDir) {
        HashMap<String, URI> inputs = new HashMap<String, URI>();
        for (String id : ids) {
            URI uri;
            if (id == null || id.isEmpty() || (uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(id)) == null) continue;
            inputs.put(id, uri);
        }
        this.generatesByFile(inputs, outDir);
    }

    public void saveImageAsPNG(File outputFile, URI imageURI) {
        ComposedImage obj = new ComposedImage(Collections.singletonList(imageURI));
        ImageDescriptor desc = ExtendedImageRegistry.getInstance().getImageDescriptor((Object)obj);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{desc.getImageData()};
        File folder = outputFile.getParentFile();
        folder.mkdirs();
        imageLoader.save(outputFile.getAbsolutePath(), 5);
    }
}

