/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom;

import com.indy.gmf.proc.diagram.non_rcp.custom.ProcessDiagramLinker;
import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import com.indy.ui.custom.out.EditorInputManager;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.osgi.framework.Bundle;

public class ProcDiagramUtil {
    public static boolean compareURI(URI uri, URI uri2) {
        String f2;
        String fileId2;
        String f1 = uri.fragment();
        String fileId1 = CacheHelper.extractEltInfo((String)f1, (String)"fileId");
        if (fileId1.equals(fileId2 = CacheHelper.extractEltInfo((String)(f2 = uri2.fragment()), (String)"fileId"))) {
            if (f1.contains("?")) {
                f1 = f1.substring(0, f1.indexOf("?"));
            }
            if (f2.contains("?")) {
                f2 = f2.substring(0, f2.indexOf("?"));
            }
            return f1.equals(f2);
        }
        return false;
    }

    public static Diagram getDiagram(URI semanticDiagramElement, URI diagramResourceURI, boolean createIfMissing) {
        diagramResourceURI.fileExtension().equals("proc_diagram");
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        rs.setURIConverter((URIConverter)new StambiaGMFEditingDomainFactory.URIConverterProxy(rs.getURIConverter()));
        Resource diagramResource = null;
        try {
            diagramResource = rs.getResource(diagramResourceURI, true);
        }
        catch (Exception ex) {
            diagramResource = rs.createResource(diagramResourceURI);
        }
        for (Object o : diagramResource.getContents()) {
            URI semURI;
            EObject obj;
            if (!(o instanceof Diagram) || (obj = ((Diagram)o).getElement()) == null) continue;
            URI uRI = semURI = obj.eIsProxy() ? ((InternalEObject)obj).eProxyURI() : EcoreUtil.getURI((EObject)obj);
            if (!ProcDiagramUtil.compareURI(semURI, semanticDiagramElement)) continue;
            return (Diagram)o;
        }
        Diagram d = NotationFactory.eINSTANCE.createDiagram();
        AnyType sem = XMLTypeFactory.eINSTANCE.createAnyType();
        ((InternalEObject)sem).eSetProxyURI(semanticDiagramElement);
        d.setElement((EObject)sem);
        d.setType("Proc");
        diagramResource.getContents().add((Object)d);
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        try {
            diagramResource.save(saveOptions);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Resource createNewDiagram(URI domainModelURI, boolean force) throws Exception {
        TransactionalEditingDomain editingDomain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
        editingDomain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        URI diagramURI = EditorInputManager.getDiagramURI((URI)domainModelURI.trimFragment(), (String)"proc");
        if (diagramURI.isPlatformResource()) {
            IFile diagramFile = Util.convertEMFURIToFile((URI)diagramURI);
            if (diagramFile.exists()) {
                if (!force) return editingDomain.getResourceSet().getResource(diagramURI, true);
                diagramFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        } else {
            IPath p;
            File f;
            String modelId = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(domainModelURI);
            if (force && (f = (p = Platform.getStateLocation((Bundle)Platform.getBundle((String)"com.indy.gmf.map.diagram")).append(modelId + ".proc_diagram")).toFile()).exists()) {
                f.delete();
            }
            diagramURI = diagramURI.trimFileExtension().trimFragment().trimSegments(diagramURI.segmentCount() - 2).appendSegment(modelId).trimFileExtension().appendFileExtension("proc_diagram");
        }
        ProcessDiagramLinker linker = new ProcessDiagramLinker();
        if ("map".equals(domainModelURI.fileExtension())) {
            return linker.createDiagram4Mapping(editingDomain, domainModelURI, diagramURI);
        }
        if (!"proc".equals(domainModelURI.fileExtension())) throw new Exception(Messages.ProcDiagramUtil_13);
        return linker.createDiagram4Process(editingDomain, domainModelURI, diagramURI);
    }

    public static URI getDiagramURI(URI modelURI) {
        String diagramfileName = "." + modelURI.lastSegment().replaceAll(modelURI.fileExtension(), modelURI.fileExtension() + "_diagram");
        return modelURI.trimSegments(1).appendSegment(diagramfileName);
    }
}

