/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.commands;

import com.indy.gmf.proc.diagram.non_rcp.custom.multi.MultiPageEditor;
import com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.dialogs.CopyToImageDialog;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.l10n.DiagramUIRenderMessages;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToHTMLImageUtil;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class SaveAsImageHandler
extends AbstractHandler {
    private CopyToImageDialog dialog = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPath path = null;
        String fileName = null;
        DiagramEditPart editPart = null;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() instanceof MultiPageEditor) {
            IFile file;
            IEditorPart editor = (IEditorPart)((MultiPageEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()).getSelectedPage();
            IContainer container = (IContainer)editor.getEditorInput().getAdapter(IContainer.class);
            if (container != null && container.exists()) {
                path = container.getLocation();
            }
            if (path == null && (file = (IFile)editor.getEditorInput().getAdapter(IFile.class)) != null) {
                path = file.getLocation().removeLastSegments(1);
                fileName = file.getLocation().removeFileExtension().lastSegment();
            }
            editPart = ((ProcDiagramEditor)editor).getDiagramEditPart();
            this.dialog = new CopyToImageDialog(Display.getCurrent().getActiveShell(), path, fileName);
            this.runCopyToImageUI(this.dialog, editPart);
        }
        return null;
    }

    private void runCopyToImageUI(CopyToImageDialog dialog, DiagramEditPart editPart) {
        if (dialog.open() == 1) {
            return;
        }
        if (!this.overwriteExisting()) {
            return;
        }
        Trace.trace((Plugin)DiagramUIRenderPlugin.getInstance(), (String)("Copy Diagram to " + dialog.getDestination().toOSString() + " as " + dialog.getImageFormat().toString()));
        MultiStatus status = new MultiStatus(DiagramUIRenderPlugin.getPluginId(), 0, DiagramUIRenderMessages.CopyToImageAction_Label, null);
        IRunnableWithProgress runnable = this.createRunnable(status, editPart);
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            progressMonitorDialog.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            Log.warning((Plugin)DiagramUIRenderPlugin.getInstance(), (int)9, (String)e.getTargetException().getMessage(), (Throwable)e.getTargetException());
            if (e.getTargetException() instanceof OutOfMemoryError) {
                if (dialog.exportToHTML()) {
                    this.openErrorDialog(DiagramUIRenderMessages.CopyToImageAction_outOfMemoryMessage);
                } else if (new MessageDialog(dialog.getShell(), DiagramUIRenderMessages.CopyToImageOutOfMemoryDialog_title, null, DiagramUIRenderMessages.CopyToImageOutOfMemoryDialog_message, 1, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0).open() == 0) {
                    this.runCopyToImageUI(dialog, editPart);
                }
            } else if (e.getTargetException() instanceof SWTError) {
                if (dialog.exportToHTML()) {
                    this.openErrorDialog(DiagramUIRenderMessages.CopyToImageAction_outOfMemoryMessage);
                } else if (new MessageDialog(dialog.getShell(), DiagramUIRenderMessages.CopyToImageOutOfMemoryDialog_title, null, DiagramUIRenderMessages.CopyToImageOutOfMemoryDialog_message, 1, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0).open() == 0) {
                    this.runCopyToImageUI(dialog, editPart);
                }
            } else {
                this.openErrorDialog(e.getTargetException().getMessage());
            }
            return;
        }
        catch (InterruptedException e) {
            Log.warning((Plugin)DiagramUIRenderPlugin.getInstance(), (int)9, (String)e.getMessage(), (Throwable)e);
        }
        if (!status.isOK()) {
            this.openErrorDialog(status.getChildren()[0].getMessage());
        }
    }

    private IRunnableWithProgress createRunnable(MultiStatus status, final DiagramEditPart editPart) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    try {
                        Object copyToImageUtil = null;
                        copyToImageUtil = SaveAsImageHandler.this.dialog.exportToHTML() ? new CopyToHTMLImageUtil() : new CopyToImageUtil();
                        monitor.beginTask("", 6);
                        monitor.worked(1);
                        monitor.setTaskName(NLS.bind((String)DiagramUIRenderMessages.CopyToImageAction_copyingDiagramToImageFileMessage, (Object)SaveAsImageHandler.this.dialog.getDestination().toOSString()));
                        copyToImageUtil.copyToImage(editPart, SaveAsImageHandler.this.dialog.getDestination(), SaveAsImageHandler.this.dialog.getImageFormat(), monitor);
                    }
                    catch (Exception e) {
                        Log.warning((Plugin)DiagramUIRenderPlugin.getInstance(), (int)9, (String)e.getMessage(), (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private void openErrorDialog(String message) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DiagramUIRenderMessages.CopyToImageAction_copyToImageErrorDialogTitle, (String)NLS.bind((String)DiagramUIRenderMessages.CopyToImageAction_copyToImageErrorDialogMessage, (Object)message));
    }

    private boolean overwriteExisting() {
        if (this.dialog.overwriteExisting()) {
            return true;
        }
        if (!this.dialog.getDestination().toFile().exists()) {
            return true;
        }
        return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)DiagramUIRenderMessages.CopyToImageAction_overwriteExistingConfirmDialogTitle, (String)NLS.bind((String)DiagramUIRenderMessages.CopyToImageAction_overwriteExistingConfirmDialogMessage, (Object)this.dialog.getDestination().toOSString()));
    }

    protected CopyToImageUtil getCopyToImageUtil() {
        return new CopyToImageUtil();
    }
}

