/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.multi.breadcrump;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.NavigationManager;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.breadcrump.BreadcrumpItem;
import com.indy.gmf.proc.provider.ProcEditPlugin;
import com.indy.gmf.proc.provider.custom.Util;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class Breadcrump
implements NavigationManager.INavigationListener {
    private Composite composite;
    private List<BreadcrumpItem> items = new ArrayList<BreadcrumpItem>();
    private NavigationManager navigator;
    private int currentActiveItemIndex = 0;

    public static Image getActionProcessImage(URI uri, URI previousURI, URI mainURI) {
        Image im = null;
        ArrayList<Object> images = new ArrayList<Object>();
        if (uri.trimFragment().equals(mainURI.trimFragment())) {
            images.add(Util.getSmallSubProcessImage());
        } else if (uri.isPlatformResource() && uri.segment(2).equals("indy.build")) {
            images.add(ProcEditPlugin.INSTANCE.getImage("full/obj16/Map.png"));
        } else {
            images.add(ProcEditPlugin.INSTANCE.getImage("full/obj16/ActionProcessRef.png"));
        }
        im = ExtendedImageRegistry.getInstance().getImage((Object)new ComposedImage(images));
        return im;
    }

    public Breadcrump(NavigationManager navigator) {
        this.navigator = navigator;
        this.navigator.addNavigationLister(this);
    }

    public Composite create(Composite parent) {
        this.composite = new Composite(parent, 0);
        RowLayout layout = new RowLayout();
        layout.spacing = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 2;
        layout.marginRight = 0;
        this.composite.setLayout((Layout)layout);
        this.composite.setBackground(parent.getDisplay().getSystemColor(22));
        return this.composite;
    }

    public Composite getControl() {
        return this.composite;
    }

    protected NavigationManager getNavigationManager() {
        return this.navigator;
    }

    public BreadcrumpItem createItem(Image image, String text, String tooltip, boolean locked) {
        BreadcrumpItem item = new BreadcrumpItem(this.items.size(), this, 0, locked);
        item.setText(text);
        item.setImage(image);
        item.setTooltip(tooltip);
        this.items.add(item);
        item.create();
        this.updateLastItem();
        return item;
    }

    public void removeItem(int index) {
        BreadcrumpItem item = this.items.remove(index);
        if (item != null) {
            item.dispose();
        }
        this.composite.layout(true);
        this.composite.getParent().layout(true);
    }

    public BreadcrumpItem getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public void handleActionChanged(int position, Action action) {
        if (position < this.items.size()) {
            BreadcrumpItem item = this.items.get(position);
            if (action.getName() != null) {
                item.setText(action.getName());
            }
        }
    }

    @Override
    public void handleCurrentIndexPositionChanged(int newPosition) {
        if (this.currentActiveItemIndex < this.items.size()) {
            this.items.get(this.currentActiveItemIndex).setCurrent(false);
        }
        this.currentActiveItemIndex = newPosition;
        if (this.currentActiveItemIndex < this.items.size()) {
            this.items.get(this.currentActiveItemIndex).setCurrent(true);
        }
    }

    public void updateLastItem() {
        int i = 0;
        while (i < this.items.size()) {
            this.getItem(i).setLast(i != 0 && i == this.items.size() - 1);
            ++i;
        }
        this.composite.layout(true);
        this.composite.getParent().layout(true);
    }

    public int getItemCount() {
        return this.items.size();
    }
}

