/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.multi.breadcrump;

import com.indy.gmf.map.edit.provider.custom.MapEditUtil;
import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.MultiPageEditor;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.MultiPageEditorHelper;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.NavigationManager;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.breadcrump.BreadCrumpViewer;
import com.indy.gmf.proc.diagram.non_rcp.custom.multi.breadcrump.Breadcrump;
import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditorPlugin;
import com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditorUtil;
import com.indy.ui.custom.out.emf.IResourceLocker;
import com.indy.ui.custom.out.emf.SharingReadOnlyEditingDomainFactory;
import com.indy.ui.custom.out.emf.StambiaURIHelper;
import com.indy.ui.custom.out.tools.FigureColoringHelper;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class BreadcrumpItem
extends Item {
    private static final int CLOSE_ITEM_INDEX = 1;
    private static Image delete = null;
    private static Image deleteHot = null;
    private Breadcrump parent;
    private CLabel lable;
    private Control expandBar;
    private Control closeBar;
    private int position;
    private String tooltip;
    private boolean expandable = true;
    private boolean isLocked = false;
    private Action openMapping;
    private Action openInEditor;
    private Action aquireLock;
    private Action releaseLock;
    private Action goToEdition;
    public static Font basique;
    public static Font bold;

    static {
        try {
            delete = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.process.diagram.non_rcp/icons/obj16x16/close_16x16.png")).createImage();
        }
        catch (Exception ex) {
            ProcDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, Messages.BreadcrumpItem_1, "com.indy.gmf.process.diagram.non_rcp", (Throwable)ex));
        }
        try {
            deleteHot = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.process.diagram.non_rcp/icons/obj16x16/close_hot_16x16.png")).createImage();
        }
        catch (Exception ex) {
            ProcDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, Messages.BreadcrumpItem_3, "com.indy.gmf.process.diagram.non_rcp", (Throwable)ex));
        }
    }

    protected BreadcrumpItem(int position, Breadcrump parent, int style, boolean isLocked) {
        super((Widget)parent.getControl(), style);
        this.parent = parent;
        this.position = position;
        this.setLocked(isLocked);
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
        this.updateLabel();
    }

    public void setData(Object data) {
    }

    public void create() {
        Composite c = new Composite(this.parent.getControl(), 0);
        RowLayout rl = new RowLayout();
        rl.spacing = 0;
        rl.marginBottom = 0;
        rl.marginTop = 0;
        rl.marginHeight = 0;
        rl.marginWidth = 0;
        rl.marginLeft = 1;
        rl.marginRight = 2;
        c.setLayout((Layout)rl);
        CLabel ctrl = new CLabel(c, 16384);
        ctrl.setLeftMargin(0);
        ctrl.setRightMargin(0);
        ctrl.setTopMargin(3);
        ctrl.setBottomMargin(0);
        ctrl.setImage(this.getImage());
        ctrl.setText(this.getText());
        ctrl.setToolTipText(this.tooltip);
        ctrl.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                try {
                    if (BreadcrumpItem.this.parent.getNavigationManager().getCurrentPosition() != BreadcrumpItem.this.position) {
                        URI semanticObjectURI = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getEditedProcessURI();
                        URI semanticOriginPointURI = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getOriginRefURI();
                        MultiPageEditorHelper.openPageOrEditor(semanticObjectURI, semanticOriginPointURI, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput());
                    }
                }
                catch (NullPointerException ex) {
                    ex.printStackTrace();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        ctrl.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                if (((CLabel)e.widget).getForeground() == e.display.getSystemColor(2) || ((CLabel)e.widget).getForeground() == e.display.getSystemColor(15)) {
                    ((CLabel)e.widget).setForeground(e.display.getSystemColor(9));
                }
            }

            public void mouseExit(MouseEvent e) {
                ((CLabel)e.widget).setForeground(e.display.getSystemColor(BreadcrumpItem.this.isLocked ? 2 : 15));
            }

            public void mouseEnter(MouseEvent e) {
                ((CLabel)e.widget).setForeground(e.display.getSystemColor(9));
            }
        });
        this.lable = ctrl;
        ctrl.setForeground(ctrl.getDisplay().getSystemColor(this.isLocked ? 2 : 2));
        this.updateLabel();
        this.hookMenu();
        ToolBar tb = new ToolBar(c, 0x800000);
        ToolItem ti = new ToolItem(tb, 0x800000);
        ti.setImage(ExtendedImageRegistry.getInstance().getImage(MapEditUtil.getImage((String)"full/other/collapse12x16.png")));
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BreadcrumpItem.this.parent.getNavigationManager().setCurrentIndexPosition(BreadcrumpItem.this.position);
                BreadCrumpViewer.INSTANCE.show(BreadcrumpItem.this.parent, BreadcrumpItem.this.position);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        tb.setVisible(this.expandable);
        RowData rd = new RowData();
        rd.exclude = !this.expandable;
        tb.setLayoutData((Object)rd);
        this.expandBar = tb;
        tb = new ToolBar(c, 0x800000);
        ti = new ToolItem(tb, 0x800000);
        ti.setImage(delete);
        ti.setHotImage(deleteHot);
        ti.setToolTipText(Messages.BreadcrumpItem_5);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    URI semanticObjectURI = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getEditedProcessURI();
                    MultiPageEditorHelper.closeSubActionProcessPageOrEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput(), semanticObjectURI);
                    BreadcrumpItem.this.parent.updateLastItem();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        rd = new RowData();
        rd.exclude = true;
        tb.setLayoutData((Object)rd);
        tb.setVisible(false);
        this.closeBar = tb;
    }

    private void createActions() {
        this.openMapping = new Action(Messages.BreadcrumpItem_14){

            public void run() {
                URI processURI = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getEditedProcessURI();
                if (processURI.isPlatformResource() && "indy.build".equals(processURI.segment(2))) {
                    String mapppingId = CacheHelper.extractFileID((String)processURI.fragment());
                    mapppingId = mapppingId.substring(0, mapppingId.indexOf("-proc"));
                    URI mapppingURI = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(mapppingId);
                    if (mapppingURI != null) {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(mapppingURI), "com.indy.map.diagram.part.MapDiagramEditorID");
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        this.openInEditor = new Action(Messages.BreadcrumpItem_6){

            public void run() {
                URI uri = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getEditedProcessURI();
                MultiPageEditorHelper.openPageOrEditor(uri, null, null);
            }
        };
        this.aquireLock = new Action(Messages.BreadcrumpItem_7){

            public void run() {
                URI uri = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getEditedProcess().eResource().getURI();
                try {
                    SharingReadOnlyEditingDomainFactory.getInstance().aquireLock(uri, BreadcrumpItem.this.parent.getNavigationManager().getEditingDomain().getID());
                }
                catch (IResourceLocker.AlreadyLockedException e1) {
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
        this.releaseLock = new Action(Messages.BreadcrumpItem_8){

            public void run() {
                URI uri = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getEditedProcess().eResource().getURI();
                SharingReadOnlyEditingDomainFactory.getInstance().releaseLock(uri, BreadcrumpItem.this.parent.getNavigationManager().getEditingDomain().getID());
                boolean needSave = false;
                URI semanticResourceURI = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getEditedProcessURI().trimFragment();
                Resource semanticResource = BreadcrumpItem.this.parent.getNavigationManager().getEditingDomain().getResourceSet().getResource(semanticResourceURI, false);
                Resource diagramResource = null;
                if (semanticResource != null) {
                    if (semanticResource.isModified()) {
                        needSave = true;
                    }
                    try {
                        StambiaURIHelper helper = new StambiaURIHelper(semanticResourceURI, null);
                        diagramResource = BreadcrumpItem.this.parent.getNavigationManager().getEditingDomain().getResourceSet().getResource(helper.getDiagramResourceUri(), false);
                        if (diagramResource != null && diagramResource.isModified()) {
                            needSave = true;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (needSave) {
                    if (MessageDialog.openQuestion((Shell)BreadcrumpItem.this.getControl().getShell(), (String)Messages.BreadcrumpItem_9, (String)Messages.bind((String)Messages.BreadcrumpItem_10, (Object)semanticResourceURI.toPlatformString(true)))) {
                        try {
                            if (semanticResource != null && semanticResource.isModified()) {
                                semanticResource.save(ProcDiagramEditorUtil.getSaveOptions());
                            }
                            if (diagramResource != null && diagramResource.isModified()) {
                                diagramResource.save(ProcDiagramEditorUtil.getSaveOptions());
                            }
                        }
                        catch (Exception ex) {
                            ProcDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.process.diagram.non_rcp", Messages.BreadcrumpItem_12, (Throwable)ex));
                        }
                    } else {
                        if (semanticResource != null) {
                            semanticResource.unload();
                        }
                        if (diagramResource != null && diagramResource.isModified()) {
                            diagramResource.unload();
                        }
                        try {
                            IEditorInput input = ((IEditorPart)((MultiPageEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getSelectedPage()).getEditorInput();
                            ProcDiagramEditorPlugin.getInstance().getDocumentProvider().resetDocument(input);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        };
        this.goToEdition = new Action(Messages.BreadcrumpItem_13){

            public void run() {
                URI uri = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getEditedProcessURI();
                String editingDomainId = SharingReadOnlyEditingDomainFactory.getInstance().getLockOwnerEditingDomainId(uri.trimFragment());
                if (editingDomainId != null) {
                    TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(editingDomainId);
                    IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                    int n = iEditorReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditingDomainProvider p;
                        IEditorReference ref = iEditorReferenceArray[n2];
                        IEditorPart part = ref.getEditor(false);
                        if (part != null && (p = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class)) != null && p.getEditingDomain() == editingDomain) {
                            MultiPageEditorHelper.openPageOrEditor(uri, null, part.getEditorInput());
                            break;
                        }
                        ++n2;
                    }
                }
            }
        };
    }

    private void hookMenu() {
        this.createActions();
        MenuManager mgr = new MenuManager();
        mgr.add((IAction)this.openMapping);
        mgr.add((IAction)this.openInEditor);
        mgr.add((IAction)this.goToEdition);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.aquireLock);
        mgr.add((IAction)this.releaseLock);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                URI rootURI = BreadcrumpItem.this.parent.getNavigationManager().getStep(0).getEditedProcessURI().trimFragment();
                URI u = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getEditedProcessURI().trimFragment();
                BreadcrumpItem.this.openInEditor.setEnabled(!u.equals(rootURI));
                BreadcrumpItem.this.releaseLock.setEnabled(SharingReadOnlyEditingDomainFactory.getInstance().hasLock(u, BreadcrumpItem.this.parent.getNavigationManager().getEditingDomain().getID()));
                BreadcrumpItem.this.aquireLock.setEnabled(SharingReadOnlyEditingDomainFactory.getInstance().canLock(u, BreadcrumpItem.this.parent.getNavigationManager().getEditingDomain().getID()));
                String editingDomainId = SharingReadOnlyEditingDomainFactory.getInstance().getLockOwnerEditingDomainId(u);
                if (editingDomainId != null && !editingDomainId.equals(BreadcrumpItem.this.parent.getNavigationManager().getEditingDomain().getID()) && !SharingReadOnlyEditingDomainFactory.getInstance().canLock(u, BreadcrumpItem.this.parent.getNavigationManager().getEditingDomain().getID())) {
                    BreadcrumpItem.this.goToEdition.setEnabled(true);
                } else {
                    if (editingDomainId != null && !editingDomainId.equals(BreadcrumpItem.this.parent.getNavigationManager().getEditingDomain().getID())) {
                        String s = SharingReadOnlyEditingDomainFactory.getInstance().getLockOwnerEditingDomainId(u);
                        if (s != null) {
                            BreadcrumpItem.this.goToEdition.setEnabled(true);
                        }
                    } else {
                        BreadcrumpItem.this.goToEdition.setEnabled(false);
                    }
                    BreadcrumpItem.this.openMapping.setEnabled(false);
                    u = BreadcrumpItem.this.parent.getNavigationManager().getStep(BreadcrumpItem.this.position).getEditedProcessURI();
                    if (u.isPlatformResource() && "indy.build".equals(u.segment(2))) {
                        String mapppingId = CacheHelper.extractFileID((String)u.fragment());
                        mapppingId = mapppingId.substring(0, mapppingId.indexOf("-proc"));
                        URI mapppingURI = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(mapppingId);
                        if (mapppingURI != null && "map".equals(mapppingURI.fileExtension())) {
                            BreadcrumpItem.this.openMapping.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.lable.setMenu(mgr.createContextMenu((Control)this.lable));
    }

    public void dispose() {
        this.lable.getParent().dispose();
        super.dispose();
    }

    public Control getControl() {
        return this.lable.getParent();
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        this.updateLabel();
    }

    public void setText(String string) {
        if (this.getText() != null && this.getText().startsWith("*")) {
            super.setText("*" + string.replace("&", "&&"));
        } else {
            super.setText(string.replace("&", "&&"));
        }
        this.updateLabel();
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.updateLabel();
    }

    public void setLast(boolean isLast) {
        if (isLast) {
            this.closeBar.setVisible(true);
            RowData rd = (RowData)this.closeBar.getLayoutData();
            rd.exclude = false;
            this.lable.layout(true);
        } else {
            RowData rd = (RowData)this.closeBar.getLayoutData();
            rd.exclude = true;
            this.closeBar.setVisible(false);
            this.lable.layout(true);
        }
    }

    private void updateLabel() {
        NavigationManager.Step step;
        if (this.lable != null && !this.lable.isDisposed()) {
            this.lable.setForeground(this.lable.getDisplay().getSystemColor(this.isLocked ? 2 : 15));
            this.lable.setText(this.getText());
            this.lable.setImage(this.getImage());
            this.lable.setToolTipText(this.tooltip);
            GC gc = new GC((Drawable)this.lable);
            gc.setFont(this.getCurrentFont());
            Object txt = this.getText();
            if (!((String)txt).startsWith("*")) {
                txt = "*" + (String)txt;
            }
            int width = gc.textExtent((String)txt).x;
            gc.dispose();
            width += this.getImage().getImageData().width;
            width += 5;
            this.lable.setLayoutData((Object)new RowData(++width, -1));
            this.lable.layout(true);
        }
        if (this.parent != null && this.position > -1 && (step = this.parent.getNavigationManager().getStep(this.position)) != null) {
            ActionProcess p = step.getEditedProcess();
            boolean bl = this.expandable = !p.getActionProcessRef().isEmpty() || !p.getSubProcess().isEmpty();
            if (this.expandBar != null && !this.expandBar.isDisposed()) {
                this.expandBar.setVisible(this.expandable);
                ((RowData)this.expandBar.getLayoutData()).exclude = !this.expandable;
            }
        }
    }

    public Point getPopupLocation() {
        if (this.expandBar != null) {
            Point itemLocation = this.expandBar.getLocation();
            itemLocation.y += this.expandBar.getSize().y;
            itemLocation.x -= this.lable.getSize().x;
            itemLocation = this.expandBar.toDisplay(itemLocation);
            return itemLocation;
        }
        return null;
    }

    public void setCurrent(boolean isCurrent) {
        if (isCurrent) {
            this.lable.setFont(this.getCurrentFont());
            this.lable.getParent().setBackground(FigureColoringHelper.getBackgoundColor());
            Control[] controlArray = this.lable.getParent().getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setBackground(FigureColoringHelper.getBackgoundColor());
                ++n2;
            }
        } else {
            this.lable.setFont(this.getBasicFont());
            this.lable.getParent().setBackground(this.lable.getDisplay().getSystemColor(22));
            Control[] controlArray = this.lable.getParent().getChildren();
            int n = controlArray.length;
            int n3 = 0;
            while (n3 < n) {
                Control c = controlArray[n3];
                c.setBackground(this.lable.getDisplay().getSystemColor(22));
                ++n3;
            }
        }
        this.parent.getControl().layout(true);
    }

    protected Font getCurrentFont() {
        if (bold == null) {
            FontDescriptor d = FontDescriptor.createFrom((Font)this.getBasicFont()).setStyle(1);
            bold = d.createFont((Device)this.lable.getDisplay());
        }
        return bold;
    }

    protected Font getBasicFont() {
        if (basique == null) {
            FontDescriptor d = FontDescriptor.createFrom((Font)this.lable.getFont());
            basique = d.createFont((Device)this.lable.getDisplay());
        }
        return basique;
    }

    public void setDirty(boolean isDirty) {
        if (isDirty) {
            if (!this.getText().startsWith("*")) {
                super.setText("*" + this.getText());
                this.updateLabel();
            }
        } else if (this.getText().startsWith("*")) {
            super.setText(this.getText().substring(1));
            this.updateLabel();
        }
    }
}

