/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.refactor;

import com.indy.gmf.proc.ActionProcessRef;
import com.indy.gmf.proc.ProcPackage;
import com.indy.map.MapPackage;
import com.indy.map.Template;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.stambia.md.Attribute;
import com.stambia.md.MdPackage;
import com.stambia.tpc.TpcPackage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

public class ProcUsageReplacer {
    private Collection<IFile> usageFiles;
    private URI replacementURI;
    private String replacedFileID;
    private String replacedEltID;
    ResourceSet rs;

    public ProcUsageReplacer(Collection<IFile> toUpdate, URI replacedObjectURI, URI replacementObjectURI) {
        this.usageFiles = toUpdate;
        this.replacedEltID = CacheHelper.extractEltID((String)replacedObjectURI.fragment());
        this.replacedFileID = CacheHelper.extractFileID((String)replacedObjectURI.fragment());
        this.replacementURI = URI.createURI((String)("foo#" + replacementObjectURI.fragment()));
    }

    public Map<IFile, ByteArrayOutputStream> replace() throws Exception {
        HashMap<IFile, ByteArrayOutputStream> cachedResults = new HashMap<IFile, ByteArrayOutputStream>();
        this.rs = new ResourceSetImpl();
        this.rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_UPDATE", Boolean.TRUE);
        this.rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING, Boolean.TRUE);
        this.rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, Boolean.TRUE);
        this.rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_REF_SYNC", Boolean.TRUE);
        for (IFile f : this.usageFiles) {
            try {
                cachedResults.put(f, this.convert(f));
            }
            catch (Exception ex) {
                throw new Exception("Failed to refactor the file " + String.valueOf(f.getFullPath()), ex);
            }
        }
        return cachedResults;
    }

    private ByteArrayOutputStream convert(IFile file) throws IOException {
        Resource resource = this.rs.getResource(Util.convertIFileToEMFURI((IFile)file), true);
        Mode mode = null;
        AnyType replacementProxy = XMLTypeFactory.eINSTANCE.createAnyType();
        ((InternalEObject)replacementProxy).eSetProxyURI(this.replacementURI);
        if (file.getFileExtension().equals("proc")) {
            mode = Mode.PROC;
        } else if (file.getFileExtension().equals("map")) {
            mode = Mode.MAP;
        } else if (file.getFileExtension().equals("tpc")) {
            mode = Mode.TPC;
        } else if (file.getFileExtension().equals("md")) {
            mode = Mode.MD;
        }
        CustomCrossReferencer ccr = new CustomCrossReferencer(mode, resource);
        ccr.perform();
        for (EObject o : ccr.keySet()) {
            for (EStructuralFeature.Setting s : (Collection)ccr.get(o)) {
                s.getEObject().eSet(s.getEStructuralFeature(), (Object)replacementProxy);
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        resource.save((OutputStream)bos, Collections.EMPTY_MAP);
        return bos;
    }

    class CustomCrossReferencer
    extends EcoreUtil.CrossReferencer {
        Mode mode;

        protected CustomCrossReferencer(Mode mode, Resource resource) {
            super(resource);
            this.mode = mode;
        }

        public void perform() {
            this.crossReference();
            this.done();
        }

        protected boolean resolve() {
            return false;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            String eltID = CacheHelper.extractEltID((EObject)crossReferencedEObject);
            String fileID = CacheHelper.extractFileID((EObject)crossReferencedEObject);
            if (eltID == null || fileID == null) {
                return false;
            }
            if (!fileID.equals(ProcUsageReplacer.this.replacedFileID) || !eltID.equals(ProcUsageReplacer.this.replacedEltID)) {
                return false;
            }
            switch (this.mode) {
                case PROC: {
                    return eObject instanceof ActionProcessRef && eReference == ProcPackage.eINSTANCE.getActionProcessRef_TargetName();
                }
                case MAP: {
                    return eObject instanceof Template && eReference == MapPackage.eINSTANCE.getTemplate_Process();
                }
                case TPC: {
                    return eObject instanceof com.stambia.tpc.Template && eReference == TpcPackage.eINSTANCE.getTemplate_Ref();
                }
                case MD: {
                    return eObject instanceof Attribute && (eReference == MdPackage.eINSTANCE.getAttribute_Ref() || eReference == MdPackage.eINSTANCE.getAttribute_Refs());
                }
            }
            return false;
        }
    }

    static enum Mode {
        PROC,
        MAP,
        MD,
        TPC;

    }
}

