/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.edit.commands;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.BindLink;
import com.indy.gmf.proc.diagram.non_rcp.edit.policies.ProcBaseItemSemanticEditPolicy;
import com.indy.gmf.proc.impl.ActionProcessImpl;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class BindLinkReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public BindLinkReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof BindLink)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Action) || !(this.newEnd instanceof Action)) {
            return false;
        }
        Action target = this.getLink().getTargetId();
        return ProcBaseItemSemanticEditPolicy.LinkConstraints.canExistBindLink_4002(this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Action) || !(this.newEnd instanceof Action)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Action)) {
            return false;
        }
        Action source = (Action)this.getLink().eContainer();
        Action target = this.getLink().getTargetId();
        if (target != null && target.eContainer() instanceof ActionProcess) {
            for (Action a : ((ActionProcessImpl)target.eContainer()).getAction()) {
                for (BindLink l : a.getBindLink()) {
                    if (l.getTargetId() != this.newEnd) continue;
                    return false;
                }
            }
        }
        return ProcBaseItemSemanticEditPolicy.LinkConstraints.canExistBindLink_4002(source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getBindLink().remove((Object)this.getLink());
        this.getNewSource().getBindLink().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTargetId(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected BindLink getLink() {
        return (BindLink)this.getElementToEdit();
    }

    protected Action getOldSource() {
        return (Action)this.oldEnd;
    }

    protected Action getNewSource() {
        return (Action)this.newEnd;
    }

    protected Action getOldTarget() {
        return (Action)this.oldEnd;
    }

    protected Action getNewTarget() {
        return (Action)this.newEnd;
    }
}

