/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.composite;

import com.indy.addons.Messages;
import com.indy.file.FileUtil;
import com.indy.file.composite.FileUiUtil;
import com.indy.file.composite.Normalizer;
import com.indy.jdbc.editor.Activator;
import com.indy.libraries.build.utils.StringUtils;
import com.indy.md.ui.editor.ui.MdControlManager;
import com.stambia.md.MdNode;
import java.io.File;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class FilePropertiesComposite
extends Composite {
    private static final Logger LOGGER = LogManager.getLogger(FilePropertiesComposite.class);
    private static final String LINE_TO_SKIP = "lineToSkip";
    private static final String LAST_LINE_TO_SKIP = "lastLineToSkip";
    private static final String LINE_SIZE = "lineSize";
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private MdControlManager mcm;
    private Text nameField;
    private Text fileName;
    private Combo type;

    public abstract MdNode getFile();

    public boolean isComplete() {
        return this.mcm.isComplete();
    }

    public FilePropertiesComposite(Composite parent, int style) {
        super(parent, style);
        Text lineSize;
        Label labelLineSize;
        FilePropertiesComposite composite = this;
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData(new GridData(1808));
        composite.setFont(parent.getFont());
        Composite nameGroup = new Composite((Composite)composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        nameGroup.setLayoutData((Object)data);
        this.mcm = new MdControlManager();
        Label label = new Label(nameGroup, 64);
        label.setText("Name");
        this.nameField = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.nameField, this.getFile(), null, 3, true, false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.nameField.setLayoutData((Object)data);
        label = new Label(nameGroup, 64);
        this.mcm.addControl((Control)label, this.getFile(), "physicalName", 0, false, false);
        this.fileName = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.fileName, this.getFile(), "physicalName", 1, true, true);
        data = new GridData(768);
        data.widthHint = 250;
        this.fileName.setLayoutData((Object)data);
        Button browse = new Button(nameGroup, 0);
        browse.setText(Messages.FilePropertiesComposite_2);
        browse.setLayoutData((Object)new GridData(768));
        label = new Label(nameGroup, 64);
        this.mcm.addControl((Control)label, this.getFile(), "type", 0, false, false);
        this.type = new Combo(nameGroup, 2060);
        this.mcm.addControl((Control)this.type, this.getFile(), "type", 1, true, false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.type.setLayoutData((Object)data);
        if (this.getFile().getLevel().getAttributeByXmlName("charsetName") != null) {
            label = new Label(nameGroup, 64);
            Combo comboEncoding = new Combo(nameGroup, 2048);
            new Label(nameGroup, 0);
            this.addComboText(nameGroup, "charsetName", label, comboEncoding, null, false);
        }
        this.addComboText(nameGroup, "lineSeparator", null, null, null, true);
        label = new Label(nameGroup, 64);
        Combo comboFieldSeparator = new Combo(nameGroup, 2048);
        Text fieldSeparator = new Text(nameGroup, 2048);
        String region = com.indy.ui.custom.out.Activator.getDefault().readProperty("osgi.nl");
        if (region != null && region.startsWith("fr_")) {
            this.addComboText(nameGroup, "fieldSeparator", label, comboFieldSeparator, fieldSeparator, true, "3B");
        } else {
            this.addComboText(nameGroup, "fieldSeparator", label, comboFieldSeparator, fieldSeparator, true);
        }
        if (FileUtil.getType(this.getFile()).equals("POSITIONAL")) {
            comboFieldSeparator.setEnabled(false);
            fieldSeparator.setEnabled(false);
        }
        label = new Label(nameGroup, 64);
        Combo comboStringDelimiter = new Combo(nameGroup, 2048);
        Text stringDelimiter = new Text(nameGroup, 2048);
        this.addComboText(nameGroup, "stringDelimiter", label, comboStringDelimiter, stringDelimiter, true);
        if (FileUtil.getType(this.getFile()).equals("POSITIONAL")) {
            comboStringDelimiter.setEnabled(false);
            stringDelimiter.setEnabled(false);
        }
        this.addComboText(nameGroup, "decimalSeparator", null, null, null, true);
        Label labelEscapeChar = new Label(nameGroup, 0);
        ControlDecoration deco = new ControlDecoration((Control)labelEscapeChar, 0x1020000);
        deco.setDescriptionText(Messages.FilePropertiesComposite_61);
        deco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        deco.setShowHover(true);
        deco.setShowOnlyOnFocus(false);
        this.mcm.addControl((Control)labelEscapeChar, this.getFile(), "escapeChar", 0, false, false);
        Text escapeChar = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)escapeChar, this.getFile(), "escapeChar", 1, true, false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        escapeChar.setLayoutData((Object)data);
        VerifyListener numericVerif = e -> {
            e.doit = e.text.matches("[\\-]?[0-9]*");
        };
        if (this.getFile().getLevel().getAttributeByXmlName(LINE_TO_SKIP) != null) {
            Label labelLineToSkip = new Label(nameGroup, 0);
            this.mcm.addControl((Control)labelLineToSkip, this.getFile(), LINE_TO_SKIP, 0, false, false);
            Text nbLineToSkip = new Text(nameGroup, 2048);
            this.mcm.addControl((Control)nbLineToSkip, this.getFile(), LINE_TO_SKIP, 1, true, false);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = 250;
            nbLineToSkip.setLayoutData((Object)data);
            nbLineToSkip.addVerifyListener(numericVerif);
        }
        if (this.getFile().getLevel().getAttributeByXmlName(LAST_LINE_TO_SKIP) != null) {
            labelLineSize = new Label(nameGroup, 0);
            this.mcm.addControl((Control)labelLineSize, this.getFile(), LAST_LINE_TO_SKIP, 0, false, false);
            lineSize = new Text(nameGroup, 2048);
            this.mcm.addControl((Control)lineSize, this.getFile(), LAST_LINE_TO_SKIP, 1, true, false);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = 250;
            lineSize.setLayoutData((Object)data);
        }
        if (this.getFile().getLevel().getAttributeByXmlName(LINE_SIZE) != null) {
            labelLineSize = new Label(nameGroup, 0);
            this.mcm.addControl((Control)labelLineSize, this.getFile(), LINE_SIZE, 0, false, false);
            lineSize = new Text(nameGroup, 2048);
            this.mcm.addControl((Control)lineSize, this.getFile(), LINE_SIZE, 1, true, false);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = 250;
            lineSize.setLayoutData((Object)data);
        }
        Label labelHeader = new Label(nameGroup, 0);
        this.mcm.addControl((Control)labelHeader, this.getFile(), "header", 0, false, false);
        Text nbHeader = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)nbHeader, this.getFile(), "header", 1, true, false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        nbHeader.setLayoutData((Object)data);
        nbHeader.addVerifyListener(numericVerif);
        Group previouGroup = new Group((Composite)composite, 0);
        previouGroup.setText(Messages.FilePropertiesComposite_26);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        previouGroup.setLayout((Layout)layout);
        data = new GridData(4, 4, true, true);
        previouGroup.setLayoutData((Object)data);
        Label labelNbPreview = new Label((Composite)previouGroup, 0);
        labelNbPreview.setText(Messages.FilePropertiesComposite_27);
        final Text nbLine = new Text((Composite)previouGroup, 2048);
        nbLine.setText("100");
        Button refresh = new Button((Composite)previouGroup, 0);
        refresh.setText(Messages.FilePropertiesComposite_29);
        data = new GridData(768);
        refresh.setLayoutData((Object)data);
        final TextViewer preview = new TextViewer((Composite)previouGroup, 68378);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        data.heightHint = 75;
        preview.getControl().setLayoutData((Object)data);
        preview.getControl().setFont(FileUiUtil.get_Font());
        preview.setDocument((IDocument)new Document());
        this.mcm.init();
        this.mcm.addListener(this::handleModification);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String currentPath = null;
                EObject o = FilePropertiesComposite.this.getFile().eContainer();
                File parentFile = null;
                try {
                    currentPath = FilePropertiesComposite.this.getFile().evaluateXpathExpression("INTERNAL_PATH");
                    parentFile = new File(((MdNode)o).evaluateXpathExpression("INTERNAL_PATH"));
                }
                catch (XPathExpressionException e) {
                    LOGGER.warn("unexpected", (Throwable)e);
                }
                File curFile = new File(currentPath);
                String filter = null;
                filter = curFile.exists() && curFile.isFile() ? currentPath : (parentFile != null ? parentFile.getAbsolutePath() : currentPath);
                FileDialog fdlg = new FileDialog(FilePropertiesComposite.this.getShell(), 4096);
                fdlg.setFilterPath(filter);
                String file = fdlg.open();
                if (file != null) {
                    File f = new File(file);
                    if (parentFile != null && f.getParentFile().getAbsolutePath().equalsIgnoreCase(parentFile.getAbsolutePath())) {
                        if (FilePropertiesComposite.this.nameField.getText() == null || FilePropertiesComposite.this.nameField.getText().equals("")) {
                            FilePropertiesComposite.this.nameField.setText(Normalizer.normalize(f.getName()));
                        }
                        FilePropertiesComposite.this.fileName.setText(f.getName());
                    } else {
                        MessageDialog.openInformation((Shell)FilePropertiesComposite.this.getShell(), (String)Messages.FilePropertiesComposite_4, (String)NLS.bind((String)Messages.FilePropertiesComposite_5, (Object)currentPath));
                    }
                }
            }
        });
        this.type.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilePropertiesComposite.this.handleModification(e);
            }
        });
        nbLine.addVerifyListener(e -> {
            e.doit = e.text.matches("[0-9]*");
        });
        refresh.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                preview.getDocument().set("");
                try {
                    int nb = nbLine.getText().equals("") ? 0 : Integer.valueOf(nbLine.getText());
                    String tmp = FileUtil.getPreviewData(FilePropertiesComposite.this.getFile(), nb, true);
                    preview.getControl().setFont(FileUiUtil.get_Font());
                    preview.getDocument().set(tmp);
                }
                catch (Exception e2) {
                    String message = "Error during refresh";
                    MessageDialog.openError((Shell)FilePropertiesComposite.this.getShell(), (String)Messages.FilePropertiesComposite_48, (String)e2.getMessage());
                    Activator.error(message, e2);
                }
            }
        });
        this.mcm.addListener(event -> {
            if (event.control.equals(this.type)) {
                try {
                    String str = event.node.evaluate("@type");
                    if (str != null && str.equals("DELIMITED")) {
                        comboFieldSeparator.setEnabled(true);
                        fieldSeparator.setEnabled(true);
                        comboStringDelimiter.setEnabled(true);
                        stringDelimiter.setEnabled(true);
                    } else {
                        comboFieldSeparator.setEnabled(false);
                        fieldSeparator.setEnabled(false);
                        comboStringDelimiter.setEnabled(false);
                        stringDelimiter.setEnabled(false);
                    }
                }
                catch (XPathExpressionException e) {
                    LOGGER.warn("unexpected", (Throwable)e);
                }
            }
        });
    }

    public Text getNameField() {
        return this.nameField;
    }

    public void addComboText(Composite composite, String name, Label paramLabel, Combo paramCombo, Text paramText, boolean hexa) {
        this.addComboText(composite, name, paramLabel, paramCombo, paramText, hexa, null);
    }

    private void addComboText(Composite composite, String name, Label paramLabel, Combo paramCombo, Text paramText, boolean hexa, String defaultValue) {
        Label label = paramLabel != null ? paramLabel : new Label(composite, 64);
        Combo combo = paramCombo != null ? paramCombo : new Combo(composite, 2048);
        this.mcm.addControl((Control)label, this.getFile(), name, 0, false, false);
        try {
            String xpath = this.getFile().getLevel().getAttributeByXmlName(name).getMdXpathAccess();
            Object list = this.getFile().evaluateMdSet(xpath);
            if (list instanceof List) {
                for (Object str : (List)list) {
                    if (hexa) {
                        combo.add(StringUtils.decodeHexString((String)str.toString(), (boolean)true));
                        continue;
                    }
                    combo.add(str.toString());
                }
            }
        }
        catch (XPathExpressionException e1) {
            LOGGER.warn("unexpected", (Throwable)e1);
        }
        GridData data = new GridData(768);
        data.widthHint = 250;
        combo.setLayoutData((Object)data);
        if (hexa) {
            Text text = paramText != null ? paramText : new Text(composite, 2048);
            text.setLayoutData((Object)new GridData(768));
            this.mcm.addControl((Control)text, this.getFile(), name, 1, true, defaultValue, false);
            Flag flagObject = new Flag();
            text.addModifyListener(e -> {
                if (flag.value > 0) {
                    flag.value = -1;
                } else {
                    flag.value = 1;
                    combo.setText(StringUtils.decodeHexString((String)text.getText(), (boolean)true));
                }
            });
            combo.addModifyListener(e -> {
                if (flag.value > 0) {
                    flag.value = -1;
                } else {
                    flag.value = 1;
                    text.setText(StringUtils.encodeHexString((String)combo.getText(), (boolean)true));
                }
            });
        } else {
            this.mcm.addControl((Control)combo, this.getFile(), name, 1, true, false);
        }
    }

    public abstract void handleModification(Object var1);

    public String isNameValid() {
        String tmp = this.nameField.getText();
        if (tmp != null && !tmp.isEmpty()) {
            if (!tmp.substring(0, 1).matches("[A-Za-z]")) {
                return Messages.FilePropertiesComposite_55;
            }
            if (tmp.matches("[^\\p{ASCII}]")) {
                return Messages.FilePropertiesComposite_57;
            }
            if (!tmp.matches("[A-Za-z0-9_]*")) {
                return Messages.FilePropertiesComposite_59;
            }
            return null;
        }
        return Messages.FilePropertiesComposite_60;
    }

    class Flag {
        int value = 0;

        Flag() {
        }
    }
}

