/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.xml.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class XMLDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;

    public void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        if (pos < 0) {
            return;
        }
        this.fText = part;
        this.selectWord(pos);
    }

    protected boolean selectComment(int caretPos) {
        int startPos;
        int pos;
        block8: {
            int c;
            IDocument doc;
            block7: {
                doc = this.fText.getDocument();
                pos = caretPos;
                c = 32;
                while (pos >= 0) {
                    c = doc.getChar(pos);
                    if (c == 92) {
                        pos -= 2;
                        continue;
                    }
                    if (c == 13 || c == 34) break;
                    --pos;
                }
                if (c == 34) break block7;
                return false;
            }
            try {
                startPos = pos;
                pos = caretPos;
                int length = doc.getLength();
                c = 32;
                while (pos < length) {
                    c = doc.getChar(pos);
                    if (c == 13 || c == 34) break;
                    ++pos;
                }
                if (c == 34) break block8;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        int endPos = pos;
        int offset = startPos + 1;
        int len = endPos - offset;
        this.fText.setSelectedRange(offset, len);
        return true;
    }

    protected boolean selectWord(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (c == '<') break;
                --pos;
            }
            int startPos = pos - 1;
            pos = startPos + 2;
            int length = doc.getLength();
            StringBuffer identifier = new StringBuffer();
            while (pos < length) {
                c = doc.getChar(pos);
                if (Character.isWhitespace(c) || c == '>') break;
                identifier.append(c);
                ++pos;
            }
            pos = startPos + identifier.length();
            StringBuffer endIdentifier = null;
            while (pos < length) {
                c = doc.getChar(pos);
                if (c == '<') {
                    endIdentifier = (c = doc.getChar(++pos)) == '/' ? new StringBuffer() : null;
                } else if (c == '>' && endIdentifier != null) {
                    if (endIdentifier.toString().equals(identifier.toString())) {
                        break;
                    }
                } else if (endIdentifier != null) {
                    endIdentifier.append(c);
                }
                ++pos;
            }
            int endPos = pos + 1;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void selectRange(int startPos, int stopPos) {
        int offset = startPos + 1;
        int length = stopPos - offset;
        this.fText.setSelectedRange(offset, length);
    }
}

